/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp.websocket;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import org.noear.solon.Utils;
import org.noear.solon.net.websocket.WebSocketTimeoutBase;
import org.smartboot.http.server.WebSocketRequest;
import org.smartboot.http.server.WebSocketResponse;
import org.smartboot.http.server.impl.WebSocketRequestImpl;

public class WebSocketImpl
extends WebSocketTimeoutBase {
    private final WebSocketRequestImpl request;
    private final WebSocketResponse real;

    public WebSocketImpl(WebSocketRequest request) {
        this.request = (WebSocketRequestImpl)request;
        this.real = this.request.getResponse();
        this.init(this.buildUri(request));
    }

    public URI buildUri(WebSocketRequest req) {
        if (Utils.isEmpty((String)req.getQueryString())) {
            return URI.create(req.getRequestURL());
        }
        if (req.getRequestURL().contains("?")) {
            return URI.create(req.getRequestURL());
        }
        return URI.create(req.getRequestURL() + "?" + req.getQueryString());
    }

    public boolean isValid() {
        return !this.isClosed();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public InetSocketAddress remoteAddress() {
        return this.request.getRemoteAddress();
    }

    public InetSocketAddress localAddress() {
        return this.request.getLocalAddress();
    }

    public void send(String text) {
        this.real.sendTextMessage(text);
        this.real.flush();
        this.onSend();
    }

    public void send(ByteBuffer binary) {
        this.real.sendBinaryMessage(binary.array());
        this.real.flush();
        this.onSend();
    }

    public void close() {
        super.close();
        this.real.close();
    }
}

