/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.utils;

import java.io.IOException;
import java.io.InputStream;

public class PostInputStream
extends InputStream {
    private InputStream inputStream;
    private int remaining;

    public PostInputStream(InputStream inputStream, int contentLength) {
        this.inputStream = inputStream;
        this.remaining = contentLength;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int size = this.inputStream.read(b, off, len);
        if (size > 0) {
            this.remaining -= size;
        }
        return size;
    }

    @Override
    public int available() {
        return this.remaining;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.remaining > 0) {
            --this.remaining;
            return this.inputStream.read();
        }
        return -1;
    }
}

