/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.smartboot.http.logging.RunLogger;
import sun.security.action.GetPropertyAction;

class LogFormatter
extends Formatter {
    private static final String format = "{0,date,yyyy-MM-dd} {0,time,HH:mm:ss.SS}";
    Date dat = new Date();
    String logClassName = RunLogger.class.getName();
    private MessageFormat formatter;
    private Object[] args = new Object[1];
    private String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));

    LogFormatter() {
    }

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        this.dat.setTime(record.getMillis());
        this.args[0] = this.dat;
        StringBuffer text = new StringBuffer();
        if (this.formatter == null) {
            this.formatter = new MessageFormat(format);
        }
        this.formatter.format(this.args, text, (FieldPosition)null);
        sb.append("[").append(text).append("] [");
        sb.append(record.getLevel().getName());
        sb.append("] ");
        sb.append("[" + Thread.currentThread().getName() + "] ");
        StackTraceElement[] stackElement = new Throwable().getStackTrace();
        boolean lookingForLogger = true;
        for (StackTraceElement stack : stackElement) {
            String cname = stack.getClassName();
            if (lookingForLogger) {
                if (!cname.matches(this.logClassName)) continue;
                lookingForLogger = false;
                continue;
            }
            if (cname.matches(this.logClassName)) continue;
            String simpleClassName = cname.substring(cname.lastIndexOf(".") + 1);
            sb.append("[" + simpleClassName + "(" + stack.getMethodName() + ":" + stack.getLineNumber() + ")]");
            break;
        }
        String message = this.formatMessage(record);
        sb.append(message);
        if (record.getThrown() != null) {
            try {
                sb.append(this.lineSeparator);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        sb.append(this.lineSeparator);
        return sb.toString();
    }
}

