/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jdkhttp;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerLifecycle;
import org.noear.solon.boot.jdkhttp.JdkHttpContextHandler;
import org.noear.solon.boot.jdkhttp.ParameterFilter;
import org.noear.solon.boot.ssl.SslConfig;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.lang.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkHttpServer
implements ServerLifecycle {
    static final Logger log = LoggerFactory.getLogger(JdkHttpServer.class);
    private HttpServer server = null;
    private Executor executor;
    private Handler handler;
    private SslConfig sslConfig = new SslConfig("http");
    private boolean isSecure;

    public boolean isSecure() {
        return this.isSecure;
    }

    public void enableSsl(boolean enable, @Nullable SSLContext sslContext) {
        this.sslConfig.set(enable, sslContext);
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void start(String host, int port) throws Throwable {
        if (this.sslConfig.isSslEnable()) {
            this.server = Utils.isNotEmpty((String)host) ? HttpsServer.create(new InetSocketAddress(host, port), 0) : HttpsServer.create(new InetSocketAddress(port), 0);
            this.addSslConfig((HttpsServer)this.server, this.sslConfig.getSslContext());
            this.isSecure = true;
        } else {
            this.server = Utils.isNotEmpty((String)host) ? HttpServer.create(new InetSocketAddress(host, port), 0) : HttpServer.create(new InetSocketAddress(port), 0);
        }
        HttpContext httpContext = this.server.createContext("/", new JdkHttpContextHandler(this.handler));
        httpContext.getFilters().add(new ParameterFilter());
        this.server.setExecutor(this.executor);
        this.server.start();
    }

    public void stop() throws Throwable {
        if (this.server != null) {
            this.server.stop(0);
            this.server = null;
        }
    }

    private void addSslConfig(HttpsServer httpsServer, SSLContext sslContext) throws IOException {
        httpsServer.setHttpsConfigurator(new HttpsConfigurator(sslContext){

            @Override
            public void configure(HttpsParameters params) {
                try {
                    SSLContext c = SSLContext.getDefault();
                    SSLEngine engine = c.createSSLEngine();
                    params.setNeedClientAuth(false);
                    params.setCipherSuites(engine.getEnabledCipherSuites());
                    params.setProtocols(engine.getEnabledProtocols());
                    SSLParameters defaultSSLParameters = c.getDefaultSSLParameters();
                    params.setSSLParameters(defaultSSLParameters);
                }
                catch (Throwable e) {
                    log.warn(e.getMessage(), e);
                }
            }
        });
    }
}

