/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jdkhttp;

import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpExchange;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.noear.solon.boot.ServerProps;

public class ParameterFilter
extends Filter {
    private static final Pattern pattern_and = Pattern.compile("&");
    private static final Pattern pattern_eq = Pattern.compile("=");

    @Override
    public String description() {
        return "Parses the requested URI for parameters";
    }

    @Override
    public void doFilter(HttpExchange exchange, Filter.Chain chain) throws IOException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        exchange.setAttribute("parameters", parameters);
        this.parseGetParameters(exchange, parameters);
        this.parsePostParameters(exchange, parameters);
        chain.doFilter(exchange);
    }

    private void parseGetParameters(HttpExchange exchange, Map<String, Object> parameters) throws UnsupportedEncodingException {
        URI requestedUri = exchange.getRequestURI();
        String query = requestedUri.getRawQuery();
        this.parseQuery(query, parameters);
    }

    private void parsePostParameters(HttpExchange exchange, Map<String, Object> parameters) throws IOException {
        String method = exchange.getRequestMethod();
        if ("POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method) || "DELETE".equalsIgnoreCase(method) || "PATCH".equalsIgnoreCase(method)) {
            String ct = exchange.getRequestHeaders().getFirst("Content-Type");
            if (ct == null) {
                return;
            }
            if (!ct.toLowerCase(Locale.US).startsWith("application/x-www-form-urlencoded")) {
                return;
            }
            InputStreamReader isr = new InputStreamReader(exchange.getRequestBody(), ServerProps.request_encoding);
            BufferedReader br = new BufferedReader(isr);
            String query = br.readLine();
            this.parseQuery(query, parameters);
        }
    }

    private void parseQuery(String query, Map<String, Object> parameters) throws UnsupportedEncodingException {
        if (query != null && query.length() > 0) {
            String[] pairs;
            for (String pair : pairs = pattern_and.split(query)) {
                String[] param = pattern_eq.split(pair);
                String key = null;
                String value = null;
                if (param.length > 0) {
                    key = URLDecoder.decode(param[0], ServerProps.request_encoding);
                }
                value = param.length > 1 ? URLDecoder.decode(param[1], ServerProps.request_encoding) : "";
                if (parameters.containsKey(key)) {
                    ArrayList<String> values;
                    Object obj = parameters.get(key);
                    if (obj instanceof List) {
                        values = (ArrayList<String>)obj;
                        values.add(value);
                        continue;
                    }
                    if (!(obj instanceof String)) continue;
                    values = new ArrayList<String>();
                    values.add((String)obj);
                    values.add(value);
                    parameters.put(key, values);
                    continue;
                }
                parameters.put(key, value);
            }
        }
    }
}

