/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.staticfiles;

import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.util.DateUtil;
import org.noear.solon.server.prop.GzipProps;
import org.noear.solon.server.util.OutputUtils;
import org.noear.solon.web.staticfiles.StaticConfig;
import org.noear.solon.web.staticfiles.StaticMappings;
import org.noear.solon.web.staticfiles.StaticMimes;

public class StaticResourceHandler
implements Handler {
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final Date modified_time = new Date();

    public void handle(Context ctx) throws Exception {
        if (ctx.getHandled()) {
            return;
        }
        if (!MethodType.GET.name.equals(ctx.method())) {
            return;
        }
        String path = ctx.pathNew();
        String suffix = this.findByExtName(path);
        if (Utils.isEmpty((String)suffix)) {
            return;
        }
        String conentType = StaticMimes.findByExt(suffix);
        if (Utils.isEmpty((String)conentType)) {
            conentType = Utils.mime((String)suffix);
        }
        if (Utils.isEmpty((String)conentType)) {
            return;
        }
        URL resUri = null;
        String resUriZiped = null;
        String acceptEncoding = ctx.headerOrDefault("Accept-Encoding", "");
        if (GzipProps.hasMime((String)conentType)) {
            if (acceptEncoding.contains("gzip") && (resUri = StaticMappings.find(path + ".gz")) != null) {
                resUriZiped = "gzip";
            }
            if (resUri == null && acceptEncoding.contains("br") && (resUri = StaticMappings.find(path + ".br")) != null) {
                resUriZiped = "br";
            }
        }
        if (resUri == null) {
            resUri = StaticMappings.find(path);
        }
        if (resUri != null) {
            Throwable throwable;
            InputStream stream;
            ctx.setHandled(true);
            if (StaticConfig.getCacheMaxAge() > 0) {
                String modified_since = ctx.header("If-Modified-Since");
                String modified_now = DateUtil.toGmtString((Date)modified_time);
                if (modified_since != null && modified_since.equals(modified_now)) {
                    ctx.headerSet(CACHE_CONTROL, "max-age=" + StaticConfig.getCacheMaxAge());
                    ctx.headerSet(LAST_MODIFIED, modified_now);
                    ctx.status(304);
                    return;
                }
                ctx.headerSet(CACHE_CONTROL, "max-age=" + StaticConfig.getCacheMaxAge());
                ctx.headerSet(LAST_MODIFIED, modified_now);
            }
            if ("br".equals(resUriZiped) && acceptEncoding.contains("br")) {
                stream = resUri.openStream();
                throwable = null;
                try {
                    ctx.contentType(conentType);
                    ctx.headerSet("Vary", "Accept-Encoding");
                    ctx.headerSet("Content-Encoding", "br");
                    OutputUtils.global().outputStreamAsRange(ctx, stream, (long)stream.available());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream != null) {
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            stream.close();
                        }
                    }
                }
                return;
            }
            if ("gzip".equals(resUriZiped) && acceptEncoding.contains("gzip")) {
                stream = resUri.openStream();
                throwable = null;
                try {
                    ctx.contentType(conentType);
                    ctx.headerSet("Vary", "Accept-Encoding");
                    ctx.headerSet("Content-Encoding", "gzip");
                    OutputUtils.global().outputStreamAsRange(ctx, stream, (long)stream.available());
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (stream != null) {
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            stream.close();
                        }
                    }
                }
                return;
            }
            OutputUtils.global().outputFile(ctx, resUri, conentType, StaticConfig.getCacheMaxAge() >= 0);
        }
    }

    private String findByExtName(String path) {
        int pos = path.lastIndexOf(35);
        if (pos > 0) {
            path = path.substring(0, pos - 1);
        }
        pos = path.lastIndexOf(46);
        pos = Math.max(pos, path.lastIndexOf(47));
        if ((pos = Math.max(pos, path.lastIndexOf(63))) != -1 && path.charAt(pos) == '.') {
            return path.substring(pos).toLowerCase();
        }
        return null;
    }
}

