/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.vertx.websocket;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketFrame;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.websocket.SubProtocolCapable;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketBase;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.noear.solon.server.util.DecodeUtils;
import org.noear.solon.server.vertx.websocket.VxWebSocketImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VxWebSocketHandlerImpl
implements Handler<ServerWebSocket> {
    static final Logger log = LoggerFactory.getLogger(VxWebSocketHandlerImpl.class);
    private final WebSocketRouter webSocketRouter = WebSocketRouter.getInstance();

    public void subProtocolCapable(HttpServerRequest req) {
        List requestProtocols;
        String protocols;
        String path = DecodeUtils.rinseUri((String)req.path());
        SubProtocolCapable subProtocolCapable = this.webSocketRouter.getSubProtocol(path);
        if (subProtocolCapable != null && Utils.isNotEmpty((String)(protocols = subProtocolCapable.getSubProtocols((Collection)(requestProtocols = req.headers().getAll("Sec-WebSocket-Protocol")))))) {
            String[] protocolArr;
            for (String sp : protocolArr = protocols.split(",")) {
                for (String rp : requestProtocols) {
                    if (!sp.equalsIgnoreCase(rp)) continue;
                    return;
                }
            }
        }
        req.headers().remove("Sec-WebSocket-Protocol");
    }

    public void handle(ServerWebSocket sw) {
        VxWebSocketImpl webSocket = new VxWebSocketImpl(sw);
        sw.frameHandler(arg_0 -> this.lambda$handle$0((WebSocketBase)webSocket, arg_0));
        sw.pongHandler(arg_0 -> this.lambda$handle$1((WebSocketBase)webSocket, arg_0));
        sw.closeHandler(arg_0 -> this.lambda$handle$2((WebSocketBase)webSocket, arg_0));
        sw.exceptionHandler(arg_0 -> this.lambda$handle$3((WebSocketBase)webSocket, arg_0));
        this.onOpen(sw, (WebSocketBase)webSocket);
        sw.accept();
    }

    private void onOpen(ServerWebSocket request, WebSocketBase webSocket) {
        for (Map.Entry kv : request.headers()) {
            webSocket.paramMap().add((String)kv.getKey(), kv.getValue());
        }
        this.webSocketRouter.getListener().onOpen((WebSocket)webSocket);
    }

    private void onPing(WebSocketBase webSocket) {
        this.webSocketRouter.getListener().onPing((WebSocket)webSocket);
    }

    private void onPong(WebSocketBase webSocket) {
        this.webSocketRouter.getListener().onPong((WebSocket)webSocket);
    }

    private void onTextMessage(WebSocketBase webSocket, String data) {
        try {
            this.webSocketRouter.getListener().onMessage((WebSocket)webSocket, data);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    private void onBinaryMessage(WebSocketBase webSocket, byte[] data) {
        try {
            this.webSocketRouter.getListener().onMessage((WebSocket)webSocket, ByteBuffer.wrap(data));
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    private void onClose(WebSocketBase webSocket) {
        if (webSocket.isClosed()) {
            return;
        }
        RunUtil.runAndTry(() -> ((WebSocketBase)webSocket).close());
        this.webSocketRouter.getListener().onClose((WebSocket)webSocket);
    }

    private void onError(WebSocketBase webSocket, Throwable error) {
        try {
            this.webSocketRouter.getListener().onError((WebSocket)webSocket, error);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    private /* synthetic */ void lambda$handle$3(WebSocketBase webSocket, Throwable error) {
        this.onError(webSocket, error);
    }

    private /* synthetic */ void lambda$handle$2(WebSocketBase webSocket, Void v) {
        this.onClose(webSocket);
    }

    private /* synthetic */ void lambda$handle$1(WebSocketBase webSocket, Buffer buf) {
        this.onPong(webSocket);
    }

    private /* synthetic */ void lambda$handle$0(WebSocketBase webSocket, WebSocketFrame frame) {
        switch (frame.type()) {
            case PING: {
                this.onPing(webSocket);
                break;
            }
            case TEXT: {
                this.onTextMessage(webSocket, frame.textData());
                break;
            }
            case BINARY: {
                this.onBinaryMessage(webSocket, frame.binaryData().getBytes());
            }
        }
    }
}

