/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;
import org.noear.solon.Utils;
import org.noear.solon.core.convert.Converter;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.lang.Nullable;
import org.noear.solon.serialization.EntityStringSerializer;
import org.noear.solon.serialization.fastjson.FastjsonDecl;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil2;

public class FastjsonStringSerializer
implements EntityStringSerializer {
    private static final String label = "/json";
    private static final FastjsonStringSerializer _default = new FastjsonStringSerializer();
    private FastjsonDecl<SerializeConfig, SerializerFeature> serializeConfig;
    private FastjsonDecl<ParserConfig, Feature> deserializeConfig;

    public static FastjsonStringSerializer getDefault() {
        return _default;
    }

    public FastjsonStringSerializer(JsonProps jsonProps) {
        this.loadJsonProps(jsonProps);
    }

    public FastjsonStringSerializer() {
    }

    public FastjsonDecl<SerializeConfig, SerializerFeature> getSerializeConfig() {
        if (this.serializeConfig == null) {
            this.serializeConfig = new FastjsonDecl(new SerializeConfig());
        }
        return this.serializeConfig;
    }

    public FastjsonDecl<ParserConfig, Feature> getDeserializeConfig() {
        if (this.deserializeConfig == null) {
            this.deserializeConfig = new FastjsonDecl(new ParserConfig());
        }
        return this.deserializeConfig;
    }

    public String mimeType() {
        return "application/json";
    }

    public Class<String> dataType() {
        return String.class;
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.contains(label) || mime.startsWith("application/x-ndjson");
    }

    public String name() {
        return "fastjson-json";
    }

    public String serialize(Object obj) throws IOException {
        return JSON.toJSONString((Object)obj, (SerializeConfig)this.getSerializeConfig().getConfig(), (SerializeFilter[])new SerializeFilter[0], null, (int)this.getSerializeConfig().getFeatures(), (SerializerFeature[])new SerializerFeature[0]);
    }

    public Object deserialize(String data, Type toType) throws IOException {
        Class toClz;
        if (toType == null) {
            return JSON.parse((String)data, (ParserConfig)this.getDeserializeConfig().getConfig(), (int)this.getDeserializeConfig().getFeatures());
        }
        if (toType instanceof Class && (toClz = (Class)toType).isAnonymousClass()) {
            toType = toClz.getGenericSuperclass();
        }
        return JSON.parseObject((String)data, (Type)toType, (ParserConfig)this.getDeserializeConfig().getConfig(), (int)this.getDeserializeConfig().getFeatures(), (Feature[])new Feature[0]);
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType(this.mimeType());
        }
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx, @Nullable Type bodyType) throws IOException {
        String data = ctx.bodyNew();
        if (Utils.isNotEmpty((String)data)) {
            return JSON.parse((String)data, (ParserConfig)this.getDeserializeConfig().getConfig(), (int)this.getDeserializeConfig().getFeatures());
        }
        return null;
    }

    public void addEncoder(Type clz, ObjectSerializer encoder) {
        this.getSerializeConfig().getConfig().put(clz, encoder);
        if (clz == Long.class) {
            this.getSerializeConfig().getConfig().put(Long.TYPE, encoder);
        } else if (clz == Integer.class) {
            this.getSerializeConfig().getConfig().put(Integer.TYPE, encoder);
        }
    }

    public <T> void addEncoder(Class<T> clz, Converter<T, Object> converter) {
        this.addEncoder(clz, (ser, obj, fieldName, fieldType, features) -> {
            Object val = converter.convert(obj);
            SerializeWriter out = ser.getWriter();
            if (val == null) {
                out.writeNull();
            } else if (val instanceof String) {
                out.writeString((String)val);
            } else if (val instanceof Number) {
                if (val instanceof Integer || val instanceof Long) {
                    out.writeLong(((Number)val).longValue());
                } else {
                    out.writeDouble(((Number)val).doubleValue(), false);
                }
            } else {
                throw new IllegalArgumentException("The result type of the converter is not supported: " + val.getClass().getName());
            }
        });
    }

    protected void loadJsonProps(JsonProps jsonProps) {
        if (jsonProps != null) {
            JsonPropsUtil2.dateAsFormat((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.dateAsTicks((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.boolAsInt((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.longAsString((EntityStringSerializer)this, (JsonProps)jsonProps);
            if (jsonProps.nullStringAsEmpty) {
                this.getSerializeConfig().addFeatures((SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty});
            }
            if (jsonProps.nullBoolAsFalse) {
                this.getSerializeConfig().addFeatures((SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullBooleanAsFalse});
            }
            if (jsonProps.nullNumberAsZero) {
                this.getSerializeConfig().addFeatures((SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullNumberAsZero});
            }
            if (jsonProps.nullArrayAsEmpty) {
                this.getSerializeConfig().addFeatures((SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullListAsEmpty});
            }
            if (jsonProps.nullAsWriteable) {
                this.getSerializeConfig().addFeatures((SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            }
            if (jsonProps.enumAsName) {
                this.getSerializeConfig().addFeatures((SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteEnumUsingName});
            }
        }
    }
}

