/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation.annotation;

import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.annotation.AssertFalse;

public class AssertFalseValidator
implements Validator<AssertFalse> {
    public static final AssertFalseValidator instance = new AssertFalseValidator();

    @Override
    public String message(AssertFalse anno) {
        return anno.message();
    }

    @Override
    public Class<?>[] groups(AssertFalse anno) {
        return anno.groups();
    }

    @Override
    public boolean isSupportValueType(Class<?> type) {
        return Boolean.class.isAssignableFrom(type) || type == Boolean.TYPE;
    }

    @Override
    public Result validateOfValue(AssertFalse anno, Object val, StringBuilder tmp) {
        if (val == null) {
            return Result.failure();
        }
        if (val instanceof Boolean) {
            if (Boolean.FALSE.equals(val)) {
                return Result.succeed();
            }
            return Result.failure();
        }
        return Result.failure();
    }

    @Override
    public Result validateOfContext(Context ctx, AssertFalse anno, String name, StringBuilder tmp) {
        String val = ctx.param(name);
        if (Utils.isEmpty((String)val)) {
            return Result.succeed();
        }
        if (!this.verify(val)) {
            return Result.failure((String)name);
        }
        return Result.succeed();
    }

    private boolean verify(String val) {
        return "false".equalsIgnoreCase(val) || "0".equals(val) || "no".equalsIgnoreCase(val) || "off".equalsIgnoreCase(val);
    }
}

