/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation.annotation;

import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.annotation.NotZero;
import org.noear.solon.validation.util.StringUtils;

public class NotZeroValidator
implements Validator<NotZero> {
    public static final NotZeroValidator instance = new NotZeroValidator();

    @Override
    public String message(NotZero anno) {
        return anno.message();
    }

    @Override
    public Class<?>[] groups(NotZero anno) {
        return anno.groups();
    }

    @Override
    public boolean isSupportValueType(Class<?> type) {
        return ClassUtil.isNumberType(type);
    }

    @Override
    public Result validateOfValue(NotZero anno, Object val0, StringBuilder tmp) {
        if (!(val0 instanceof Number)) {
            return Result.failure();
        }
        Number val = (Number)val0;
        if (val == null || val.longValue() == 0L) {
            return Result.failure();
        }
        return Result.succeed();
    }

    @Override
    public Result validateOfContext(Context ctx, NotZero anno, String name, StringBuilder tmp) {
        if (name == null) {
            for (String key : anno.value()) {
                String val = ctx.param(key);
                if (StringUtils.isInteger(val) && Long.parseLong(val) != 0L) continue;
                tmp.append(',').append(key);
            }
        } else {
            String val = ctx.param(name);
            if (!StringUtils.isInteger(val) || Long.parseLong(val) == 0L) {
                tmp.append(',').append(name);
            }
        }
        if (tmp.length() > 1) {
            return Result.failure((String)tmp.substring(1));
        }
        return Result.succeed();
    }
}

