/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.auth;

import java.util.Collection;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.noear.solon.auth.AuthFailureHandler;
import org.noear.solon.auth.AuthFailureHandlerDefault;
import org.noear.solon.auth.AuthProcessor;
import org.noear.solon.auth.AuthRule;
import org.noear.solon.auth.AuthRuleHandler;
import org.noear.solon.auth.impl.AuthRuleImpl;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChain;

public class AuthAdapter
implements Filter {
    private String loginUrl;
    private String authRulePathPrefix;
    private AuthRuleHandler authRuleHandler;
    private AuthProcessor authProcessor;
    private AuthFailureHandler authFailure = new AuthFailureHandlerDefault();
    private ReentrantLock SYNC_LOCK = new ReentrantLock();

    public String loginUrl() {
        return this.loginUrl;
    }

    public AuthAdapter loginUrl(String url) {
        this.loginUrl = url;
        return this;
    }

    public AuthAdapter addRule(Consumer<AuthRule> builder) {
        AuthRuleImpl rule = new AuthRuleImpl();
        builder.accept(rule);
        this.addRuleDo(rule);
        return this;
    }

    public AuthAdapter addRules(Collection<AuthRule> rules) {
        rules.forEach(r -> this.addRuleDo((AuthRule)r));
        return this;
    }

    private void addRuleDo(AuthRule rule) {
        this.SYNC_LOCK.lock();
        try {
            if (this.authRuleHandler == null) {
                this.authRuleHandler = new AuthRuleHandler();
                this.authRuleHandler.setPathPrefix(this.authRulePathPrefix);
            }
            this.authRuleHandler.addRule(rule);
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public String pathPrefix() {
        return this.authRulePathPrefix;
    }

    public AuthAdapter pathPrefix(String pathPrefix) {
        this.authRulePathPrefix = pathPrefix;
        if (this.authRuleHandler != null) {
            this.authRuleHandler.setPathPrefix(this.authRulePathPrefix);
        }
        return this;
    }

    public AuthProcessor processor() {
        return this.authProcessor;
    }

    public AuthAdapter processor(AuthProcessor processor) {
        this.authProcessor = processor;
        return this;
    }

    public AuthFailureHandler failure() {
        return this.authFailure;
    }

    public AuthAdapter failure(AuthFailureHandler handler) {
        this.authFailure = handler;
        return this;
    }

    public void doFilter(Context ctx, FilterChain chain) throws Throwable {
        if (this.authRuleHandler != null) {
            this.authRuleHandler.handle(ctx);
        }
        chain.doFilter(ctx);
    }
}

