/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http.impl.okhttp;

import com.moczul.ok2curl.CurlInterceptor;
import java.net.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.net.http.HttpSslSupplier;
import org.noear.solon.net.http.HttpUtils;
import org.noear.solon.net.http.HttpUtilsFactory;
import org.noear.solon.net.http.impl.HttpSslSupplierDefault;
import org.noear.solon.net.http.impl.okhttp.OkHttpInterceptor;
import org.noear.solon.net.http.impl.okhttp.OkHttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpUtilsFactory
implements HttpUtilsFactory {
    static final Logger log = LoggerFactory.getLogger(OkHttpUtilsFactory.class);
    private static final Supplier<Dispatcher> httpClientDispatcher = () -> {
        Dispatcher temp = new Dispatcher();
        temp.setMaxRequests(20000);
        temp.setMaxRequestsPerHost(10000);
        return temp;
    };
    private static final OkHttpUtilsFactory instance = new OkHttpUtilsFactory();
    private Map<Proxy, OkHttpClient> proxyClients = new ConcurrentHashMap<Proxy, OkHttpClient>();
    private OkHttpClient defaultClient = OkHttpUtilsFactory.createHttpClient(null, HttpSslSupplierDefault.getInstance());

    private static OkHttpClient createHttpClient(Proxy proxy, HttpSslSupplier sslProvider) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).dispatcher(httpClientDispatcher.get()).addInterceptor((Interceptor)OkHttpInterceptor.instance).sslSocketFactory(sslProvider.getSslContext().getSocketFactory(), sslProvider.getX509TrustManager()).hostnameVerifier(sslProvider.getHostnameVerifier());
        if (log.isDebugEnabled() && ClassUtil.hasClass(() -> CurlInterceptor.class)) {
            builder.addInterceptor((Interceptor)new CurlInterceptor(msg -> log.debug(msg)));
        }
        if (proxy != null) {
            builder.proxy(proxy);
        }
        return builder.build();
    }

    public static OkHttpUtilsFactory getInstance() {
        return instance;
    }

    protected OkHttpClient getClient(Proxy proxy, HttpSslSupplier sslProvider) {
        if (proxy == null) {
            return this.defaultClient;
        }
        return this.proxyClients.computeIfAbsent(proxy, k -> OkHttpUtilsFactory.createHttpClient(proxy, sslProvider));
    }

    @Override
    public HttpUtils http(String url) {
        return new OkHttpUtils(this, url);
    }
}

