/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.context;

import java.util.Map;
import java.util.function.Function;
import org.noear.solon.expression.exception.EvaluationException;
import org.noear.solon.expression.snel.PropertyHolder;
import org.noear.solon.expression.snel.ReflectionUtil;

public class StandardContext
implements Function<String, Object> {
    private final Object target;
    private final boolean isMap;

    public StandardContext(Object target) {
        this.target = target;
        this.isMap = target instanceof Map;
    }

    @Override
    public Object apply(String name) {
        if ("root".equals(name)) {
            return this.target;
        }
        if (this.isMap) {
            return ((Map)this.target).get(name);
        }
        PropertyHolder tmp = ReflectionUtil.getProperty(this.target.getClass(), name);
        try {
            return tmp.getValue(this.target);
        }
        catch (Throwable e) {
            throw new EvaluationException("Failed to access property: " + name, e);
        }
    }
}

