/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.docs.openapi3;

import io.swagger.solon.annotation.ApiNoAuthorize;
import io.swagger.solon.annotation.ApiRes;
import io.swagger.solon.annotation.ApiResProperty;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Gateway;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.route.Routing;
import org.noear.solon.core.route.VersionedTarget;
import org.noear.solon.core.util.GenericUtil;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.docs.DocDocket;
import org.noear.solon.docs.exception.DocException;
import org.noear.solon.docs.models.ApiContact;
import org.noear.solon.docs.models.ApiLicense;
import org.noear.solon.docs.openapi3.impl.ActionHolder;
import org.noear.solon.docs.openapi3.impl.BuilderHelper;
import org.noear.solon.docs.openapi3.impl.ParamHolder;

public class OpenApi3Builder {
    private final OpenAPI openAPI = new OpenAPI();
    private final DocDocket docket;

    public OpenApi3Builder(DocDocket docket) {
        this.docket = docket;
    }

    public OpenAPI build() {
        this.openAPI.setComponents(new Components());
        this.openAPI.setPaths(new Paths());
        if (this.docket.globalResult() != null) {
            this.parseSchema(this.docket.globalResult(), this.docket.globalResult());
        }
        this.parseGroupPackage();
        ApiLicense apiLicense = this.docket.info().license();
        ApiContact apiContact = this.docket.info().contact();
        this.openAPI.info(new Info().title(this.docket.info().title()).description(this.docket.info().description()).termsOfService(this.docket.info().termsOfService()).version(this.docket.info().version()));
        if (apiLicense != null) {
            License license = new License().url(apiLicense.url()).name(apiLicense.name());
            license.setExtensions(apiLicense.vendorExtensions());
            this.openAPI.getInfo().setLicense(license);
        }
        if (apiContact != null) {
            Contact contact = new Contact().email(apiContact.email()).name(apiContact.name()).url(apiContact.url());
            contact.setExtensions(apiContact.vendorExtensions());
            this.openAPI.getInfo().setContact(contact);
        }
        Server server = new Server();
        server.url(BuilderHelper.getHost(this.docket));
        this.openAPI.addServersItem(server);
        if (this.docket.externalDocs() != null) {
            ExternalDocumentation externalDocumentation = new ExternalDocumentation();
            externalDocumentation.setDescription(this.docket.externalDocs().description());
            externalDocumentation.setUrl(this.docket.externalDocs().url());
            this.openAPI.setExternalDocs(externalDocumentation);
        }
        if (this.docket.securityExtensions() != null) {
            for (Map.Entry entry : this.docket.securityExtensions().entrySet()) {
                if (!(entry.getValue() instanceof SecurityScheme)) continue;
                SecurityScheme securityScheme = (SecurityScheme)entry.getValue();
                if (this.openAPI.getComponents().getSecuritySchemes() == null) {
                    this.openAPI.getComponents().setSecuritySchemes(new LinkedHashMap());
                }
                this.openAPI.getComponents().addSecuritySchemes((String)entry.getKey(), securityScheme);
            }
        }
        List tags = this.openAPI.getTags();
        this.openAPI.setTags(tags.stream().collect(Collectors.groupingBy(io.swagger.v3.oas.models.tags.Tag::getName)).values().stream().map(i -> (io.swagger.v3.oas.models.tags.Tag)i.get(0)).collect(Collectors.toList()));
        return this.openAPI;
    }

    private void parseGroupPackage() {
        Map<Class<?>, List<ActionHolder>> classMap = this.getApiAction();
        for (Map.Entry<Class<?>, List<ActionHolder>> kv : classMap.entrySet()) {
            this.parseController(kv.getKey(), kv.getValue());
        }
    }

    private Map<Class<?>, List<ActionHolder>> getApiAction() {
        HashMap apiMap = new HashMap(16);
        Collection routingCollection = Solon.app().router().findAll();
        for (Routing routing : routingCollection) {
            for (VersionedTarget vt : routing.targets()) {
                if (vt.getTarget() instanceof Action) {
                    this.resolveAction(apiMap, (Routing<Handler>)routing, (Action)vt.getTarget());
                }
                if (!(vt.getTarget() instanceof Gateway)) continue;
                for (Routing routing2 : ((Gateway)vt.getTarget()).getMainRouting().getAll()) {
                    for (VersionedTarget vt2 : routing2.targets()) {
                        if (!(vt2.getTarget() instanceof Action)) continue;
                        this.resolveAction(apiMap, (Routing<Handler>)routing2, (Action)vt2.getTarget());
                    }
                }
            }
        }
        return apiMap;
    }

    private void resolveAction(Map<Class<?>, List<ActionHolder>> apiMap, Routing<Handler> routing, Action action) {
        Class controller = action.controller().clz();
        boolean matched = this.docket.apis().stream().anyMatch(res -> res.test(action));
        if (!matched) {
            return;
        }
        ActionHolder actionHolder = new ActionHolder(routing, action);
        if (apiMap.containsKey(controller)) {
            List<ActionHolder> actionHolders;
            if (action.method().isAnnotationPresent(io.swagger.v3.oas.annotations.Operation.class) && !(actionHolders = apiMap.get(controller)).contains(actionHolder)) {
                actionHolders.add(actionHolder);
                apiMap.put(controller, actionHolders);
            }
        } else if (controller.isAnnotationPresent(Tag.class) && action.method().isAnnotationPresent(io.swagger.v3.oas.annotations.Operation.class)) {
            ArrayList<ActionHolder> actionHolders = new ArrayList<ActionHolder>();
            actionHolders.add(actionHolder);
            apiMap.put(controller, actionHolders);
        }
    }

    private void parseController(Class<?> clazz, List<ActionHolder> actionHolders) {
        Tag api = clazz.getAnnotation(Tag.class);
        if (api != null && Utils.isNotEmpty((String)api.name())) {
            io.swagger.v3.oas.models.tags.Tag tag = new io.swagger.v3.oas.models.tags.Tag();
            tag.setName(api.name());
            tag.setDescription(api.description());
            this.openAPI.addTagsItem(tag);
        }
        this.parseAction(actionHolders);
    }

    private void parseAction(List<ActionHolder> actionHolders) {
        for (ActionHolder actionHolder : actionHolders) {
            io.swagger.v3.oas.annotations.Operation apiAction = actionHolder.getAnnotation(io.swagger.v3.oas.annotations.Operation.class);
            if (apiAction.hidden()) continue;
            String controllerKey = BuilderHelper.getControllerKey(actionHolder.controllerClz());
            String actionName = actionHolder.action().name();
            Method actionMethod = actionHolder.action().method().getMethod();
            Set<String> actionTags = actionHolder.getTags(apiAction);
            String pathKey = actionHolder.routing().path();
            PathItem path = (PathItem)this.openAPI.getPaths().get((Object)pathKey);
            if (path == null) {
                path = new PathItem();
                this.openAPI.path(pathKey, path);
            }
            Operation operation = new Operation();
            operation.setTags(new ArrayList<String>(actionTags));
            operation.setSummary(apiAction.summary());
            operation.setDescription(apiAction.description());
            operation.setDeprecated(Boolean.valueOf(actionHolder.isAnnotationPresent(Deprecated.class)));
            String operationMethod = BuilderHelper.getHttpMethod(actionHolder, apiAction);
            List<io.swagger.v3.oas.models.parameters.Parameter> parameters = this.parseActionParameters(actionHolder);
            operation.setParameters(parameters);
            operation.setResponses(this.parseActionResponse(controllerKey, actionName, actionMethod));
            if (Utils.isBlank((String)apiAction.operationId())) {
                operation.setOperationId(operationMethod + "_" + pathKey.replace("/", "_"));
            } else {
                operation.setOperationId(apiAction.operationId());
            }
            if (!(actionHolder.isAnnotationPresent(ApiNoAuthorize.class) || actionHolder.controllerClz().isAnnotationPresent(ApiNoAuthorize.class) || this.docket.securityExtensions() == null || this.docket.securityExtensions().isEmpty())) {
                for (String securityName : this.docket.securityExtensions().keySet()) {
                    SecurityRequirement securityRequirement = new SecurityRequirement();
                    securityRequirement.addList(securityName);
                    operation.addSecurityItem(securityRequirement);
                }
            }
            Class<PathItem> pathItemClass = PathItem.class;
            try {
                pathItemClass.getDeclaredMethod(operationMethod.toLowerCase(), Operation.class).invoke((Object)path, operation);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignore) {
                path.addExtension("x-" + operationMethod.toLowerCase(), (Object)operation);
            }
        }
    }

    private List<io.swagger.v3.oas.models.parameters.Parameter> parseActionParameters(ActionHolder actionHolder) {
        LinkedHashMap<String, ParamHolder> actionParamMap = new LinkedHashMap<String, ParamHolder>();
        for (ParamWrap p1 : actionHolder.action().method().getParamWraps()) {
            actionParamMap.put(p1.getName(), new ParamHolder(p1));
        }
        ArrayList<Parameter> apiParams = new ArrayList<Parameter>();
        if (actionHolder.isAnnotationPresent(Parameter.class)) {
            apiParams.add(actionHolder.getAnnotation(Parameter.class));
        }
        if (actionHolder.isAnnotationPresent(Parameters.class)) {
            Parameter[] paramArray = (Parameter[])actionHolder.getAnnotationsByType(Parameter.class);
            apiParams.addAll(Arrays.asList(paramArray));
        }
        for (Parameter a1 : apiParams) {
            ParamHolder paramHolder = (ParamHolder)actionParamMap.get(a1.name());
            if (paramHolder == null) {
                paramHolder = new ParamHolder(null);
                actionParamMap.put(a1.name(), paramHolder);
            }
            paramHolder.binding(a1);
        }
        ArrayList<io.swagger.v3.oas.models.parameters.Parameter> paramList = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
        for (ParamHolder paramHolder : actionParamMap.values()) {
            Schema schema;
            if (paramHolder.isIgnore()) continue;
            String paramSchema = this.getParameterSchema(paramHolder);
            String dataType = paramHolder.dataType();
            io.swagger.v3.oas.models.parameters.Parameter parameter = new io.swagger.v3.oas.models.parameters.Parameter();
            parameter.setName(paramHolder.getName());
            parameter.setDescription(paramHolder.getDescription());
            parameter.setRequired(Boolean.valueOf(paramHolder.isRequired()));
            parameter.setIn(paramHolder.paramType());
            if (paramHolder.allowMultiple()) {
                Schema itemSchema;
                ArraySchema arraySchema = new ArraySchema();
                if (Utils.isNotEmpty((String)paramSchema)) {
                    itemSchema = new Schema();
                    itemSchema.set$ref("#/components/schemas/" + paramSchema);
                    arraySchema.setItems(itemSchema);
                } else {
                    itemSchema = this.getSchemaByType(dataType);
                    arraySchema.setItems(itemSchema);
                }
                parameter.setSchema((Schema)arraySchema);
            } else if (Utils.isNotEmpty((String)paramSchema)) {
                schema = new Schema();
                schema.set$ref("#/components/schemas/" + paramSchema);
                parameter.setSchema(schema);
            } else {
                schema = this.getSchemaByType(dataType);
                if ("file".equals(dataType)) {
                    schema = new FileSchema();
                }
                parameter.setSchema(schema);
            }
            paramList.add(parameter);
        }
        return paramList;
    }

    private Schema getSchemaByType(String dataType) {
        if (dataType == null) {
            return new StringSchema();
        }
        switch (dataType.toLowerCase()) {
            case "integer": {
                return new IntegerSchema();
            }
            case "number": {
                return new NumberSchema();
            }
            case "boolean": {
                return new BooleanSchema();
            }
            case "string": {
                return new StringSchema();
            }
            case "array": {
                return new ArraySchema();
            }
            case "object": {
                return new ObjectSchema();
            }
            case "file": {
                return new FileSchema();
            }
            case "date": {
                return new DateSchema();
            }
            case "date-time": {
                return new DateTimeSchema();
            }
        }
        return new StringSchema();
    }

    private ApiResponses parseActionResponse(String controllerKey, String actionName, Method method) {
        ApiResponses responses = new ApiResponses();
        this.docket.globalResponseCodes().forEach((key, value) -> {
            String schema;
            ApiResponse response = new ApiResponse().description(value);
            if (key == 200 && (schema = this.parseResponse(controllerKey, actionName, method)) != null) {
                response.content(new Content().addMediaType("application/json", new MediaType().schema(new Schema().$ref("#/components/schemas/" + schema))));
            }
            responses.addApiResponse(String.valueOf(key), response);
        });
        if (!responses.containsKey((Object)"200")) {
            responses.addApiResponse("200", new ApiResponse().description("Success"));
        }
        return responses;
    }

    private String parseResponse(String controllerKey, String actionName, Method method) {
        Class<?> apiResClz;
        String schemaName = null;
        ArrayList<ApiResProperty> responses = new ArrayList<ApiResProperty>();
        if (method.isAnnotationPresent(ApiRes.class)) {
            responses.addAll(Arrays.asList(method.getAnnotation(ApiRes.class).value()));
        }
        if (method.isAnnotationPresent(ApiRes.class)) {
            ApiResProperty[] paramArray = (ApiResProperty[])method.getAnnotationsByType(ApiResProperty.class);
            responses.addAll(Arrays.asList(paramArray));
        }
        if ((apiResClz = method.getReturnType()) != Void.class && apiResClz != Void.TYPE && BuilderHelper.isModel(apiResClz)) {
            try {
                String schemaRef = this.parseSchema(apiResClz, method.getGenericReturnType());
                return schemaRef;
            }
            catch (Exception e) {
                String hint = method.getDeclaringClass().getName() + ":" + method.getName() + "->" + apiResClz.getSimpleName();
                throw new DocException("Response model parsing failure: " + hint, (Throwable)e);
            }
        }
        if (responses.size() == 0) {
            if (this.docket.globalResult() != null) {
                schemaName = this.parseSchema(this.docket.globalResult(), this.docket.globalResult());
            }
        } else {
            String schemaRef;
            schemaName = schemaRef = this.parseSchema(controllerKey, actionName, responses);
        }
        return schemaName;
    }

    private String parseSchema(Class<?> clazz, Type type) {
        String schemaName = BuilderHelper.getModelName(clazz, type);
        if (this.openAPI.getComponents() != null && this.openAPI.getComponents().getSchemas() != null && this.openAPI.getComponents().getSchemas().containsKey(schemaName)) {
            return schemaName;
        }
        io.swagger.v3.oas.annotations.media.Schema apiModel = clazz.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        String title = apiModel != null ? apiModel.description() : schemaName;
        Schema schema = new Schema();
        schema.setName(schemaName);
        schema.setTitle(title);
        schema.setType("object");
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if (this.openAPI.getComponents().getSchemas() == null) {
            this.openAPI.getComponents().setSchemas(new LinkedHashMap());
        }
        this.openAPI.getComponents().addSchemas(schemaName, schema);
        if (clazz.isEnum()) {
            schema.setType("string");
            ?[] enumConstants = clazz.getEnumConstants();
            if (enumConstants != null) {
                ArrayList<String> enumValues = new ArrayList<String>();
                for (Object enumConstant : enumConstants) {
                    enumValues.add(enumConstant.toString());
                }
                schema.setEnum(enumValues);
            }
            return schemaName;
        }
        Field[] fields = clazz.getDeclaredFields();
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (Field field : fields) {
            ArraySchema fieldSchema;
            if (Modifier.isStatic(field.getModifiers())) continue;
            io.swagger.v3.oas.annotations.media.Schema apiField = field.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
            Class typeClazz = field.getType();
            Type typeGenericType = field.getGenericType();
            if (typeGenericType instanceof TypeVariable && type instanceof ParameterizedType) {
                Map genericMap = GenericUtil.getGenericInfo((Type)type);
                Type typeClazz2 = (Type)genericMap.get(typeGenericType.getTypeName());
                if (typeClazz2 instanceof Class) {
                    typeClazz = (Class)typeClazz2;
                }
                if (typeClazz2 instanceof ParameterizedType) {
                    ParameterizedType typeGenericType2 = (ParameterizedType)typeClazz2;
                    typeClazz = (Class)typeGenericType2.getRawType();
                    typeGenericType = typeClazz2;
                }
            }
            if (Collection.class.isAssignableFrom(typeClazz)) {
                Map genericMap;
                Type itemClazz2;
                ParameterizedType pt;
                Type itemClazz;
                if (!(typeGenericType instanceof ParameterizedType)) continue;
                fieldSchema = new ArraySchema();
                if (apiField != null) {
                    fieldSchema.setDescription(apiField.description());
                }
                if ((itemClazz = (pt = (ParameterizedType)typeGenericType).getActualTypeArguments()[0]) instanceof ParameterizedType) {
                    itemClazz = ((ParameterizedType)itemClazz).getRawType();
                }
                if (itemClazz instanceof TypeVariable && (itemClazz2 = (Type)(genericMap = GenericUtil.getGenericInfo((Type)type)).get(itemClazz.getTypeName())) instanceof Class) {
                    itemClazz = itemClazz2;
                }
                if (itemClazz instanceof Class) {
                    if (itemClazz.equals(type)) {
                        Schema itemSchema = new Schema();
                        itemSchema.set$ref("#/components/schemas/" + schemaName);
                        fieldSchema.setItems(itemSchema);
                    } else {
                        String itemSchemaName = this.parseSchema((Class)itemClazz, itemClazz);
                        Schema itemSchema = new Schema();
                        itemSchema.set$ref("#/components/schemas/" + itemSchemaName);
                        fieldSchema.setItems(itemSchema);
                    }
                }
                properties.put(field.getName(), fieldSchema);
                continue;
            }
            if (BuilderHelper.isModel(typeClazz)) {
                if (typeClazz.equals(type)) {
                    fieldSchema = new Schema();
                    fieldSchema.set$ref("#/components/schemas/" + schemaName);
                    if (apiField != null) {
                        fieldSchema.setDescription(apiField.description());
                    }
                    properties.put(field.getName(), fieldSchema);
                    continue;
                }
                String refSchemaName = this.parseSchema(typeClazz, typeGenericType);
                Schema fieldSchema2 = new Schema();
                fieldSchema2.set$ref("#/components/schemas/" + refSchemaName);
                if (apiField != null) {
                    fieldSchema2.setDescription(apiField.description());
                }
                properties.put(field.getName(), fieldSchema2);
                continue;
            }
            fieldSchema = this.getSchemaByType(typeClazz.getSimpleName());
            fieldSchema.setName(field.getName());
            if (apiField != null) {
                fieldSchema.setDescription(apiField.description());
                fieldSchema.setType(Utils.isBlank((String)apiField.type()) ? typeClazz.getSimpleName().toLowerCase() : apiField.type());
                fieldSchema.setExample((Object)apiField.example());
            } else {
                fieldSchema.setType(typeClazz.getSimpleName().toLowerCase());
            }
            properties.put(field.getName(), fieldSchema);
        }
        schema.setProperties(properties);
        return schemaName;
    }

    private String parseSchema(String controllerKey, String actionName, List<ApiResProperty> responses) {
        String schemaName = controllerKey + "_" + actionName;
        LinkedHashMap<String, ArraySchema> propertiesList = new LinkedHashMap<String, ArraySchema>();
        Schema schema = new Schema();
        schema.setName(schemaName);
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if (this.openAPI.getComponents().getSchemas() == null) {
            this.openAPI.getComponents().setSchemas(new LinkedHashMap());
        }
        this.openAPI.getComponents().addSchemas(schemaName, schema);
        for (ApiResProperty apiResponse : responses) {
            ArraySchema propSchema;
            if (apiResponse.dataTypeClass() != Void.class) {
                ArraySchema propSchema2;
                String schemaRef = this.parseSchema(apiResponse.dataTypeClass(), apiResponse.dataTypeClass());
                if (apiResponse.allowMultiple()) {
                    propSchema2 = new ArraySchema();
                    propSchema2.setName(schemaRef);
                    propSchema2.setDescription(apiResponse.value());
                    Schema itemSchema = new Schema();
                    itemSchema.set$ref("#/components/schemas/" + schemaRef);
                    propSchema2.setItems(itemSchema);
                    propertiesList.put(apiResponse.name(), propSchema2);
                    continue;
                }
                propSchema2 = new Schema();
                propSchema2.set$ref("#/components/schemas/" + schemaRef);
                propSchema2.setDescription(apiResponse.value());
                propertiesList.put(apiResponse.name(), propSchema2);
                continue;
            }
            if (apiResponse.allowMultiple()) {
                propSchema = new ArraySchema();
                propSchema.setName(apiResponse.name());
                propSchema.setDescription(apiResponse.value());
                StringSchema itemsSchema = new StringSchema();
                itemsSchema.setType(Utils.isBlank((String)apiResponse.dataType()) ? "string" : apiResponse.dataType());
                propSchema.setItems((Schema)itemsSchema);
                propertiesList.put(apiResponse.name(), propSchema);
                continue;
            }
            propSchema = new StringSchema();
            propSchema.setName(apiResponse.name());
            propSchema.setDescription(apiResponse.value());
            propSchema.setType(Utils.isBlank((String)apiResponse.dataType()) ? "string" : apiResponse.dataType());
            propSchema.setExample((Object)apiResponse.example());
            propertiesList.put(apiResponse.name(), propSchema);
        }
        schema.setProperties(propertiesList);
        return schemaName;
    }

    private String getParameterSchema(ParamHolder paramHolder) {
        Class dataTypeClass;
        if (paramHolder.getAnno() != null) {
            dataTypeClass = null;
            if (paramHolder.getParam() != null) {
                dataTypeClass = paramHolder.getParam().getTypeEggg().getType();
            }
            if (null != dataTypeClass && dataTypeClass != Void.class) {
                return this.parseSchema(dataTypeClass, dataTypeClass);
            }
        }
        if (paramHolder.getParam() != null) {
            dataTypeClass = paramHolder.getParam().getTypeEggg().getType();
            if (dataTypeClass.isPrimitive()) {
                return null;
            }
            if (UploadedFile.class.equals((Object)dataTypeClass)) {
                return null;
            }
            if (dataTypeClass.getName().startsWith("java.lang")) {
                return null;
            }
            ParameterizedType dataGenericType = paramHolder.getParam().getGenericType();
            if (dataTypeClass != Void.class) {
                Type itemType;
                if (Collection.class.isAssignableFrom(dataTypeClass) && dataGenericType instanceof ParameterizedType && (itemType = dataGenericType.getActualTypeArguments()[0]) instanceof Class) {
                    return this.parseSchema((Class)itemType, itemType);
                }
                return this.parseSchema(dataTypeClass, dataGenericType);
            }
        }
        return null;
    }
}

