/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.tran;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.noear.solon.data.datasource.RoutingDataSourceMapping;
import org.noear.solon.data.tran.impl.DbTran;
import org.noear.solon.util.CallableTx;
import org.noear.solon.util.RunnableTx;
import org.noear.solon.util.ScopeLocal;

public final class TranManager {
    private static final Map<Class<?>, RoutingDataSourceMapping> DS_ROUTING = new HashMap();
    private static final ScopeLocal<DbTran> TL_TRAN = ScopeLocal.newInstance(TranManager.class);

    public static <T> void routing(Class<T> dsClz, RoutingDataSourceMapping<T> mapping) {
        DS_ROUTING.put(dsClz, mapping);
    }

    public static RoutingDataSourceMapping routingGet(DataSource original) {
        Class<?> originalClz = original.getClass();
        for (Map.Entry<Class<?>, RoutingDataSourceMapping> entry : DS_ROUTING.entrySet()) {
            if (!entry.getKey().isAssignableFrom(originalClz)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static DbTran current() {
        return (DbTran)TL_TRAN.get();
    }

    public static <X extends Throwable> void with(DbTran tran, RunnableTx<X> runnable) throws X {
        TL_TRAN.with((Object)tran, runnable);
    }

    public static <R, X extends Throwable> R with(DbTran tran, CallableTx<R, X> callable) throws X {
        return (R)TL_TRAN.with((Object)tran, callable);
    }

    @Deprecated
    public static void currentSet(DbTran tran) {
        TL_TRAN.set((Object)tran);
    }

    @Deprecated
    public static void currentRemove() {
        TL_TRAN.remove();
    }

    @Deprecated
    public static DbTran trySuspend() {
        DbTran tran = TranManager.current();
        if (tran != null) {
            TranManager.currentRemove();
        }
        return tran;
    }

    @Deprecated
    public static void tryResume(DbTran tran) {
        if (tran != null) {
            TranManager.currentSet(tran);
        }
    }
}

