/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.tran;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.noear.solon.Solon;
import org.noear.solon.core.util.RunnableEx;
import org.noear.solon.data.annotation.Tran;
import org.noear.solon.data.annotation.Transaction;
import org.noear.solon.data.annotation.TransactionAnno;
import org.noear.solon.data.tran.ConnectionProxy;
import org.noear.solon.data.tran.DataSourceProxy;
import org.noear.solon.data.tran.TranExecutor;
import org.noear.solon.data.tran.TranExecutorDefault;
import org.noear.solon.data.tran.TranListener;

public final class TranUtils {
    private static TranExecutor executor = TranExecutorDefault.global;

    @Deprecated
    public static void execute(Tran tran, RunnableEx runnable) throws Throwable {
        executor.execute(TransactionAnno.ofTran(tran), runnable);
    }

    public static void execute(Transaction tran, RunnableEx runnable) throws Throwable {
        executor.execute(tran, runnable);
    }

    public static boolean inTrans() {
        return executor.inTrans();
    }

    public static boolean inTransAndReadOnly() {
        return executor.inTransAndReadOnly();
    }

    public static void listen(TranListener listener) throws IllegalStateException {
        executor.listen(listener);
    }

    public static Connection getConnection(DataSource ds) throws SQLException {
        return executor.getConnection(ds);
    }

    public static Connection getConnectionProxy(DataSource ds) throws SQLException {
        return new ConnectionProxy(executor.getConnection(ds));
    }

    public static DataSource getDataSourceProxy(DataSource ds) {
        if (ds instanceof DataSourceProxy) {
            return ds;
        }
        return new DataSourceProxy(ds);
    }

    static {
        Solon.context().getBeanAsync(TranExecutor.class, bean -> {
            executor = bean;
        });
    }
}

