/*
 * Copyright 2012-2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * copy from org.springframework.boot.configurationprocessor.fieldvalues.javac.Trees
 */

package org.noear.solon.configurationprocessor.fieldvalues.javac;

import org.noear.solon.core.util.ClassUtil;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

/**
 * Reflection based access to {@code com.sun.source.util.Trees}.
 *
 * @author Phillip Webb
 */
final class Trees extends ReflectionWrapper {

	private Trees(Object instance) {
		super("com.sun.source.util.Trees", instance);
	}

	Tree getTree(Element element) throws Exception {
		Object tree = findMethod("getTree", Element.class).invoke(getInstance(), element);
		return (tree != null) ? new Tree(tree) : null;
	}

	static Trees instance(ProcessingEnvironment env) throws Exception {
		try {
			ClassLoader classLoader = env.getClass().getClassLoader();
			Class<?> type = findClass(classLoader, "com.sun.source.util.Trees");
			Method method = findMethod(type, "instance", ProcessingEnvironment.class);
			return new Trees(method.invoke(null, env));
		}
		catch (Exception ex) {
			return instance(unwrap(env));
		}
	}

	private static ProcessingEnvironment unwrap(ProcessingEnvironment wrapper) throws Exception {
		Field delegateField = wrapper.getClass().getDeclaredField("delegate");
        ClassUtil.accessibleAsTrue(delegateField);
		return (ProcessingEnvironment) delegateField.get(wrapper);
	}

}
