/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.impl;

import java.util.Properties;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.annotation.CloudConfig;
import org.noear.solon.cloud.exception.CloudConfigException;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.PropsConverter;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.util.ConvertUtil;

public class CloudConfigBeanInjector
implements BeanInjector<CloudConfig> {
    public void doInject(VarHolder vh, CloudConfig anno) {
        if (CloudClient.config() == null) {
            throw new IllegalArgumentException("Missing CloudConfigService component");
        }
        vh.required(anno.required());
        String name = Solon.cfg().getByTmpl(Utils.annoAlias((String)anno.value(), (String)anno.name()));
        String group = Solon.cfg().getByTmpl(anno.group());
        if (Utils.isEmpty((String)name)) {
            throw new CloudConfigException("@CloudConfig missing value or name");
        }
        Object tmp1 = this.build(vh.getType(), group, name);
        if (tmp1 != null) {
            vh.setValue(tmp1);
        }
        if (vh.isField() && anno.autoRefreshed()) {
            CloudClient.config().attention(group, name, cfg -> {
                Object tmp2 = this.build0(vh.getType(), cfg);
                if (tmp2 != null) {
                    vh.setValue(tmp2);
                }
            });
        }
    }

    public void doFill(Object obj, CloudConfig anno) {
        String name = Solon.cfg().getByTmpl(Utils.annoAlias((String)anno.value(), (String)anno.name()));
        String group = Solon.cfg().getByTmpl(anno.group());
        Config cfg = CloudClient.config().pull(group, name);
        Utils.injectProperties((Object)obj, (Properties)cfg.toProps());
    }

    public Object build(Class<?> type, String group, String name) {
        Config cfg = CloudClient.config().pull(group, name);
        return this.build0(type, cfg);
    }

    private Object build0(Class<?> type, Config cfg) {
        if (cfg == null || cfg.value() == null) {
            return null;
        }
        if (Properties.class.isAssignableFrom(type)) {
            return cfg.toProps();
        }
        if (type.getName().startsWith("java.lang.") || type.isPrimitive()) {
            return ConvertUtil.to(type, (String)cfg.value());
        }
        Properties val0 = cfg.toProps();
        return PropsConverter.global().convert(val0, null, type, null);
    }
}

