/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.websocket.integration;

import java.net.Inet4Address;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.prop.impl.WebSocketServerProps;
import org.noear.solon.boot.websocket.JavaWsServer;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.util.LogUtil;

public class JavaWsPlugin
implements Plugin {
    private static Signal _signal;
    private JavaWsServer _server = null;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "org.java_websocket 1.5/" + Solon.version();
    }

    public void start(final AppContext context) {
        if (!context.app().enableWebSocket()) {
            return;
        }
        context.lifecycle(99, new LifecycleBean(){

            public void postStart() throws Throwable {
                JavaWsPlugin.this.start0(context);
            }
        });
    }

    private void start0(AppContext context) throws Throwable {
        ServerProps.init();
        WebSocketServerProps props = WebSocketServerProps.getNew();
        String _host = props.getHost();
        int _port = props.getPort();
        long time_start = System.currentTimeMillis();
        this._server = Utils.isEmpty((String)_host) ? new JavaWsServer(props, _port) : new JavaWsServer(props, Inet4Address.getByName(_host), _port);
        this._server.setReuseAddr(true);
        this._server.start();
        if (Utils.isNotEmpty((String)props.getName())) {
            _signal = new SignalSim(props.getName(), props.getWrapHost(), props.getWrapPort(), "ws", SignalType.WEBSOCKET);
            context.app().signalAdd(_signal);
        }
        long time_end = System.currentTimeMillis();
        String wsServerUrl = props.buildWsServerUrl(false);
        LogUtil.global().info("Connector:main: websocket: Started ServerConnector@{HTTP/1.1,[WebSocket]}{" + wsServerUrl + "}");
        LogUtil.global().info("Server:main: websocket: Started (" + JavaWsPlugin.solon_boot_ver() + ") @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
            LogUtil.global().info("Server:main: websocket: Has Stopped (" + JavaWsPlugin.solon_boot_ver() + ")");
        }
    }
}

