/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.coder.hession;

import com.caucho.hessian.io.Hessian2Input;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Map;
import org.noear.nami.Decoder;
import org.noear.nami.NamiConfig;
import org.noear.nami.common.Result;

public class HessianDecoder
implements Decoder {
    public static final HessianDecoder instance = new HessianDecoder();

    public String enctype() {
        return "application/hessian";
    }

    public <T> T decode(Result rst, Type type) {
        Hessian2Input hi = new Hessian2Input((InputStream)new ByteArrayInputStream(rst.body()));
        Object returnVal = null;
        try {
            if (rst.body().length == 0) {
                return null;
            }
            returnVal = hi.readObject();
        }
        catch (Throwable ex) {
            returnVal = ex;
        }
        if (returnVal != null && returnVal instanceof Throwable) {
            if (returnVal instanceof RuntimeException) {
                throw (RuntimeException)returnVal;
            }
            throw new RuntimeException((Throwable)returnVal);
        }
        return (T)returnVal;
    }

    public void filter(NamiConfig cfg, String method, String url, Map<String, String> headers, Map<String, Object> args) {
        headers.put("X-Serialization", "@hession");
        headers.put("Accept", "application/hessian");
    }
}

