/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.coder.snack4;

import java.lang.reflect.Type;
import org.noear.nami.Context;
import org.noear.nami.Decoder;
import org.noear.nami.EncoderTyped;
import org.noear.nami.Result;
import org.noear.nami.exception.NamiDecodeException;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.solon.Utils;

public class Snack4Decoder
implements Decoder {
    public static final Snack4Decoder instance = new Snack4Decoder();

    public String enctype() {
        return "application/json";
    }

    public <T> T decode(Result rst, Type type) {
        if (rst.body().length == 0) {
            return null;
        }
        String str = rst.bodyAsString();
        if ("null".equals(str)) {
            return null;
        }
        try {
            if (String.class == type && Utils.isNotEmpty((String)str) && str.charAt(0) != '\'' && str.charAt(0) != '\"') {
                return (T)str;
            }
            return (T)ONode.ofJson((String)str, (Feature[])new Feature[0]).toBean(type);
        }
        catch (Throwable ex) {
            throw new NamiDecodeException("Decoding failure, type: " + type.getTypeName() + ", data: " + str, ex);
        }
    }

    public void pretreatment(Context ctx) {
        if (ctx.config.getEncoder() instanceof EncoderTyped) {
            ctx.headers.put("X-Serialization", "@type_json");
        }
        ctx.headers.put("Accept", "application/json");
    }
}

