/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.jaxb.util;

import java.io.File;
import java.net.URI;

public class FileSysUtil {
    private static String slashify(String path) {
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separatorChar;
    }

    public static String relativizeFile(File basedir, File file) {
        if (basedir.isFile()) {
            throw new IllegalArgumentException("Cannot relative w.r.t. a data file " + basedir);
        }
        if (basedir.equals(file)) {
            return ".";
        }
        StringBuffer b = new StringBuffer();
        File base = basedir;
        String filepath = file.getAbsolutePath();
        while (!filepath.startsWith(FileSysUtil.slashify(base.getAbsolutePath()))) {
            if ((base = base.getParentFile()) == null) {
                return null;
            }
            if (base.equals(file)) {
                b.append("..");
                return b.toString();
            }
            b.append("../");
        }
        URI u = base.toURI().relativize(file.toURI());
        assert (!u.isAbsolute()) : u + " from " + basedir + " and " + file + " with common root " + base;
        b.append(u.getPath());
        if (b.charAt(b.length() - 1) == '/') {
            b.setLength(b.length() - 1);
        }
        return b.toString();
    }

    public static boolean isAbsolutePath(File file) {
        return file.isAbsolute();
    }

    public static String Absolute2RelativePathStr(File base, File absPath) {
        String relPath = null;
        relPath = FileSysUtil.isAbsolutePath(absPath) ? FileSysUtil.relativizeFile(base, absPath) : absPath.getPath();
        return relPath;
    }

    public static File Relative2AbsolutePath(File base, String relPath) {
        File relPathFile = new File(relPath);
        File absPath = null;
        absPath = !FileSysUtil.isAbsolutePath(relPathFile) ? new File(base, relPath) : relPathFile;
        return absPath;
    }
}

