/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasMetadata;
import org.netbeans.modules.websvc.saas.model.wadl.Method;
import org.netbeans.modules.websvc.saas.model.wadl.Param;
import org.netbeans.modules.websvc.saas.model.wadl.Representation;
import org.netbeans.modules.websvc.saas.model.wadl.Request;
import org.netbeans.modules.websvc.saas.model.wadl.Resource;
import org.netbeans.modules.websvc.saas.model.wadl.Response;

public class RestClientSaasBean
extends SaasBean {
    public static final String SAAS_SERVICE_TEMPLATE = "Templates/SaaSServices/SaasService";
    public static final String PROTOCOL_SEPERATOR = "://";
    public static final String PROTOCOL_SEPERATOR_ALT = "  ";
    private String url;
    private WadlSaasMethod m;
    private String serviceMethodName = null;

    public RestClientSaasBean(WadlSaasMethod m) throws IOException {
        this(m, false);
    }

    public RestClientSaasBean(WadlSaasMethod m, boolean isDropTargetWeb) throws IOException {
        super((Saas)m.getSaas(), Util.deriveResourceName(m.getName()), null, Util.deriveUriTemplate(m.getName()), new Constants.MimeType[]{Constants.MimeType.XML}, new String[]{"java.lang.String"}, new Constants.HttpMethodType[]{Constants.HttpMethodType.GET});
        this.m = m;
        this.setIsDropTargetWeb(isDropTargetWeb);
        this.init();
    }

    public WadlSaasMethod getMethod() {
        return this.m;
    }

    public String getSaasServiceMethodName() {
        if (this.serviceMethodName == null) {
            this.serviceMethodName = Util.deriveMethodName(this.getMethod().getName());
            this.serviceMethodName = this.serviceMethodName.substring(0, 1).toLowerCase() + this.serviceMethodName.substring(1);
        }
        return this.serviceMethodName;
    }

    private void init() throws IOException {
        this.setResourceClassTemplate("Templates/SaaSServices/WrapperResource.java");
        this.setHttpMethod(Constants.HttpMethodType.valueOf(this.getMethod().getWadlMethod().getName()));
        this.findAuthentication((SaasMethod)this.m);
        this.initUrl();
        this.getInputParameters();
        this.initMimeTypes();
        this.setMethodTypes(new Constants.HttpMethodType[]{this.getHttpMethod()});
    }

    private void initUrl() throws IOException {
        Resource[] rArray = this.m.getResourcePath();
        if (rArray == null || rArray.length == 0) {
            throw new IllegalArgumentException("Method do not belong to any resource in the WADL.");
        }
        String url2 = this.m.getSaas().getBaseURL();
        url2 = url2.replace(PROTOCOL_SEPERATOR, PROTOCOL_SEPERATOR_ALT);
        for (Resource r : rArray) {
            String path = r.getPath();
            if (path == null || path.trim().length() <= 0) continue;
            url2 = url2 + "/" + path;
        }
        url2 = url2.replace("//", "/");
        url2 = url2.replace("/  ", PROTOCOL_SEPERATOR_ALT);
        url2 = url2.replace("  /", PROTOCOL_SEPERATOR_ALT);
        this.url = url2 = url2.replace(PROTOCOL_SEPERATOR_ALT, PROTOCOL_SEPERATOR);
    }

    @Override
    protected List<ParameterInfo> initInputParameters() {
        boolean isSessionKey;
        ArrayList<ParameterInfo> inputParams = new ArrayList<ParameterInfo>();
        try {
            Resource[] rArray = this.m.getResourcePath();
            if (rArray == null || rArray.length == 0) {
                throw new IllegalArgumentException("Method do not belong to any resource in the WADL.");
            }
            inputParams.addAll(this.findWadlParams(this.m));
        }
        catch (Exception rArray) {
            // empty catch block
        }
        String apiKeyName = null;
        String sessionKeyName = null;
        boolean checkApiKey = false;
        boolean bl = isSessionKey = this.getAuthenticationType() == Constants.SaasAuthenticationType.SESSION_KEY;
        if (isSessionKey) {
            sessionKeyName = ((SaasBean.SessionKeyAuthentication)this.getAuthentication()).getSessionKeyName();
        }
        if (this.getAuthenticationType() == Constants.SaasAuthenticationType.API_KEY) {
            apiKeyName = ((SaasBean.ApiKeyAuthentication)this.getAuthentication()).getApiKeyName();
        }
        if (isSessionKey) {
            apiKeyName = ((SaasBean.SessionKeyAuthentication)this.getAuthentication()).getApiKeyName();
        }
        if (apiKeyName != null) {
            checkApiKey = true;
        }
        for (ParameterInfo param : inputParams) {
            String paramName = param.getName();
            if (param.getStyle() != ParameterInfo.ParamStyle.QUERY) continue;
            if (checkApiKey && paramName.equals(apiKeyName)) {
                param.setIsApiKey(true);
            }
            if (!isSessionKey || !paramName.equals(sessionKeyName)) continue;
            param.setIsSessionKey(true);
        }
        return inputParams;
    }

    public ArrayList<ParameterInfo> findWadlParams(WadlSaasMethod wsm) {
        ArrayList<ParameterInfo> inputParams = new ArrayList<ParameterInfo>();
        inputParams.addAll(this.findWadlParams(wsm.getWadlMethod()));
        Resource[] rArray = wsm.getResourcePath();
        if (rArray != null && rArray.length > 0) {
            for (Resource r : rArray) {
                RestClientSaasBean.findWadlParams(inputParams, r.getParam());
            }
        }
        return inputParams;
    }

    public ArrayList<ParameterInfo> findWadlParams(Method wm) {
        ArrayList<ParameterInfo> inputParams = new ArrayList<ParameterInfo>();
        Request req = wm.getRequest();
        RestClientSaasBean.findWadlParams(inputParams, req.getParam());
        List reps = req.getRepresentation();
        for (Representation rep : reps) {
            RestClientSaasBean.findWadlParams(inputParams, rep.getParam());
        }
        return inputParams;
    }

    private void initMimeTypes() {
        LinkedList<Constants.MimeType> mimeTypes = new LinkedList<Constants.MimeType>();
        List responses = this.m.getWadlMethod().getResponse();
        for (Response response : responses) {
            RestClientSaasBean.findMediaType(response, mimeTypes);
        }
        if (mimeTypes.size() > 0) {
            this.setMimeTypes(mimeTypes.toArray(new Constants.MimeType[mimeTypes.size()]));
        }
    }

    public static List<QName> findRepresentationTypes(WadlSaasMethod wm) {
        LinkedList<QName> repTypes = new LinkedList<QName>();
        List responses = wm.getWadlMethod().getResponse();
        for (Response response : responses) {
            RestClientSaasBean.findRepresentationType(response, repTypes);
        }
        return repTypes;
    }

    public static List<Representation> findInputRepresentations(WadlSaasMethod m) {
        return m.getWadlMethod().getRequest().getRepresentation();
    }

    public String getUrl() {
        return this.url;
    }

    public static void findMediaType(Response response, List<Constants.MimeType> mimeTypes) {
        if (response == null) {
            return;
        }
        List representations = response.getRepresentation();
        for (Representation representation : representations) {
            String[] mTypes;
            String mediaType = representation.getMediaType();
            if (mediaType == null) continue;
            for (String m : mTypes = mediaType.split(",")) {
                Constants.MimeType mType = Constants.MimeType.find(m);
                if (mType == null || mimeTypes.contains((Object)mType)) continue;
                mimeTypes.add(mType);
            }
        }
    }

    public static void findMediaType(Request request, List<String> mimeTypes) {
        if (request == null) {
            return;
        }
        List reps = request.getRepresentation();
        for (Representation rep : reps) {
            String[] mTypes;
            String mediaType = rep.getMediaType();
            if (mediaType == null) continue;
            for (String m : mTypes = mediaType.split(",")) {
                if (m == null || mimeTypes.contains(m)) continue;
                mimeTypes.add(m);
            }
        }
    }

    public static void findWadlParams(List<ParameterInfo> paramInfos, List<Param> params) {
        if (params != null) {
            for (Param param : params) {
                String paramName = param.getName();
                Class paramType = RestClientSaasBean.findJavaType(param.getType().getLocalPart());
                String defaultValue = param.getDefault();
                ParameterInfo paramInfo = new ParameterInfo(paramName, paramType);
                paramInfo.setStyle(ParameterInfo.ParamStyle.fromValue(param.getStyle().value()));
                paramInfo.setIsRequired(param.isRequired());
                paramInfo.setIsRepeating(param.isRepeating());
                paramInfo.setFixed(param.getFixed());
                paramInfo.setOption(param.getOption());
                paramInfo.setDefaultValue(defaultValue);
                paramInfos.add(paramInfo);
            }
        }
    }

    public static void findRepresentationType(Response response, List<QName> repTypes) {
        if (response == null) {
            return;
        }
        List representations = response.getRepresentation();
        for (Representation representation : representations) {
            QName repType = representation.getElement();
            if (repType == null || repTypes.contains(repType)) continue;
            repTypes.add(repType);
        }
    }

    public String getSaasServiceTemplate() {
        return SAAS_SERVICE_TEMPLATE;
    }

    @Override
    protected Object getSignedUrl(SaasMetadata.Authentication auth) {
        String id;
        Object signedUrl = null;
        if (auth.getSignedUrl() != null && auth.getSignedUrl().size() > 0 && (signedUrl = this.getSignedUrlById(auth, id = this.m.getWadlMethod().getId())) == null) {
            Resource[] rArray = this.m.getResourcePath();
            if (rArray == null || rArray.length == 0) {
                return null;
            }
            id = rArray[rArray.length - 1].getId();
            signedUrl = this.getSignedUrlById(auth, id);
        }
        return signedUrl;
    }

    private Object getSignedUrlById(SaasMetadata.Authentication auth, String id) {
        if (id != null && !id.trim().equals("")) {
            for (SaasMetadata.Authentication.SignedUrl s : auth.getSignedUrl()) {
                if (!id.equals(s.getId())) continue;
                return s;
            }
        }
        return null;
    }

    @Override
    protected Object getSessionKey(SaasMetadata.Authentication auth) {
        String id;
        Object signedUrl = null;
        if (auth.getSignedUrl() != null && auth.getSignedUrl().size() > 0 && (signedUrl = this.getSessionKey(auth, id = this.m.getWadlMethod().getId())) == null) {
            Resource[] rArray = this.m.getResourcePath();
            if (rArray == null || rArray.length == 0) {
                return null;
            }
            id = rArray[rArray.length - 1].getId();
            signedUrl = this.getSessionKey(auth, id);
        }
        return signedUrl;
    }

    private Object getSessionKey(SaasMetadata.Authentication auth, String id) {
        if (id != null && !id.trim().equals("")) {
            for (SaasMetadata.Authentication.SignedUrl s : auth.getSignedUrl()) {
                if (!id.equals(s.getId())) continue;
                return s;
            }
        }
        return null;
    }

    public boolean canGenerateJAXBUnmarshaller() {
        return !RestClientSaasBean.findRepresentationTypes(this.getMethod()).isEmpty();
    }
}

