/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.WildcardTree;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.websvc.rest.MiscPrivateUtilities;
import org.netbeans.modules.websvc.rest.model.api.RestApplication;
import org.netbeans.modules.websvc.rest.model.api.RestApplicationModel;
import org.netbeans.modules.websvc.rest.model.api.RestApplications;
import org.netbeans.modules.websvc.rest.model.api.RestProviderDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServices;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.spi.MiscUtilities;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;

public class ApplicationSubclassGenerator {
    static final String GET_REST_RESOURCE_CLASSES = "getRestResourceClasses";
    private RequestProcessor.Task refreshTask = null;
    private static RequestProcessor RP = new RequestProcessor(ApplicationSubclassGenerator.class);
    private RestSupport restSupport;

    public ApplicationSubclassGenerator(RestSupport restSupport) {
        this.restSupport = restSupport;
    }

    public void refreshApplicationSubclass() {
        this.getRefreshTask().schedule(1000);
    }

    private synchronized RequestProcessor.Task getRefreshTask() {
        if (this.refreshTask == null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        ApplicationSubclassGenerator.this.doReconfigure();
                    }
                    catch (IOException e) {
                        Logger.getLogger(RestSupport.class.getName()).log(Level.INFO, e.getLocalizedMessage(), e);
                    }
                }
            };
            this.refreshTask = RP.create(runnable);
        }
        return this.refreshTask;
    }

    private void doReconfigure() throws IOException {
        RestApplicationModel restAppModel = this.restSupport.getRestApplicationsModel();
        RestServicesModel model = this.restSupport.getRestServicesModel();
        String clazz = null;
        Collection<String> classNames = Collections.emptyList();
        try {
            clazz = (String)restAppModel.runReadAction((MetadataModelAction)new MetadataModelAction<RestApplications, String>(){

                public String run(RestApplications metadata) throws IOException {
                    List<RestApplication> applications = metadata.getRestApplications();
                    if (applications != null && !applications.isEmpty()) {
                        RestApplication application = applications.get(0);
                        String clazz = application.getApplicationClass();
                        return clazz;
                    }
                    return null;
                }
            });
            if (clazz != null) {
                classNames = (Collection)model.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Collection<String>>(){

                    public Collection<String> run(RestServicesMetadata metadata) throws Exception {
                        TreeSet<String> classes = new TreeSet<String>();
                        RestServices services = metadata.getRoot();
                        for (RestServiceDescription description : services.getRestServiceDescription()) {
                            if (description.getFile() == null) continue;
                            classes.add(description.getClassName());
                        }
                        for (RestProviderDescription restProviderDescription : services.getProviders()) {
                            if (restProviderDescription.getFile() == null) continue;
                            classes.add(restProviderDescription.getClassName());
                        }
                        return classes;
                    }
                });
            }
        }
        catch (MetadataModelException ex) {
            Logger.getLogger(RestSupport.class.getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
        }
        if (clazz != null) {
            this.reconfigApplicationClass(clazz, classNames);
        }
    }

    protected void reconfigApplicationClass(String appClassFqn, final Collection<String> classNames) throws IOException {
        SaveCookie cookie;
        JavaSource javaSource = MiscPrivateUtilities.getJavaSourceFromClassName(this.restSupport.getProject(), appClassFqn);
        if (javaSource == null) {
            return;
        }
        ModificationResult res = javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            /*
             * WARNING - void declaration
             */
            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                CompilationUnitTree tree = workingCopy.getCompilationUnit();
                for (Tree tree2 : tree.getTypeDecls()) {
                    void var11_11;
                    if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree2.getKind())) continue;
                    MethodTree getClasses = null;
                    MethodTree restResources = null;
                    MethodTree restResources2 = null;
                    ClassTree classTree = (ClassTree)tree2;
                    List<? extends Tree> members = classTree.getMembers();
                    for (Tree tree3 : members) {
                        if (tree3.getKind() != Tree.Kind.METHOD) continue;
                        MethodTree method = (MethodTree)tree3;
                        String name = method.getName().toString();
                        if (name.equals("getClasses")) {
                            getClasses = method;
                            continue;
                        }
                        if (name.equals(ApplicationSubclassGenerator.GET_REST_RESOURCE_CLASSES)) {
                            restResources = method;
                            continue;
                        }
                        if (!name.equals("addRestResourceClasses")) continue;
                        restResources2 = method;
                    }
                    TreeMaker maker = workingCopy.getTreeMaker();
                    ClassTree classTree2 = classTree;
                    if (getClasses != null && restResources != null) {
                        ClassTree classTree4 = ApplicationSubclassGenerator.this.removeResourcesMethod(restResources, maker, classTree2);
                        classTree4 = ApplicationSubclassGenerator.this.createMethodsOlderVersion(classNames, maker, classTree4, (CompilationController)workingCopy);
                    } else if (restResources2 != null) {
                        ClassTree classTree6 = ApplicationSubclassGenerator.this.removeResourcesMethod(restResources2, maker, classTree2);
                        classTree6 = ApplicationSubclassGenerator.this.createMethods(classNames, getClasses, maker, classTree6, (CompilationController)workingCopy);
                    }
                    workingCopy.rewrite((Tree)classTree, (Tree)var11_11);
                }
            }
        });
        res.commit();
        Collection files = javaSource.getFileObjects();
        if (files.isEmpty()) {
            return;
        }
        FileObject fileObject = (FileObject)files.iterator().next();
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        if (dataObject != null && (cookie = (SaveCookie)dataObject.getLookup().lookup(SaveCookie.class)) != null) {
            cookie.save();
        }
    }

    private ClassTree removeResourcesMethod(MethodTree restResources, TreeMaker maker, ClassTree modified) {
        return maker.removeClassMember(modified, (Tree)restResources);
    }

    private ClassTree createMethods(Collection<String> classNames, MethodTree getClasses, TreeMaker maker, ClassTree modified, CompilationController controller) throws IOException {
        WildcardTree wildCard = maker.Wildcard(Tree.Kind.UNBOUNDED_WILDCARD, null);
        ParameterizedTypeTree wildClass = maker.ParameterizedType((Tree)maker.QualIdent(Class.class.getCanonicalName()), Collections.singletonList(wildCard));
        ParameterizedTypeTree wildSet = maker.ParameterizedType((Tree)maker.QualIdent(Set.class.getCanonicalName()), Collections.singletonList(wildClass));
        String methodBody = MiscPrivateUtilities.collectRestResources(classNames, this.restSupport, false);
        return MiscUtilities.createAddResourceClasses(maker, modified, controller, methodBody, false);
    }

    private ClassTree createMethodsOlderVersion(Collection<String> classNames, TreeMaker maker, ClassTree modified, CompilationController controller) throws IOException {
        WildcardTree wildCard = maker.Wildcard(Tree.Kind.UNBOUNDED_WILDCARD, null);
        ParameterizedTypeTree wildClass = maker.ParameterizedType((Tree)maker.QualIdent(Class.class.getCanonicalName()), Collections.singletonList(wildCard));
        ParameterizedTypeTree wildSet = maker.ParameterizedType((Tree)maker.QualIdent(Set.class.getCanonicalName()), Collections.singletonList(wildClass));
        String methodBody = MiscPrivateUtilities.collectRestResources(classNames, this.restSupport, true);
        ModifiersTree modifiersTree = maker.Modifiers(EnumSet.of(Modifier.PRIVATE));
        MethodTree methodTree = maker.Method(modifiersTree, (CharSequence)GET_REST_RESOURCE_CLASSES, (Tree)wildSet, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), methodBody, null);
        modified = maker.addClassMember(modified, (Tree)methodTree);
        return modified;
    }

    public static String getApplicationPathFromAnnotations(RestSupport restSupport, final String applPathFromDD) {
        List<RestApplication> restApplications = restSupport.getRestApplications();
        if (applPathFromDD == null) {
            if (restApplications.isEmpty()) {
                return null;
            }
            return restSupport.getApplicationPathFromDialog(restApplications);
        }
        if (restApplications.isEmpty()) {
            return applPathFromDD;
        }
        boolean found = false;
        for (RestApplication appl : restApplications) {
            if (!applPathFromDD.equals(appl.getApplicationPath())) continue;
            found = true;
            break;
        }
        if (!found) {
            restApplications.add(new RestApplication(){

                @Override
                public String getApplicationPath() {
                    return applPathFromDD;
                }

                @Override
                public String getApplicationClass() {
                    return "web.xml";
                }
            });
        }
        return restSupport.getApplicationPathFromDialog(restApplications);
    }
}

