/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxws.spi;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.websvc.api.jaxws.project.JAXWSVersionProvider;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.project.config.ServiceAlreadyExistsExeption;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOption;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOptions;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperGenerator;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperHandler;
import org.netbeans.modules.websvc.jaxws.spi.JAXWSSupportImpl;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public abstract class ProjectJAXWSSupport
implements JAXWSSupportImpl {
    private static final String[] DEFAULT_WSIMPORT_OPTIONS = new String[]{"extension", "verbose", "fork"};
    private static final String[] DEFAULT_WSIMPORT_VALUES = new String[]{"true", "true", "false"};
    private static final String XNOCOMPILE_OPTION = "xnocompile";
    private static final String XENDORSED_OPTION = "xendorsed";
    private static final String TARGET_OPTION = "target";
    protected static final String JAVA_EE_VERSION_NONE = "java-ee-version-none";
    protected static final String JAVA_EE_VERSION_15 = "java-ee-version-15";
    protected static final String JAVA_EE_VERSION_16 = "java-ee-version-16";
    protected static final String JAVA_EE_VERSION_17 = "java-ee-version-17";
    protected static final String JAVA_EE_VERSION_18 = "java-ee-version-18";
    private Project project;
    private AntProjectHelper antProjectHelper;
    private FileObject serviceArtifactsFolder;

    public ProjectJAXWSSupport(Project project, AntProjectHelper antProjectHelper) {
        this.project = project;
        this.antProjectHelper = antProjectHelper;
    }

    @Override
    public void removeService(String serviceName) {
        Service service;
        assert (serviceName != null);
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && serviceName != null && (service = jaxWsModel.findServiceByName(serviceName)) != null) {
            jaxWsModel.removeService(serviceName);
            this.writeJaxWsModel(jaxWsModel);
            WSUtils.removeImplClass((Project)this.project, (String)service.getImplementationClass());
        }
    }

    @Override
    public void serviceFromJavaRemoved(String serviceName) {
    }

    @Override
    public boolean isFromWSDL(String serviceName) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        Service service = jaxWsModel.findServiceByName(serviceName);
        return service != null && service.getWsdlUrl() != null;
    }

    @Override
    public String getServiceImpl(String serviceName) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            Service service = jaxWsModel.findServiceByName(serviceName);
            return service == null ? null : service.getImplementationClass();
        }
        return null;
    }

    @Override
    public AntProjectHelper getAntProjectHelper() {
        return this.antProjectHelper;
    }

    @Override
    public void addService(String serviceName, String serviceImpl, boolean isJsr109) {
        if (!isJsr109) {
            try {
                this.addJaxwsArtifacts(this.project, serviceName, serviceImpl);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        } else {
            try {
                this.addServletElement(this.project, serviceName, serviceImpl);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    protected abstract void addJaxwsArtifacts(Project var1, String var2, String var3) throws Exception;

    protected void addServletElement(Project project, String wsName, String serviceImpl) throws IOException {
    }

    @Override
    public String addService(String name, String serviceImpl, String wsdlUrl, String serviceName, String portName, String packageName, boolean isJsr109, boolean useProvider) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            boolean serviceAdded;
            String finalServiceName;
            block39: {
                finalServiceName = WSUtils.findProperServiceName((String)name, (JaxWsModel)jaxWsModel);
                serviceAdded = false;
                FileObject localWsdl = null;
                try {
                    WsimportOptions wsimportOptions;
                    Boolean value;
                    FileObject xmlResorcesFo = this.getLocalWsdlFolderForService(finalServiceName, true);
                    localWsdl = WSUtils.retrieveResource((FileObject)xmlResorcesFo, (URI)new URI(wsdlUrl));
                    if (localWsdl == null) break block39;
                    WsdlWrapperHandler handler = null;
                    try {
                        handler = WsdlWrapperGenerator.parse(localWsdl.toURL().toExternalForm());
                    }
                    catch (ParserConfigurationException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                    catch (SAXException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                    if (!handler.isServiceElement()) {
                        StreamSource source = new StreamSource(localWsdl.toURL().toExternalForm());
                        try {
                            File wrapperWsdlFile = new File(FileUtil.toFile((FileObject)localWsdl.getParent()), WsdlWrapperGenerator.getWrapperName(localWsdl.toURL()));
                            if (!wrapperWsdlFile.exists()) {
                                try {
                                    wrapperWsdlFile.createNewFile();
                                }
                                catch (IOException ex) {
                                    ErrorManager.getDefault().notify(4096, (Throwable)ex);
                                }
                            }
                            if (wrapperWsdlFile.exists()) {
                                WsdlWrapperGenerator.generateWrapperWSDLContent(wrapperWsdlFile, source, handler.getTargetNsPrefix(), localWsdl.getNameExt());
                                localWsdl = FileUtil.toFileObject((File)wrapperWsdlFile);
                            }
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                    }
                    if ((value = jaxWsModel.getJsr109()) == null) {
                        jaxWsModel.setJsr109(Boolean.valueOf(isJsr109));
                    } else if (Boolean.TRUE.equals(value) && !isJsr109) {
                        jaxWsModel.setJsr109(Boolean.FALSE);
                    } else if (Boolean.FALSE.equals(value) && isJsr109) {
                        jaxWsModel.setJsr109(Boolean.TRUE);
                    }
                    Service service = null;
                    try {
                        service = jaxWsModel.addService(finalServiceName, serviceImpl, wsdlUrl, serviceName, portName, packageName);
                    }
                    catch (ServiceAlreadyExistsExeption ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                    service.setUseProvider(Boolean.valueOf(useProvider));
                    String localWsdlUrl = FileUtil.getRelativePath((FileObject)xmlResorcesFo, (FileObject)localWsdl);
                    service.setLocalWsdlFile(localWsdlUrl);
                    FileObject catalog = this.getCatalogFileObject();
                    if (catalog != null) {
                        service.setCatalogFile("catalog.xml");
                    }
                    if ((wsimportOptions = service.getWsImportOptions()) != null) {
                        WsimportOption wsimportOption;
                        int i = 0;
                        for (String option : DEFAULT_WSIMPORT_OPTIONS) {
                            WsimportOption wsimportOption2 = wsimportOptions.newWsimportOption();
                            wsimportOption2.setWsimportOptionName(option);
                            wsimportOption2.setWsimportOptionValue(DEFAULT_WSIMPORT_VALUES[i++]);
                            wsimportOptions.addWsimportOption(wsimportOption2);
                        }
                        if (ProjectJAXWSSupport.isXnocompile(this.project)) {
                            wsimportOption = wsimportOptions.newWsimportOption();
                            wsimportOption.setWsimportOptionName(XNOCOMPILE_OPTION);
                            wsimportOption.setWsimportOptionValue("true");
                            wsimportOptions.addWsimportOption(wsimportOption);
                        }
                        if (ProjectJAXWSSupport.isXendorsed(this.project)) {
                            wsimportOption = wsimportOptions.newWsimportOption();
                            wsimportOption.setWsimportOptionName(XENDORSED_OPTION);
                            wsimportOption.setWsimportOptionValue("true");
                            wsimportOptions.addWsimportOption(wsimportOption);
                        }
                        if (JAVA_EE_VERSION_15.equals(this.getProjectJavaEEVersion())) {
                            wsimportOption = wsimportOptions.newWsimportOption();
                            wsimportOption.setWsimportOptionName(TARGET_OPTION);
                            wsimportOption.setWsimportOptionValue("2.1");
                            wsimportOptions.addWsimportOption(wsimportOption);
                        }
                    }
                    this.writeJaxWsModel(jaxWsModel);
                    serviceAdded = true;
                }
                catch (URISyntaxException ex) {
                    ErrorManager.getDefault().notify(4096, (Throwable)ex);
                }
                catch (UnknownHostException ex) {
                    ErrorManager.getDefault().notify(4096, (Throwable)ex);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(4096, (Throwable)ex);
                }
            }
            if (serviceAdded) {
                if (!isJsr109) {
                    try {
                        this.addJaxwsArtifacts(this.project, serviceName, serviceImpl);
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                } else {
                    try {
                        this.addServletElement(this.project, serviceName, serviceImpl);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                }
                FileObject buildImplFo = this.project.getProjectDirectory().getFileObject("build.xml");
                try {
                    Properties props = WSUtils.identifyWsimport((AntProjectHelper)this.antProjectHelper);
                    ExecutorTask wsimportTask = ActionUtils.runTarget((FileObject)buildImplFo, (String[])new String[]{"wsimport-service-" + finalServiceName}, (Properties)props);
                    wsimportTask.waitFinished();
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().log(ex.getLocalizedMessage());
                }
                catch (IllegalArgumentException ex) {
                    ErrorManager.getDefault().log(ex.getLocalizedMessage());
                }
                return finalServiceName;
            }
        }
        return null;
    }

    @Override
    public List<Service> getServices() {
        Service[] services;
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && (services = jaxWsModel.getServices()) != null) {
            ArrayList<Service> list = new ArrayList<Service>();
            for (int i = 0; i < services.length; ++i) {
                list.add(services[i]);
            }
            return list;
        }
        return new ArrayList<Service>();
    }

    private void writeJaxWsModel(final JaxWsModel jaxWsModel) {
        try {
            final FileObject jaxWsFo = this.project.getProjectDirectory().getFileObject("nbproject/jax-ws.xml");
            if (jaxWsFo != null) {
                jaxWsFo.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        FileLock lock = null;
                        OutputStream os = null;
                        try {
                            lock = jaxWsFo.lock();
                            os = jaxWsFo.getOutputStream(lock);
                            jaxWsModel.write(os);
                            os.close();
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify((Throwable)ex);
                        }
                        finally {
                            if (os != null) {
                                try {
                                    os.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (lock != null) {
                                lock.releaseLock();
                            }
                        }
                    }
                });
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    @Override
    public FileObject getLocalWsdlFolderForService(String serviceName, boolean createFolder) {
        return this.getArtifactsFolder(serviceName, createFolder, true);
    }

    @Override
    public FileObject getBindingsFolderForService(String serviceName, boolean createFolder) {
        return this.getArtifactsFolder(serviceName, createFolder, false);
    }

    private FileObject getArtifactsFolder(String serviceName, boolean createFolder, boolean forWsdl) {
        String folderName = forWsdl ? "wsdl" : "bindings";
        FileObject root = this.getXmlArtifactsRoot();
        if (root == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ProjectJAXWSSupport.class, (String)"MSG_MISSING_SRC_CONF")));
            return null;
        }
        FileObject wsdlLocalFolder = root.getFileObject("xml-resources/web-services/" + serviceName + "/" + folderName);
        if (wsdlLocalFolder == null && createFolder) {
            try {
                FileObject serviceLocalFolder;
                FileObject servicesLocalFolder;
                FileObject xmlLocalFolder = root.getFileObject("xml-resources");
                if (xmlLocalFolder == null) {
                    xmlLocalFolder = root.createFolder("xml-resources");
                }
                if ((servicesLocalFolder = xmlLocalFolder.getFileObject("web-services")) == null) {
                    servicesLocalFolder = xmlLocalFolder.createFolder("web-services");
                }
                if ((serviceLocalFolder = servicesLocalFolder.getFileObject(serviceName)) == null) {
                    serviceLocalFolder = servicesLocalFolder.createFolder(serviceName);
                }
                if ((wsdlLocalFolder = serviceLocalFolder.getFileObject(folderName)) == null) {
                    wsdlLocalFolder = serviceLocalFolder.createFolder(folderName);
                }
            }
            catch (IOException ex) {
                return null;
            }
        }
        return wsdlLocalFolder;
    }

    protected FileObject getXmlArtifactsRoot() {
        return this.project.getProjectDirectory();
    }

    private FileObject getCatalogFileObject() {
        return this.project.getProjectDirectory().getFileObject("catalog.xml");
    }

    @Override
    public URL getCatalog() {
        try {
            FileObject catalog = this.getCatalogFileObject();
            return catalog == null ? null : catalog.getURL();
        }
        catch (FileStateInvalidException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getWsdlFolderForService(String name) throws IOException {
        FileObject globalWsdlFolder = this.getWsdlFolder(true);
        FileObject oldWsdlFolder = globalWsdlFolder.getFileObject(name);
        if (oldWsdlFolder != null) {
            FileLock lock = oldWsdlFolder.lock();
            try {
                oldWsdlFolder.delete(lock);
            }
            finally {
                lock.releaseLock();
            }
        }
        return globalWsdlFolder.createFolder(name);
    }

    private static boolean isXnocompile(Project project) {
        String version;
        JAXWSVersionProvider jvp = (JAXWSVersionProvider)project.getLookup().lookup(JAXWSVersionProvider.class);
        if (jvp != null && (version = jvp.getJAXWSVersion()) != null) {
            return ProjectJAXWSSupport.isVersionSatisfied(version, "2.1.3");
        }
        return true;
    }

    private static boolean isXendorsed(Project project) {
        String version;
        JAXWSVersionProvider jvp = (JAXWSVersionProvider)project.getLookup().lookup(JAXWSVersionProvider.class);
        if (jvp != null && (version = jvp.getJAXWSVersion()) != null) {
            return ProjectJAXWSSupport.isVersionSatisfied(version, "2.1.1");
        }
        return false;
    }

    private static boolean isVersionSatisfied(String version, String requiredVersion) {
        int len1 = version.length();
        int len2 = requiredVersion.length();
        for (int i = 0; i < Math.min(len1, len2); ++i) {
            if (version.charAt(i) < requiredVersion.charAt(i)) {
                return false;
            }
            if (version.charAt(i) <= requiredVersion.charAt(i)) continue;
            return true;
        }
        if (len1 > len2) {
            return true;
        }
        return len1 >= len2;
    }

    @Override
    public abstract FileObject getWsdlFolder(boolean var1) throws IOException;

    @Override
    public abstract String getWsdlLocation(String var1);

    @Override
    public abstract MetadataModel<WebservicesMetadata> getWebservicesMetadataModel();

    protected String getProjectJavaEEVersion() {
        return JAVA_EE_VERSION_NONE;
    }
}

