/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxws.api;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WsdlWrapperGenerator {
    private static final String TEMPLATE_BASE = "/org/netbeans/modules/websvc/jaxws/resources/";

    public static WsdlWrapperHandler parse(String wsdlUrl) throws ParserConfigurationException, SAXException, IOException {
        WsdlWrapperHandler handler = new WsdlWrapperHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(wsdlUrl, (DefaultHandler)handler);
        return handler;
    }

    public static WsdlWrapperHandler parse(File file) throws ParserConfigurationException, SAXException, IOException {
        WsdlWrapperHandler handler = new WsdlWrapperHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(file, (DefaultHandler)handler);
        return handler;
    }

    private static Transformer getTransformer() throws TransformerConfigurationException {
        BufferedInputStream is = new BufferedInputStream(WsdlWrapperGenerator.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxws/resources/WsdlServiceGenerator.xsl"));
        TransformerFactory transFactory = TransformerFactory.newInstance();
        transFactory.setURIResolver(new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                InputStream is = this.getClass().getResourceAsStream(WsdlWrapperGenerator.TEMPLATE_BASE + href.substring(href.lastIndexOf(47) + 1));
                if (is == null) {
                    return null;
                }
                return new StreamSource(is);
            }
        });
        Templates t = transFactory.newTemplates(new StreamSource(is));
        return t.newTransformer();
    }

    public static void generateWrapperWSDLContent(File wrapperWsdlFile, StreamSource wsdlSource, String tnsPrefix, String wsdlLocation) throws IOException {
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(wrapperWsdlFile));
            Transformer transformer = WsdlWrapperGenerator.getTransformer();
            transformer.setParameter("tns_prefix", tnsPrefix);
            transformer.setParameter("wsdl_location", wsdlLocation);
            transformer.transform(wsdlSource, new StreamResult(os));
            os.close();
        }
        catch (TransformerConfigurationException tce) {
            IOException ioe = new IOException();
            ioe.initCause(tce);
            throw ioe;
        }
        catch (TransformerException te) {
            IOException ioe = new IOException();
            ioe.initCause(te);
            throw ioe;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    public static String getWrapperName(URL wsdlURL) {
        String urlString = wsdlURL.toExternalForm();
        int start = urlString.lastIndexOf("/");
        int end = urlString.lastIndexOf(".");
        if (start >= 0) {
            if (start < end) {
                return urlString.substring(start + 1, end) + "Wrapper.wsdl";
            }
            if (start + 1 < urlString.length()) {
                return urlString.substring(start + 1) + "Wrapper.wsdl";
            }
        } else if (end > 0) {
            return urlString.substring(0, end) + "Wrapper.wsdl";
        }
        return "WsdlWrapper.wsdl";
    }
}

