/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.websvc.customization.multiview.BindingNode;
import org.netbeans.modules.websvc.customization.multiview.BindingOperationNode;
import org.netbeans.modules.websvc.customization.multiview.DefinitionsNode;
import org.netbeans.modules.websvc.customization.multiview.PortNode;
import org.netbeans.modules.websvc.customization.multiview.PortTypeNode;
import org.netbeans.modules.websvc.customization.multiview.PortTypeOperationFaultNode;
import org.netbeans.modules.websvc.customization.multiview.PortTypeOperationNode;
import org.netbeans.modules.websvc.customization.multiview.ServiceNode;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Fault;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WSCustomizationView
extends SectionView {
    private Set<WSDLModel> models;
    private Definitions primaryDefinitions;
    static final String ID_PORT_TYPE = "ID_PORT_TYPE";
    static final String ID_PORT_TYPE_OPERATION = "ID_PORT_TYPE_OPERATION";
    static final String ID_PORT_TYPE_OPERATION_FAULT = "ID_PORT_TYPE_OPERATION_FAULT";
    static final String ID_BINDING = "ID_BINDING";
    static final String ID_BINDING_OPERATION = "ID_BINDING_OPERATION";
    static final String ID_SERVICE = "ID_SERVICE";
    static final String ID_PORT = "ID_PORT";
    static final String ID_EXTERNAL_BINDING = "ID_EXTERNAL_BINDING";
    private List<PortType> portTypesList;
    private List<Operation> portTypeOperationsList;
    private List<Fault> portTypeOperationFaultsList;
    private List<Binding> bindingsList;
    private List<BindingOperation> bindingOperationsList;
    private List<Service> servicesList;
    private List<Port> portsList;

    public WSCustomizationView(InnerPanelFactory factory, Set<WSDLModel> models, Definitions primaryDefinitions, boolean isLight) {
        super(factory);
        this.models = models;
        this.primaryDefinitions = primaryDefinitions;
        this.populateData();
        Children.Array rootChildren = new Children.Array();
        AbstractNode root = new AbstractNode((Children)rootChildren);
        DefinitionsNode definitionsNode = new DefinitionsNode(this, primaryDefinitions);
        SectionPanel definitionsPanel = new SectionPanel((SectionView)this, (Node)definitionsNode, (Object)primaryDefinitions);
        definitionsPanel.setTitle(NbBundle.getMessage(WSCustomizationView.class, (String)"TITLE_GLOBAL_CUSTOMIZATION"));
        this.addSection((NodeSectionPanel)definitionsPanel, false);
        Children.Array portTypeChildren = new Children.Array();
        Node[] portTypeNodes = new Node[this.portTypesList.size()];
        int i = 0;
        for (PortType portType : this.portTypesList) {
            portTypeNodes[i++] = new PortTypeNode(this, portType);
        }
        portTypeChildren.add(portTypeNodes);
        SectionContainerNode portTypeNodeContainer = new SectionContainerNode((Children)portTypeChildren);
        portTypeNodeContainer.setName(ID_PORT_TYPE);
        portTypeNodeContainer.setDisplayName(NbBundle.getMessage(WSCustomizationView.class, (String)"LBL_PORTTYPES"));
        SectionContainer portTypesCont = new SectionContainer((SectionView)this, (Node)portTypeNodeContainer, NbBundle.getMessage(WSCustomizationView.class, (String)"TITLE_PORTTYPES"));
        SectionPanel[] portTypePanels = new SectionPanel[this.portTypesList.size()];
        i = 0;
        for (PortType portType : this.portTypesList) {
            portTypePanels[i] = new SectionPanel((SectionView)this, portTypeNodes[i], (Object)portType);
            portTypesCont.addSection((NodeSectionPanel)portTypePanels[i], false);
            ++i;
        }
        this.addSection((NodeSectionPanel)portTypesCont, false);
        Children.Array opChildren = new Children.Array();
        Node[] operationNodes = new Node[this.portTypeOperationsList.size()];
        i = 0;
        for (Operation operation : this.portTypeOperationsList) {
            operationNodes[i++] = new PortTypeOperationNode(this, operation);
        }
        opChildren.add(operationNodes);
        SectionContainerNode operationNodeContainer = new SectionContainerNode((Children)opChildren);
        operationNodeContainer.setName(ID_PORT_TYPE_OPERATION);
        operationNodeContainer.setDisplayName(NbBundle.getMessage(WSCustomizationView.class, (String)"LBL_PORTTYPE_OPERATIONS"));
        SectionContainer operationCont = new SectionContainer((SectionView)this, (Node)operationNodeContainer, NbBundle.getMessage(WSCustomizationView.class, (String)"TITLE_PORTTYPE_OPERATIONS"));
        SectionPanel[] operationPanels = new SectionPanel[this.portTypeOperationsList.size()];
        i = 0;
        for (Operation op : this.portTypeOperationsList) {
            operationPanels[i] = new SectionPanel((SectionView)this, operationNodes[i], (Object)op);
            operationCont.addSection((NodeSectionPanel)operationPanels[i], false);
            ++i;
        }
        this.addSection((NodeSectionPanel)operationCont, false);
        Children.Array faultChildren = new Children.Array();
        Node[] faultNodes = new Node[this.portTypeOperationFaultsList.size()];
        i = 0;
        for (Fault fault : this.portTypeOperationFaultsList) {
            faultNodes[i++] = new PortTypeOperationFaultNode(this, fault);
        }
        faultChildren.add(faultNodes);
        SectionContainerNode faultNodeContainer = new SectionContainerNode((Children)faultChildren);
        faultNodeContainer.setName(ID_PORT_TYPE_OPERATION_FAULT);
        faultNodeContainer.setDisplayName(NbBundle.getMessage(WSCustomizationView.class, (String)"LBL_PORTTYPE_FAULTS"));
        SectionContainer faultCont = new SectionContainer((SectionView)this, (Node)faultNodeContainer, NbBundle.getMessage(WSCustomizationView.class, (String)"TITLE_PORTTYPE_FAULTS"));
        SectionPanel[] faultPanels = new SectionPanel[this.portTypeOperationFaultsList.size()];
        i = 0;
        for (Fault fault : this.portTypeOperationFaultsList) {
            faultPanels[i] = new SectionPanel((SectionView)this, faultNodes[i], (Object)fault);
            faultCont.addSection((NodeSectionPanel)faultPanels[i], false);
            ++i;
        }
        this.addSection((NodeSectionPanel)faultCont, false);
        Children.Array bindingChildren = new Children.Array();
        Node[] bindingNodes = new Node[this.bindingsList.size()];
        i = 0;
        for (Binding binding : this.bindingsList) {
            bindingNodes[i++] = new BindingNode(this, binding);
        }
        bindingChildren.add(bindingNodes);
        SectionContainerNode bindingNodeContainer = new SectionContainerNode((Children)bindingChildren);
        bindingNodeContainer.setName(ID_BINDING);
        bindingNodeContainer.setDisplayName(NbBundle.getMessage(WSCustomizationView.class, (String)"LBL_BINDINGS"));
        SectionContainer bindingCont = new SectionContainer((SectionView)this, (Node)bindingNodeContainer, NbBundle.getMessage(WSCustomizationView.class, (String)"TITLE_BINDINGS"));
        SectionPanel[] bindingPanels = new SectionPanel[this.bindingsList.size()];
        i = 0;
        for (Binding binding : this.bindingsList) {
            bindingPanels[i] = new SectionPanel((SectionView)this, bindingNodes[i], (Object)binding);
            bindingCont.addSection((NodeSectionPanel)bindingPanels[i], false);
            ++i;
        }
        this.addSection((NodeSectionPanel)bindingCont, false);
        Children.Array bindingOpChildren = new Children.Array();
        Node[] bindingOpNodes = new Node[this.bindingOperationsList.size()];
        i = 0;
        for (BindingOperation bindingOp : this.bindingOperationsList) {
            bindingOpNodes[i++] = new BindingOperationNode(this, bindingOp);
        }
        bindingOpChildren.add(bindingOpNodes);
        SectionContainerNode bindingOpNodeContainer = new SectionContainerNode((Children)bindingOpChildren);
        bindingOpNodeContainer.setName(ID_BINDING_OPERATION);
        bindingOpNodeContainer.setDisplayName(NbBundle.getMessage(WSCustomizationView.class, (String)"LBL_BINDING_OPERATIONS"));
        SectionContainer bindingOpCont = new SectionContainer((SectionView)this, (Node)bindingOpNodeContainer, NbBundle.getMessage(WSCustomizationView.class, (String)"TITLE_BINDING_OPERATIONS"));
        SectionPanel[] bindingOpPanels = new SectionPanel[this.bindingOperationsList.size()];
        i = 0;
        for (BindingOperation bindingOp : this.bindingOperationsList) {
            bindingOpPanels[i] = new SectionPanel((SectionView)this, bindingOpNodes[i], (Object)bindingOp);
            bindingOpCont.addSection((NodeSectionPanel)bindingOpPanels[i], false);
            ++i;
        }
        this.addSection((NodeSectionPanel)bindingOpCont, false);
        Children.Array serviceChildren = new Children.Array();
        Node[] serviceNodes = new Node[this.servicesList.size()];
        i = 0;
        for (Service service : this.servicesList) {
            serviceNodes[i++] = new ServiceNode(this, service);
        }
        serviceChildren.add(serviceNodes);
        SectionContainerNode serviceNodeContainer = new SectionContainerNode((Children)serviceChildren);
        serviceNodeContainer.setName(ID_SERVICE);
        serviceNodeContainer.setDisplayName(NbBundle.getMessage(WSCustomizationView.class, (String)"LBL_SERVICES"));
        SectionContainer servicesCont = new SectionContainer((SectionView)this, (Node)serviceNodeContainer, NbBundle.getMessage(WSCustomizationView.class, (String)"TITLE_SERVICES"));
        SectionPanel[] servicePanels = new SectionPanel[this.servicesList.size()];
        i = 0;
        for (Service service : this.servicesList) {
            servicePanels[i] = new SectionPanel((SectionView)this, serviceNodes[i], (Object)service);
            servicesCont.addSection((NodeSectionPanel)servicePanels[i], false);
            ++i;
        }
        this.addSection((NodeSectionPanel)servicesCont, false);
        Children.Array portChildren = new Children.Array();
        Node[] portNodes = new Node[this.portsList.size()];
        i = 0;
        for (Port port : this.portsList) {
            portNodes[i++] = new PortNode(this, port);
        }
        portChildren.add(portNodes);
        SectionContainerNode portNodeContainer = new SectionContainerNode((Children)portChildren);
        portNodeContainer.setName(ID_PORT);
        portNodeContainer.setDisplayName(NbBundle.getMessage(WSCustomizationView.class, (String)"LBL_PORTS"));
        SectionContainer portCont = new SectionContainer((SectionView)this, (Node)portNodeContainer, NbBundle.getMessage(WSCustomizationView.class, (String)"TITLE_PORTS"));
        SectionPanel[] portPanels = new SectionPanel[this.portsList.size()];
        i = 0;
        for (Port port : this.portsList) {
            portPanels[i] = new SectionPanel((SectionView)this, portNodes[i], (Object)port);
            portCont.addSection((NodeSectionPanel)portPanels[i], false);
            ++i;
        }
        this.addSection((NodeSectionPanel)portCont, false);
        if (!isLight) {
            ExternalBindingNode externalBindingNode = new ExternalBindingNode(Children.LEAF);
            externalBindingNode.setDisplayName(NbBundle.getMessage(WSCustomizationView.class, (String)"LBL_EXTERNAL_BINDING_FILES"));
            SectionPanel externalBindingPanel = new SectionPanel((SectionView)this, (Node)externalBindingNode, (Object)new BindingKey());
            externalBindingPanel.setTitle(NbBundle.getMessage(WSCustomizationView.class, (String)"TITLE_EXTERNAL_BINDING_FILES"));
            this.addSection((NodeSectionPanel)externalBindingPanel, false);
            rootChildren.add(new Node[]{definitionsNode, portTypeNodeContainer, operationNodeContainer, faultNodeContainer, bindingNodeContainer, bindingOpNodeContainer, serviceNodeContainer, portNodeContainer, externalBindingNode});
        } else {
            rootChildren.add(new Node[]{definitionsNode, portTypeNodeContainer, operationNodeContainer, faultNodeContainer, bindingNodeContainer, bindingOpNodeContainer, serviceNodeContainer, portNodeContainer});
        }
        this.setRoot((Node)root);
    }

    private void populateData() {
        this.portTypesList = new ArrayList<PortType>();
        this.portTypeOperationsList = new ArrayList<Operation>();
        this.portTypeOperationFaultsList = new ArrayList<Fault>();
        this.bindingsList = new ArrayList<Binding>();
        this.bindingOperationsList = new ArrayList<BindingOperation>();
        this.servicesList = new ArrayList<Service>();
        this.portsList = new ArrayList<Port>();
        for (WSDLModel wsdlModel : this.models) {
            Object portType2;
            Definitions def = wsdlModel.getDefinitions();
            Collection portTypes = def.getPortTypes();
            this.portTypesList.addAll(portTypes);
            for (Object portType2 : portTypes) {
                Collection operations = portType2.getOperations();
                this.portTypeOperationsList.addAll(operations);
                for (Operation operation : operations) {
                    Collection faults = operation.getFaults();
                    this.portTypeOperationFaultsList.addAll(faults);
                }
            }
            Collection bindings = def.getBindings();
            this.bindingsList.addAll(bindings);
            portType2 = bindings.iterator();
            while (portType2.hasNext()) {
                Binding binding = (Binding)portType2.next();
                Collection bindingOperations = binding.getBindingOperations();
                this.bindingOperationsList.addAll(bindingOperations);
            }
            Collection services = def.getServices();
            this.servicesList.addAll(services);
            for (Service service : services) {
                Collection ports = service.getPorts();
                this.portsList.addAll(ports);
            }
        }
    }

    public static class BindingKey {
    }

    static class ExternalBindingNode
    extends AbstractNode {
        public ExternalBindingNode(Children children) {
            super(children);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(WSCustomizationView.ID_EXTERNAL_BINDING);
        }
    }
}

