/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.dd.spi.MetadataUnit;
import org.netbeans.modules.j2ee.dd.spi.web.WebAppMetadataModelFactory;
import org.netbeans.modules.j2ee.dd.spi.webservices.WebservicesMetadataModelFactory;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.EjbChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ResourceChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleFactory;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleImplementation2;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ResourceChangeReporterFactory;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ResourceChangeReporterImplementation;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.classpath.ClassPathProviderImpl;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public final class ProjectWebModule
extends J2eeModuleProvider
implements J2eeModuleImplementation2,
ModuleChangeReporter,
EjbChangeDescriptor,
PropertyChangeListener,
Lookup.Provider {
    public static final String FOLDER_WEB_INF = "WEB-INF";
    public static final String FILE_DD = "web.xml";
    public static final String LOOKUP_ITEM = "lookup.item";
    private final ResourceChangeReporter rcr = ResourceChangeReporterFactory.createResourceChangeReporter((ResourceChangeReporterImplementation)new WebResourceChangeReporter());
    private WebProject project;
    private UpdateHelper helper;
    private ClassPathProviderImpl cpProvider;
    private String fakeServerInstId = null;
    private Lookup myLookup;
    private InstanceContent myContent;
    private long notificationTimeout = 0L;
    private MetadataModel<WebAppMetadata> webAppMetadataModel;
    private MetadataModel<WebAppMetadata> webAppAnnMetadataModel;
    private MetadataModel<WebservicesMetadata> webservicesMetadataModel;
    private PropertyChangeSupport propertyChangeSupport;
    private J2eeModule j2eeModule;

    ProjectWebModule(WebProject project, UpdateHelper helper, ClassPathProviderImpl cpProvider) {
        this.project = project;
        this.helper = helper;
        this.cpProvider = cpProvider;
        this.myContent = new InstanceContent();
        this.myLookup = new AbstractLookup((AbstractLookup.Content)this.myContent);
    }

    public Lookup getLookup() {
        return this.myLookup;
    }

    public void addCookie(Object cookie) {
        if (cookie == null) {
            return;
        }
        Object old = this.getLookup().lookup(cookie.getClass());
        this.myContent.add(cookie);
        this.getPropertyChangeSupport().firePropertyChange(LOOKUP_ITEM, old, cookie);
    }

    public void removeCookie(Object cookie) {
        if (cookie == null) {
            return;
        }
        this.myContent.remove(cookie);
        this.getPropertyChangeSupport().firePropertyChange(LOOKUP_ITEM, cookie, null);
    }

    public FileObject getDeploymentDescriptor() {
        return this.getDeploymentDescriptor(false);
    }

    public FileObject getDeploymentDescriptor(boolean silent) {
        FileObject webInfFo = this.getWebInf(silent);
        if (webInfFo == null) {
            return null;
        }
        FileObject dd = webInfFo.getFileObject(FILE_DD);
        if (dd == null && !silent && (Profile.J2EE_13.equals(this.getJ2eeProfile()) || Profile.J2EE_14.equals(this.getJ2eeProfile()))) {
            this.showErrorMessage(NbBundle.getMessage(ProjectWebModule.class, (String)"MSG_WebXmlNotFound", (Object)webInfFo.getPath()));
        }
        return dd;
    }

    public String getContextPath() {
        try {
            return this.getConfigSupport().getWebContextRoot();
        }
        catch (ConfigurationException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    public void setContextPath(String path) {
        try {
            this.getConfigSupport().setWebContextRoot(path);
        }
        catch (ConfigurationException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public String getContextPath(String serverInstId) {
        this.fakeServerInstId = serverInstId;
        String result = this.getContextPath();
        this.fakeServerInstId = null;
        return result;
    }

    public void setContextPath(String serverInstId, String path) {
        this.fakeServerInstId = serverInstId;
        this.setContextPath(path);
        this.fakeServerInstId = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showErrorMessage(String message) {
        ProjectWebModule projectWebModule = this;
        synchronized (projectWebModule) {
            if (new Date().getTime() <= this.notificationTimeout || !this.isProjectOpened()) {
                return;
            }
            this.notificationTimeout = new Date().getTime() + 20000L;
        }
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
    }

    public FileObject getDocumentBase() {
        return this.getDocumentBase(false);
    }

    public FileObject getDocumentBase(boolean silent) {
        String value = this.helper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("web.docbase.dir");
        return this.resolveDocumentBase(value, silent);
    }

    FileObject resolveDocumentBase(String value, boolean silent) {
        FileObject docBase;
        FileObject fileObject = docBase = value != null ? this.helper.getAntProjectHelper().resolveFileObject(value) : null;
        if (docBase == null && !silent) {
            String path = value != null ? this.helper.getAntProjectHelper().resolvePath(value) : null;
            String errorMessage = path != null ? NbBundle.getMessage(ProjectWebModule.class, (String)"MSG_DocBase_Corrupted", (Object)this.project.getName(), (Object)path) : NbBundle.getMessage(ProjectWebModule.class, (String)"MSG_DocBase_Corrupted_Unknown", (Object)this.project.getName());
            this.showErrorMessage(errorMessage);
        }
        return docBase;
    }

    @Deprecated
    public FileObject[] getJavaSources() {
        return this.project.getSourceRoots().getRoots();
    }

    public FileObject getWebInf() {
        return this.getWebInf(false);
    }

    public FileObject getWebInf(boolean silent) {
        String value = this.helper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("webinf.dir");
        return this.resolveWebInf(null, value, silent, false);
    }

    FileObject resolveWebInf(String docBaseValue, String webInfValue, boolean silent, boolean useDocBase) {
        FileObject webInf = null;
        if (webInfValue != null) {
            webInf = this.helper.getAntProjectHelper().resolveFileObject(webInfValue);
        }
        if (webInf == null) {
            FileObject documentBase = null;
            documentBase = useDocBase ? this.resolveDocumentBase(docBaseValue, silent) : this.getDocumentBase(silent);
            if (documentBase == null) {
                return null;
            }
            webInf = documentBase.getFileObject(FOLDER_WEB_INF);
        }
        if (webInf == null && !silent) {
            this.showErrorMessage(NbBundle.getMessage(ProjectWebModule.class, (String)"MSG_WebInfCorrupted2"));
        }
        return webInf;
    }

    public FileObject getConfDir() {
        return this.getFileObject("conf.dir");
    }

    public File getConfDirAsFile() {
        return this.getFile("conf.dir");
    }

    public FileObject getPersistenceXmlDir() {
        return this.getFileObject("persistence.xml.dir");
    }

    public File getPersistenceXmlDirAsFile() {
        return this.getFile("persistence.xml.dir");
    }

    public ClassPathProvider getClassPathProvider() {
        return (ClassPathProvider)this.project.getLookup().lookup(ClassPathProvider.class);
    }

    public FileObject getArchive() {
        return this.getFileObject("dist.war");
    }

    private FileObject getFileObject(String propname) {
        String prop = this.helper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty(propname);
        if (prop != null) {
            return this.helper.getAntProjectHelper().resolveFileObject(prop);
        }
        return null;
    }

    private File getFile(String propname) {
        String prop = this.helper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty(propname);
        if (prop != null) {
            return this.helper.getAntProjectHelper().resolveFile(prop);
        }
        return null;
    }

    public synchronized J2eeModule getJ2eeModule() {
        if (this.j2eeModule == null) {
            this.j2eeModule = J2eeModuleFactory.createJ2eeModule((J2eeModuleImplementation2)this);
        }
        return this.j2eeModule;
    }

    public ModuleChangeReporter getModuleChangeReporter() {
        return this;
    }

    public ResourceChangeReporter getResourceChangeReporter() {
        return this.rcr;
    }

    public J2eeModuleProvider.DeployOnSaveSupport getDeployOnSaveSupport() {
        return this.project.getDeployOnSaveSupport();
    }

    public boolean isOnlyCompileOnSaveEnabled() {
        return Boolean.parseBoolean(this.project.evaluator().getProperty("j2ee.compile.on.save")) && !Boolean.parseBoolean(this.project.evaluator().getProperty("j2ee.deploy.on.save"));
    }

    public File getDeploymentConfigurationFile(String name) {
        assert (name != null) : "File name of the deployement configuration file can't be null";
        String path = this.getConfigSupport().getContentRelativePath(name);
        if (path == null) {
            path = name;
        }
        if (path.startsWith("WEB-INF/")) {
            path = path.substring(8);
            FileObject webInf = this.getWebInf();
            if (webInf == null) {
                return new File(this.getConfDirAsFile(), name);
            }
            return new File(FileUtil.toFile((FileObject)webInf), path);
        }
        FileObject documentBase = this.getDocumentBase();
        if (documentBase == null) {
            return new File(this.getConfDirAsFile(), name);
        }
        return new File(FileUtil.toFile((FileObject)documentBase), path);
    }

    public FileObject getModuleFolder() {
        return this.getDocumentBase();
    }

    public String getServerID() {
        String id;
        String inst = this.getServerInstanceID();
        if (inst != null && (id = Deployment.getDefault().getServerID(inst)) != null) {
            return id;
        }
        return this.helper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.type");
    }

    public String getServerInstanceID() {
        if (this.fakeServerInstId != null) {
            return this.fakeServerInstId;
        }
        return this.helper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
    }

    public void setServerInstanceID(String severInstanceID) {
        WebProjectProperties.setServerInstance(this.project, this.helper, severInstanceID);
    }

    public Iterator<J2eeModule.RootedEntry> getArchiveContents() throws IOException {
        FileObject content = this.getContentDirectory();
        content.refresh();
        return new IT(content);
    }

    public FileObject getContentDirectory() {
        return this.getFileObject("build.web.dir");
    }

    public FileObject getBuildDirectory() {
        return this.getFileObject("build.dir");
    }

    public File getContentDirectoryAsFile() {
        return this.getFile("build.web.dir");
    }

    public <T> MetadataModel<T> getMetadataModel(Class<T> type) {
        if (type == WebAppMetadata.class) {
            MetadataModel<WebAppMetadata> model = this.getAnnotationMetadataModel();
            return model;
        }
        if (type == WebservicesMetadata.class) {
            MetadataModel<WebservicesMetadata> model = this.getWebservicesMetadataModel();
            return model;
        }
        return null;
    }

    public synchronized MetadataModel<WebAppMetadata> getMetadataModel() {
        if (this.webAppMetadataModel == null) {
            FileObject ddFO = this.getDeploymentDescriptor();
            final FileObject webInf = this.getWebInf(true);
            if (ddFO == null && webInf != null) {
                webInf.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                    public void fileDataCreated(FileEvent fe) {
                        if (ProjectWebModule.FILE_DD.equals(fe.getFile().getNameExt())) {
                            webInf.removeFileChangeListener((FileChangeListener)this);
                            ProjectWebModule.this.resetMetadataModel();
                        }
                    }
                });
            }
            File ddFile = ddFO != null ? FileUtil.toFile((FileObject)ddFO) : null;
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/source"), (File)ddFile);
            this.webAppMetadataModel = WebAppMetadataModelFactory.createMetadataModel((MetadataUnit)metadataUnit, (boolean)true);
        }
        return this.webAppMetadataModel;
    }

    private synchronized void resetMetadataModel() {
        this.webAppMetadataModel = null;
    }

    public synchronized MetadataModel<WebAppMetadata> getAnnotationMetadataModel() {
        if (this.webAppAnnMetadataModel == null) {
            FileObject ddFO = this.getDeploymentDescriptor();
            File ddFile = ddFO != null ? FileUtil.toFile((FileObject)ddFO) : null;
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/source"), (File)ddFile);
            this.webAppAnnMetadataModel = WebAppMetadataModelFactory.createMetadataModel((MetadataUnit)metadataUnit, (boolean)false);
        }
        return this.webAppAnnMetadataModel;
    }

    public synchronized MetadataModel<WebservicesMetadata> getWebservicesMetadataModel() {
        if (this.webservicesMetadataModel == null) {
            FileObject ddFO = this.getDD();
            File ddFile = ddFO != null ? FileUtil.toFile((FileObject)ddFO) : null;
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/source"), (File)ddFile);
            this.webservicesMetadataModel = WebservicesMetadataModelFactory.createMetadataModel((MetadataUnit)metadataUnit);
        }
        return this.webservicesMetadataModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uncacheDescriptors() {
        ProjectWebModule projectWebModule = this;
        synchronized (projectWebModule) {
            this.notificationTimeout = 0L;
        }
    }

    public EjbChangeDescriptor getEjbChanges(long timestamp) {
        return this;
    }

    public J2eeModule.Type getModuleType() {
        return J2eeModule.Type.WAR;
    }

    public String getModuleVersion() {
        Profile platformVersion = this.getJ2eeProfile();
        if (Profile.JAVA_EE_8_FULL.equals(platformVersion) || Profile.JAVA_EE_8_WEB.equals(platformVersion)) {
            return "4.0";
        }
        if (Profile.JAVA_EE_7_FULL.equals(platformVersion) || Profile.JAVA_EE_7_WEB.equals(platformVersion)) {
            return "3.1";
        }
        if (Profile.JAVA_EE_6_FULL.equals(platformVersion) || Profile.JAVA_EE_6_WEB.equals(platformVersion)) {
            return "3.0";
        }
        if (Profile.JAVA_EE_5.equals(platformVersion)) {
            return "2.5";
        }
        if (Profile.J2EE_14.equals(platformVersion)) {
            return "2.4";
        }
        return "3.1";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("dd_version")) {
            String oldVersion = (String)evt.getOldValue();
            String newVersion = (String)evt.getNewValue();
            this.getPropertyChangeSupport().firePropertyChange("moduleVersion", oldVersion, newVersion);
        } else if (evt.getPropertyName().equals("j2ee.server.instance")) {
            Deployment d = Deployment.getDefault();
            String oldServerID = evt.getOldValue() == null ? null : d.getServerID((String)evt.getOldValue());
            String newServerID = evt.getNewValue() == null ? null : d.getServerID((String)evt.getNewValue());
            this.fireServerChange(oldServerID, newServerID);
        } else if ("resource.dir".equals(evt.getPropertyName())) {
            String oldValue = (String)evt.getOldValue();
            String newValue = (String)evt.getNewValue();
            this.getPropertyChangeSupport().firePropertyChange("resourceDir", oldValue == null ? null : new File(oldValue), newValue == null ? null : new File(newValue));
        } else if ("web.docbase.dir".equals(evt.getPropertyName())) {
            this.getPropertyChangeSupport().firePropertyChange("documentBase", (String)evt.getOldValue(), (String)evt.getNewValue());
        } else if ("webinf.dir".equals(evt.getPropertyName())) {
            this.getPropertyChangeSupport().firePropertyChange("webInf", (String)evt.getOldValue(), (String)evt.getNewValue());
        }
    }

    public String getUrl() {
        EditableProperties ep = this.helper.getProperties("nbproject/project.properties");
        String warName = ep.getProperty("war.name");
        return warName == null ? "" : "/" + warName;
    }

    public boolean isManifestChanged(long timestamp) {
        return false;
    }

    public void setUrl(String url) {
        throw new UnsupportedOperationException("Cannot customize URL of web module");
    }

    public boolean ejbsChanged() {
        return false;
    }

    public String[] getChangedEjbs() {
        return new String[0];
    }

    public Profile getJ2eeProfile() {
        return Profile.fromPropertiesString((String)this.helper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.platform"));
    }

    public FileObject getDD() {
        FileObject webInfFo = this.getWebInf();
        if (webInfFo == null) {
            this.showErrorMessage(NbBundle.getMessage(ProjectWebModule.class, (String)"MSG_WebInfCorrupted"));
            return null;
        }
        return this.getWebInf().getFileObject("webservices", "xml");
    }

    public FileObject[] getSourceRoots() {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        LinkedList<FileObject> roots = new LinkedList<FileObject>();
        FileObject documentBase = this.getDocumentBase();
        if (documentBase != null) {
            roots.add(documentBase);
        }
        for (int i = 0; i < groups.length; ++i) {
            roots.add(groups[i].getRootFolder());
        }
        FileObject[] rootArray = new FileObject[roots.size()];
        return roots.toArray(rootArray);
    }

    private boolean isProjectOpened() {
        if (OpenProjects.getDefault() == null) {
            return true;
        }
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].equals(this.project)) continue;
            return true;
        }
        return false;
    }

    public File getResourceDirectory() {
        File f = this.getFile("resource.dir");
        if (f == null) {
            f = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "setup");
        }
        return f;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private synchronized PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    private static final class FSRootRE
    implements J2eeModule.RootedEntry {
        FileObject f;
        FileObject root;

        FSRootRE(FileObject root, FileObject f) {
            this.f = f;
            this.root = root;
        }

        public FileObject getFileObject() {
            return this.f;
        }

        public String getRelativePath() {
            return FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.f);
        }
    }

    private static class IT
    implements Iterator<J2eeModule.RootedEntry> {
        ArrayList<FileObject> ch = new ArrayList();
        FileObject root;

        private IT(FileObject f) {
            this.ch.add(f);
            this.root = f;
        }

        @Override
        public boolean hasNext() {
            return !this.ch.isEmpty();
        }

        @Override
        public J2eeModule.RootedEntry next() {
            FileObject f = this.ch.get(0);
            this.ch.remove(0);
            if (f.isFolder()) {
                f.refresh();
                FileObject[] chArr = f.getChildren();
                for (int i = 0; i < chArr.length; ++i) {
                    this.ch.add(chArr[i]);
                }
            }
            return new FSRootRE(this.root, f);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class WebResourceChangeReporter
    implements ResourceChangeReporterImplementation {
        private WebResourceChangeReporter() {
        }

        public boolean isServerResourceChanged(long lastDeploy) {
            File[] children;
            File resDir = ProjectWebModule.this.getResourceDirectory();
            if (resDir != null && resDir.exists() && resDir.isDirectory() && (children = resDir.listFiles()) != null) {
                for (File file : children) {
                    if (file.lastModified() <= lastDeploy) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

