/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.primefaces;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.web.jsfapi.api.Attribute;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.Tag;
import org.netbeans.modules.web.jsfapi.api.TagFeature;
import org.netbeans.modules.web.jsfapi.spi.TagFeatureProvider;

public class PrimeFacesTagFeatureProvider
implements TagFeatureProvider {
    private static final String PRIMEFACES_UI_NAMESPACE = "http://primefaces.org/ui";
    private static final String VALUE = "value";
    private static final String VAR = "var";

    public <T extends TagFeature> Collection<T> getFeatures(final Tag tag, Library library, Class<T> clazz) {
        IterableTag iterableTag;
        if (clazz.equals(TagFeature.IterableTagPattern.class) && (iterableTag = this.resolveIterableTag(library, tag)) != null) {
            return Collections.singleton(clazz.cast(new TagFeature.IterableTagPattern(){

                public Attribute getVariable() {
                    return tag.getAttribute(iterableTag.getVariableAtribute());
                }

                public Attribute getItems() {
                    return tag.getAttribute(iterableTag.getItemsAtribute());
                }
            }));
        }
        return Collections.emptyList();
    }

    private IterableTag resolveIterableTag(Library library, Tag tag) {
        for (IterableTag iterableTag : IterableTag.values()) {
            if (library.getNamespace() == null || iterableTag.getNamespace() == null || !library.getNamespace().equalsIgnoreCase(iterableTag.getNamespace())) continue;
            return iterableTag;
        }
        return null;
    }

    private static enum IterableTag {
        ACCORDION_PANEL("http://primefaces.org/ui", "accordionPanel", "value", "var"),
        CAROUSEL("http://primefaces.org/ui", "carousel", "value", "var"),
        COLUMNS("http://primefaces.org/ui", "columns", "value", "var"),
        DATA_GRID("http://primefaces.org/ui", "dataGrid", "value", "var"),
        DATA_LIST("http://primefaces.org/ui", "dataList", "value", "var"),
        DATA_TABLE("http://primefaces.org/ui", "dataTable", "value", "var"),
        FEED_READER("http://primefaces.org/ui", "feedReader", "value", "var"),
        GALLERIA("http://primefaces.org/ui", "galleria", "value", "var"),
        ORDER_LIST("http://primefaces.org/ui", "orderList", "value", "var"),
        PICK_LIST("http://primefaces.org/ui", "pickList", "value", "var"),
        RING("http://primefaces.org/ui", "ring", "value", "var"),
        SHEET("http://primefaces.org/ui", "sheet", "value", "var"),
        SUB_TABLE("http://primefaces.org/ui", "subTable", "value", "var"),
        TAB_VIEW("http://primefaces.org/ui", "tabView", "value", "var"),
        TREE("http://primefaces.org/ui", "tree", "value", "var"),
        TREE_TABLE("http://primefaces.org/ui", "treeTable", "value", "var");

        private final String namespace;
        private final String name;
        private final String itemsAtribute;
        private final String variableAtribute;

        private IterableTag(String namespace, String name, String itemsAtribute, String variableAtribute) {
            this.namespace = namespace;
            this.name = name;
            this.itemsAtribute = itemsAtribute;
            this.variableAtribute = variableAtribute;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getItemsAtribute() {
            return this.itemsAtribute;
        }

        public String getVariableAtribute() {
            return this.variableAtribute;
        }
    }
}

