/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.web.jsf.dialogs.ValidatingPanel;
import org.openide.DialogDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AddDialog
extends DialogDescriptor {
    private static Color errorLabelColor = UIManager.getDefaults().getColor("ToolBar.dockingForeground");
    public static final JButton ADD_OPTION = new JButton(NbBundle.getMessage(AddDialog.class, (String)"LBL_Add"));
    private JPanel panel;

    public AddDialog(ValidatingPanel panel, String title, HelpCtx helpCtx) {
        super((Object)new InnerPanel((JPanel)((Object)panel)), AddDialog.getTitle(title), true, new Object[]{ADD_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, helpCtx, null);
        JTextComponent[] textComp;
        this.panel = (JPanel)((Object)panel);
        AbstractButton[] comp = panel.getStateChangeComponents();
        if (comp != null && comp.length > 0) {
            StateChangeListener list = new StateChangeListener(this);
            for (int i = 0; i < comp.length; ++i) {
                comp[i].addItemListener(list);
            }
        }
        if ((textComp = panel.getDocumentChangeComponents()) != null && textComp.length > 0) {
            DocListener list = new DocListener(this);
            for (int i = 0; i < textComp.length; ++i) {
                textComp[i].getDocument().addDocumentListener(list);
            }
        }
        this.checkValues();
    }

    private static String getTitle(String title) {
        return NbBundle.getMessage(AddDialog.class, (String)"TTL_ADD", (Object)title);
    }

    public void disableAdd() {
        ((JButton)this.getOptions()[0]).setEnabled(false);
    }

    public void enableAdd() {
        ((JButton)this.getOptions()[0]).setEnabled(true);
    }

    public final JPanel getDialogPanel() {
        return this.panel;
    }

    protected final void checkValues() {
        String errorMessage = this.validate();
        if (errorMessage == null) {
            this.enableAdd();
        } else {
            this.disableAdd();
        }
        JLabel errorLabel = ((InnerPanel)this.getMessage()).getErrorLabel();
        errorLabel.setText(errorMessage == null ? " " : errorMessage);
    }

    protected String validate() {
        return ((ValidatingPanel)((Object)this.panel)).validatePanel();
    }

    static {
        ADD_OPTION.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/dialogs/Bundle").getString("ACSD_Add"));
    }

    private static class InnerPanel
    extends JPanel {
        JLabel errorLabel = new JLabel(" ");

        InnerPanel(JPanel panel) {
            super(new BorderLayout());
            this.errorLabel.setBorder(new EmptyBorder(12, 12, 0, 0));
            this.errorLabel.setForeground(errorLabelColor);
            this.add((Component)panel, "Center");
            this.add((Component)this.errorLabel, "South");
            this.getAccessibleContext().setAccessibleDescription(panel.getAccessibleContext().getAccessibleDescription());
            this.getAccessibleContext().setAccessibleName(panel.getAccessibleContext().getAccessibleName());
        }

        void setErrorMessage(String message) {
            this.errorLabel.setText(message);
        }

        JLabel getErrorLabel() {
            return this.errorLabel;
        }
    }

    private class StateChangeListener
    implements ItemListener {
        AddDialog dialog;

        StateChangeListener(AddDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.dialog.checkValues();
        }
    }

    private class DocListener
    implements DocumentListener {
        AddDialog dialog;

        DocListener(AddDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
            this.dialog.checkValues();
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            this.dialog.checkValues();
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            this.dialog.checkValues();
        }
    }
}

