/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.icefaces;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.JsfComponentUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFVersion;
import org.netbeans.modules.web.jsf.icefaces.Bundle;
import org.netbeans.modules.web.jsf.icefaces.Icefaces2Customizer;
import org.netbeans.modules.web.jsf.icefaces.ui.Icefaces2CustomizerPanelVisual;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentCustomizer;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class Icefaces2Implementation
implements JsfComponentImplementation {
    private static final Logger LOGGER = Logger.getLogger(Icefaces2Implementation.class.getName());
    public static final String PREFERENCES_NODE = "icefaces";
    public static final String ICEFACES_NAME = "ICEfaces";
    public static final String ICEFACES_CORE_CLASS = "org.icefaces.impl.facelets.tag.icefaces.core.ConfigHandler";
    public static final String PREF_LIBRARY_NAME = "preffered-library";
    private Icefaces2Customizer customizer;
    private static final String FACES_SAVING_METHOD = "javax.faces.STATE_SAVING_METHOD";
    private static final String FACES_SKIP_COMMENTS = "javax.faces.FACELETS_SKIP_COMMENTS";
    private static final String MAVEN_DEP_CORE = "org.icefaces:icefaces:3.1.0:jar";
    private static final String MAVEN_DEP_ACE = "org.icefaces:icefaces-ace:3.1.0:jar";

    public String getName() {
        return ICEFACES_NAME;
    }

    public String getDisplayName() {
        return Bundle.Icefaces2Implementation_icefaces_display_name();
    }

    public String getDescription() {
        return NbBundle.getMessage(Icefaces2Implementation.class, (String)"DESC_IcefacesImplementation");
    }

    public Set<FileObject> extend(WebModule webModule, JsfComponentCustomizer jsfComponentCustomizer) {
        Icefaces2Implementation.extendClasspath(webModule, jsfComponentCustomizer);
        try {
            WebApp ddRoot = DDProvider.getDefault().getDDRoot(webModule.getDeploymentDescriptor());
            InitParam savingMethodParam = (InitParam)ddRoot.createBean("InitParam");
            savingMethodParam.setParamName(FACES_SAVING_METHOD);
            savingMethodParam.setParamValue("server");
            ddRoot.addContextParam(savingMethodParam);
            InitParam skipCommentsParam = (InitParam)ddRoot.createBean("InitParam");
            skipCommentsParam.setParamName(FACES_SKIP_COMMENTS);
            skipCommentsParam.setParamValue("true");
            ddRoot.addContextParam(skipCommentsParam);
            ddRoot.write(webModule.getDeploymentDescriptor());
        }
        catch (ClassNotFoundException ex) {
            LOGGER.log(Level.WARNING, "Exception during updating web.xml DD", ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Exception during updating web.xml DD", ex);
        }
        try {
            FileObject welcomePage = Icefaces2Implementation.generateWelcomePage(webModule);
            Collections.singleton(welcomePage);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Exception during welcome page creation", ex);
        }
        return Collections.emptySet();
    }

    private static void extendClasspath(WebModule webModule, JsfComponentCustomizer jsfComponentCustomizer) {
        try {
            ArrayList<Library> libraries = new ArrayList<Library>(1);
            Library ifLibrary = null;
            if (JsfComponentUtils.isMavenBased((WebModule)webModule)) {
                ifLibrary = Icefaces2Implementation.getMavenLibrary();
            } else {
                if (jsfComponentCustomizer != null) {
                    Icefaces2CustomizerPanelVisual icefacesPanel = (Icefaces2CustomizerPanelVisual)jsfComponentCustomizer.getComponent();
                    String chosenLibrary = icefacesPanel.getIcefacesLibrary();
                    ifLibrary = LibraryManager.getDefault().getLibrary(chosenLibrary);
                }
                if (ifLibrary == null) {
                    Preferences preferences = Icefaces2Implementation.getIcefacesPreferences();
                    ifLibrary = LibraryManager.getDefault().getLibrary(preferences.get(PREF_LIBRARY_NAME, ""));
                }
                if (ifLibrary == null) {
                    ifLibrary = Icefaces2Customizer.getIcefacesLibraries().get(0);
                }
            }
            if (ifLibrary != null) {
                libraries.add(ifLibrary);
                FileObject[] javaSources = webModule.getJavaSources();
                ProjectClassPathModifier.addLibraries((Library[])libraries.toArray(new Library[1]), (FileObject)javaSources[0], (String)"classpath/compile");
            } else {
                LOGGER.log(Level.SEVERE, "No ICEfaces library was found.");
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Exception during extending an web project", ex);
        }
        catch (UnsupportedOperationException ex) {
            LOGGER.log(Level.WARNING, "Exception during extending an web project", ex);
        }
    }

    private static Library getMavenLibrary() {
        return JsfComponentUtils.createMavenDependencyLibrary((String)"ICEfaces-maven-lib", (String[])new String[]{MAVEN_DEP_CORE, MAVEN_DEP_ACE}, (String[])new String[0]);
    }

    private static FileObject generateWelcomePage(WebModule webModule) throws IOException {
        FileObject templateFO = FileUtil.getConfigFile((String)"Templates/Other/welcomeIcefaces.xhtml");
        DataObject templateDO = DataObject.find((FileObject)templateFO);
        DataObject generated = templateDO.createFromTemplate(DataFolder.findFolder((FileObject)webModule.getDocumentBase()), "welcomeIcefaces");
        JsfComponentUtils.reformat((DataObject)generated);
        Icefaces2Implementation.updateIndexPage(webModule);
        return generated.getPrimaryFile();
    }

    private static void updateIndexPage(WebModule webModule) throws DataObjectNotFoundException {
        FileObject indexFO = webModule.getDocumentBase().getFileObject("index.xhtml");
        DataObject indexDO = DataObject.find((FileObject)indexFO);
        JsfComponentUtils.enhanceFileBody((DataObject)indexDO, (String)"</h:body>", (String)"<br />\n<h:link outcome=\"welcomeIcefaces\" value=\"ICEfaces welcome page\" />");
        if (indexFO.isValid() && indexFO.canWrite()) {
            JsfComponentUtils.reformat((DataObject)indexDO);
        }
    }

    public Set<JSFVersion> getJsfVersion() {
        return EnumSet.of(JSFVersion.JSF_2_0, JSFVersion.JSF_2_1, JSFVersion.JSF_2_2);
    }

    public boolean isInWebModule(WebModule webModule) {
        ClassPath classpath = ClassPath.getClassPath((FileObject)webModule.getDocumentBase(), (String)"classpath/compile");
        return classpath.findResource(ICEFACES_CORE_CLASS.replace('.', '/') + ".class") != null;
    }

    public JsfComponentCustomizer createJsfComponentCustomizer(WebModule webModule) {
        if (this.customizer == null) {
            this.customizer = new Icefaces2Customizer();
        }
        return this.customizer;
    }

    public void remove(WebModule webModule) {
        try {
            List<Library> icefacesLibraries = JsfComponentUtils.isMavenBased((WebModule)webModule) ? Arrays.asList(Icefaces2Implementation.getMavenLibrary()) : Icefaces2Customizer.getIcefacesLibraries();
            ProjectClassPathModifier.removeLibraries((Library[])icefacesLibraries.toArray(new Library[icefacesLibraries.size()]), (FileObject)webModule.getJavaSources()[0], (String)"classpath/compile");
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Exception during removing JSF suite from an web project", ex);
        }
        catch (UnsupportedOperationException ex) {
            LOGGER.log(Level.WARNING, "Exception during removing JSF suite from an web project", ex);
        }
    }

    public static Preferences getIcefacesPreferences() {
        return NbPreferences.forModule(Icefaces2Customizer.class).node(PREFERENCES_NODE);
    }
}

