/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.api;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ByteStack {
    private static final Logger LOGGER = Logger.getLogger(ByteStack.class.getName());
    public static final byte DEFAULT_SIZE = 5;
    private byte[] data;
    private int index;

    public ByteStack() {
        this(5);
    }

    public ByteStack(int stackSize) {
        this.data = new byte[stackSize];
        this.index = -1;
    }

    public boolean isEmpty() {
        return this.index == -1;
    }

    public int peek() {
        return this.data[this.index];
    }

    public int pop() {
        int item = this.peek();
        --this.index;
        return item;
    }

    public void push(int element) {
        ++this.index;
        if (this.index == this.data.length) {
            this.ensureCapacity();
        }
        this.data[this.index] = (byte)element;
    }

    public void clear() {
        this.index = -1;
    }

    public int size() {
        return this.index + 1;
    }

    public boolean contains(int element) {
        for (int i = 0; i <= this.index; ++i) {
            if (this.data[i] != element) continue;
            return true;
        }
        return false;
    }

    public ByteStack copyOf() {
        ByteStack copy = new ByteStack(this.size());
        copy.copyFrom(this);
        return copy;
    }

    public void copyFrom(ByteStack stack) {
        while (stack.index >= this.data.length) {
            this.ensureCapacity();
        }
        this.index = stack.index;
        for (int i = 0; i <= stack.index; ++i) {
            this.data[i] = stack.data[i];
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        for (int i = 0; i <= this.index; ++i) {
            sb.append(" stack[").append(i).append("]= ").append(this.data[i]);
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ByteStack)) {
            return false;
        }
        ByteStack other = (ByteStack)obj;
        if (this.index != other.index) {
            return false;
        }
        for (int i = this.index; i >= 0; --i) {
            if (this.data[i] == other.data[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.index;
        for (int i = this.index; i >= 0; --i) {
            hash = 31 * hash + this.data[i];
        }
        return hash;
    }

    private void ensureCapacity() {
        int length = this.data.length;
        LOGGER.log(Level.FINE, "ByteStack - increasing size: {0} by {1}", new Object[]{length, (byte)5});
        this.data = Arrays.copyOf(this.data, length + 5);
    }
}

