/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.jstesting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.clientproject.api.ProjectDirectoriesProvider;
import org.netbeans.modules.web.clientproject.jstesting.Bundle;
import org.netbeans.spi.gototest.TestLocator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Pair;

public final class JsTestLocator
implements TestLocator {
    private static final Logger LOGGER = Logger.getLogger(JsTestLocator.class.getName());
    private static final String JS_MIME_TYPE = "text/javascript";
    private static final String[] SUFFIXES = new String[]{"", "spec", "Spec", "test", "Test"};

    public boolean appliesTo(FileObject fo) {
        Project project = this.findProject(fo);
        if (project == null) {
            LOGGER.log(Level.INFO, "Project was not found for file {0}", fo);
            return false;
        }
        if (this.getSourceGroupForSeleniumTests(project, fo) != null) {
            return false;
        }
        return FileUtil.getMIMEType((FileObject)fo, (String[])new String[]{JS_MIME_TYPE, null}) != null;
    }

    public boolean asynchronous() {
        return true;
    }

    public TestLocator.LocationResult findOpposite(FileObject fo, int caretOffset) {
        throw new UnsupportedOperationException("Go To Test is asynchronous");
    }

    public void findOpposite(FileObject fo, int caretOffset, TestLocator.LocationListener callback) {
        Project project = this.findProject(fo);
        if (project == null) {
            LOGGER.log(Level.INFO, "Project was not found for file {0}", fo);
            this.foundLocation(null, fo, callback);
            return;
        }
        TestLocator.FileType fileType = this.getFileType(fo);
        if (fileType == TestLocator.FileType.TEST) {
            Pair<String, FileObject> source = this.findSource(project, fo);
            if (source == null) {
                this.foundLocation(null, fo, callback);
            } else if (source.second() != null) {
                this.foundLocation(new TestLocator.LocationResult((FileObject)source.second(), -1), fo, callback);
            } else {
                boolean hasSiteroot;
                boolean hasSources = !this.getSourceGroupsForSources(project, "HTML5-Sources").isEmpty();
                boolean bl = hasSiteroot = !this.getSourceGroupsForSources(project, "HTML5-SiteRoot").isEmpty();
                String message = hasSources && hasSiteroot ? Bundle.JsTestLocator_not_found_source_both(fo.getNameExt(), this.getProperRelativePath((String)source.first())) : (hasSources ? Bundle.JsTestLocator_not_found_source_sources(fo.getNameExt(), this.getProperRelativePath((String)source.first())) : Bundle.JsTestLocator_not_found_source_siteroot(fo.getNameExt(), this.getProperRelativePath((String)source.first())));
                this.foundLocation(new TestLocator.LocationResult(message), fo, callback);
            }
        } else if (fileType == TestLocator.FileType.TESTED) {
            Pair<String, FileObject> test = this.findTest(project, fo);
            if (test == null) {
                this.foundLocation(null, fo, callback);
            } else if (test.second() != null) {
                this.foundLocation(new TestLocator.LocationResult((FileObject)test.second(), -1), fo, callback);
            } else {
                this.foundLocation(new TestLocator.LocationResult(Bundle.JsTestLocator_not_found_test(fo.getNameExt(), this.getProperRelativePath((String)test.first()))), fo, callback);
            }
        } else {
            this.foundLocation(null, fo, callback);
        }
    }

    private String getProperRelativePath(String relPath) {
        assert (relPath != null);
        String path = relPath;
        if (!path.isEmpty()) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public TestLocator.FileType getFileType(FileObject fo) {
        Project project = this.findProject(fo);
        if (project == null) {
            LOGGER.log(Level.INFO, "Project was not found for file {0}", fo);
            return TestLocator.FileType.NEITHER;
        }
        if (this.getSourceGroupForTests(project, fo) != null) {
            return TestLocator.FileType.TEST;
        }
        if (this.getSourceGroupForSources(project, fo) != null) {
            return TestLocator.FileType.TESTED;
        }
        return TestLocator.FileType.NEITHER;
    }

    private void foundLocation(TestLocator.LocationResult locationResult, FileObject fo, TestLocator.LocationListener callback) {
        callback.foundLocation(fo, locationResult != null ? locationResult : new TestLocator.LocationResult(Bundle.JsTestLocator_not_found(fo.getNameExt())));
    }

    @CheckForNull
    private Project findProject(FileObject file) {
        return FileOwnerQuery.getOwner((FileObject)file);
    }

    private List<SourceGroup> getSourceGroupsForSources(Project project) {
        return this.getSourceGroupsForSources(project, null);
    }

    private List<SourceGroup> getSourceGroupsForSources(Project project, String type) {
        Sources sources = ProjectUtils.getSources((Project)project);
        ArrayList<SourceGroup> sourceGroups = new ArrayList<SourceGroup>();
        if (type == null) {
            sourceGroups.addAll(Arrays.asList(sources.getSourceGroups("HTML5-Sources")));
            sourceGroups.addAll(Arrays.asList(sources.getSourceGroups("HTML5-SiteRoot")));
        } else {
            sourceGroups.addAll(Arrays.asList(sources.getSourceGroups(type)));
        }
        return sourceGroups;
    }

    private List<SourceGroup> getSourceGroupsForTests(Project project) {
        return Arrays.asList(ProjectUtils.getSources((Project)project).getSourceGroups("HTML5-Tests"));
    }

    @CheckForNull
    private SourceGroup getSourceGroupForSources(Project project, FileObject file) {
        assert (project != null);
        assert (file != null);
        for (SourceGroup sourceGroup : this.getSourceGroupsForSources(project)) {
            if (!sourceGroup.contains(file)) continue;
            return sourceGroup;
        }
        return null;
    }

    @CheckForNull
    private SourceGroup getSourceGroupForTests(Project project, FileObject file) {
        assert (project != null);
        assert (file != null);
        for (SourceGroup sourceGroup : this.getSourceGroupsForTests(project)) {
            if (!sourceGroup.contains(file)) continue;
            return sourceGroup;
        }
        return null;
    }

    private List<SourceGroup> getSourceGroupsForSeleniumTests(Project project) {
        return Arrays.asList(ProjectUtils.getSources((Project)project).getSourceGroups("HTML5-Tests-Selenium"));
    }

    @CheckForNull
    private SourceGroup getSourceGroupForSeleniumTests(Project project, FileObject file) {
        assert (project != null);
        assert (file != null);
        for (SourceGroup sourceGroup : this.getSourceGroupsForSeleniumTests(project)) {
            if (!sourceGroup.contains(file)) continue;
            return sourceGroup;
        }
        return null;
    }

    @CheckForNull
    private Pair<String, FileObject> findSource(Project project, FileObject fo) {
        List<SourceGroup> sourceGroups = this.getSourceGroupsForSources(project);
        if (sourceGroups.isEmpty()) {
            return null;
        }
        SourceGroup testGroup = this.getSourceGroupForTests(project, fo);
        assert (testGroup != null) : project;
        FileObject tests = testGroup.getRootFolder();
        FileObject parent = fo.getParent();
        assert (parent != null) : fo;
        String parentRelativePath = FileUtil.getRelativePath((FileObject)tests, (FileObject)parent);
        assert (parentRelativePath != null) : tests + " must be parent of " + parent;
        if (!parentRelativePath.isEmpty()) {
            parentRelativePath = parentRelativePath + "/";
        }
        for (SourceGroup sourceGroup : sourceGroups) {
            FileObject sources = sourceGroup.getRootFolder();
            for (String suffix : SUFFIXES) {
                String relPath;
                FileObject source;
                String name = fo.getName();
                if (!suffix.isEmpty() && name.endsWith(suffix)) {
                    name = name.substring(0, name.length() - suffix.length());
                }
                if ((source = sources.getFileObject(relPath = parentRelativePath + name + "." + fo.getExt())) == null || !source.isData()) continue;
                return Pair.of((Object)parentRelativePath, (Object)source);
            }
        }
        return Pair.of((Object)parentRelativePath, null);
    }

    @CheckForNull
    private Pair<String, FileObject> findTest(Project project, FileObject fo) {
        List<SourceGroup> testGroups = this.getSourceGroupsForTests(project);
        if (testGroups.isEmpty()) {
            ProjectDirectoriesProvider directoriesProvider = (ProjectDirectoriesProvider)project.getLookup().lookup(ProjectDirectoriesProvider.class);
            if (directoriesProvider == null) {
                return null;
            }
            FileObject testDirectory = directoriesProvider.getTestDirectory(true);
            if (testDirectory == null) {
                return null;
            }
            testGroups = this.getSourceGroupsForTests(project);
            if (testGroups.isEmpty()) {
                return null;
            }
        }
        SourceGroup sourceGroup = this.getSourceGroupForSources(project, fo);
        assert (sourceGroup != null) : project;
        FileObject sources = sourceGroup.getRootFolder();
        FileObject parent = fo.getParent();
        assert (parent != null) : fo;
        String parentRelativePath = FileUtil.getRelativePath((FileObject)sources, (FileObject)parent);
        assert (parentRelativePath != null) : sources + " must be parent of " + parent;
        if (!parentRelativePath.isEmpty()) {
            parentRelativePath = parentRelativePath + "/";
        }
        for (SourceGroup testGroup : testGroups) {
            FileObject tests = testGroup.getRootFolder();
            for (String suffix : SUFFIXES) {
                String relPath = parentRelativePath + fo.getName() + suffix + "." + fo.getExt();
                FileObject test = tests.getFileObject(relPath);
                if (test == null || !test.isData()) continue;
                return Pair.of((Object)parentRelativePath, (Object)test);
            }
        }
        return Pair.of((Object)parentRelativePath, null);
    }
}

