/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer.method;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.web.beans.analysis.analyzer.AbstractScopedAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.web.beans.analysis.analyzer.MethodModelAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.openide.util.NbBundle;

public class ScopedMethodAnalyzer
extends AbstractScopedAnalyzer
implements MethodModelAnalyzer.MethodAnalyzer {
    @Override
    public void analyze(ExecutableElement element, TypeMirror returnType, TypeElement parent, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        if (AnnotationUtil.hasAnnotation((Element)element, model, "jakarta.enterprise.inject.Produces", "javax.enterprise.inject.Produces")) {
            result.requireCdiEnabled(element, model);
            this.analyzeScope(element, model, cancel, result);
        }
    }

    @Override
    protected void checkScope(TypeElement scopeElement, Element element, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        if (scopeElement.getQualifiedName().contentEquals("javax.enterprise.context.Dependent") || scopeElement.getQualifiedName().contentEquals("jakarta.enterprise.context.Dependent")) {
            return;
        }
        TypeMirror methodType = element.asType();
        if (methodType instanceof ExecutableType) {
            TypeMirror returnType = ((ExecutableType)methodType).getReturnType();
            if (cancel.get()) {
                return;
            }
            if (this.hasTypeVarParameter(returnType)) {
                result.addError(element, model, NbBundle.getMessage(ScopedMethodAnalyzer.class, (String)"ERR_WrongScopeParameterizedProducerReturn", (Object)scopeElement.getQualifiedName().toString()));
            }
        }
        if (cancel.get()) {
            return;
        }
        this.checkPassivationCapable(scopeElement, element, model, result);
    }

    private void checkPassivationCapable(TypeElement scopeElement, Element element, WebBeansModel model, ModelAnalyzer.Result result) {
        if (!this.isPassivatingScope(scopeElement, model)) {
            return;
        }
        TypeMirror returnType = ((ExecutableElement)element).getReturnType();
        if (returnType == null) {
            return;
        }
        if (returnType.getKind().isPrimitive()) {
            return;
        }
        if (this.isSerializable(returnType, model)) {
            return;
        }
        Element returnTypeElement = model.getCompilationController().getTypes().asElement(returnType);
        if (returnTypeElement == null) {
            return;
        }
        if (returnTypeElement.getModifiers().contains((Object)Modifier.FINAL)) {
            result.addError(element, model, NbBundle.getMessage(ScopedMethodAnalyzer.class, (String)"ERR_NotPassivationProducerReturn", (Object)scopeElement.getQualifiedName().toString()));
        }
    }
}

