/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.turbo;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.turbo.CustomProviders;
import org.netbeans.modules.turbo.DefaultTurboProvider;
import org.netbeans.modules.turbo.Memory;
import org.netbeans.modules.turbo.Statistics;
import org.netbeans.modules.turbo.TurboListener;
import org.netbeans.modules.turbo.TurboProvider;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.ErrorManager;
import org.openide.util.Lookup;

public final class Turbo {
    private static Lookup.Result providers;
    private final CustomProviders customProviders;
    private static WeakReference defaultInstance;
    private List listeners = new ArrayList(100);
    private final Memory memory;
    private final Statistics statistics;
    private static Environment env;
    private final Set prepareRequests = Collections.synchronizedSet(new LinkedHashSet(27));
    private static PreparationTask preparationTask;

    public static synchronized Turbo getDefault() {
        Turbo turbo = null;
        if (defaultInstance != null) {
            turbo = (Turbo)defaultInstance.get();
        }
        if (turbo == null) {
            turbo = new Turbo(null, 47, -1);
            defaultInstance = new WeakReference<Turbo>(turbo);
        }
        return turbo;
    }

    public static synchronized Turbo createCustom(CustomProviders providers, int min, int max) {
        return new Turbo(providers, min, max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Turbo(CustomProviders customProviders, int min, int max) {
        this.statistics = Statistics.createInstance();
        this.memory = new Memory(this.statistics, min, max);
        this.customProviders = customProviders;
        if (customProviders != null || providers != null) return;
        Lookup.Template t = new Lookup.Template(TurboProvider.class);
        Class<Turbo> clazz = Turbo.class;
        synchronized (Turbo.class) {
            if (env == null) {
                env = new Environment();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            providers = env.getLookup().lookup(t);
            return;
        }
    }

    static synchronized void initEnvironment(Environment environment) {
        assert (env == null);
        env = environment;
        providers = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.statistics.shutdown();
    }

    public Object readEntry(Object key, String name) {
        this.statistics.attributeRequest();
        if (this.memory.existsEntry(key, name)) {
            Object value = this.memory.get(key, name);
            this.statistics.memoryHit();
            return value;
        }
        ArrayList speculative = new ArrayList(57);
        Object value = this.loadEntry(key, name, speculative);
        this.memory.put(key, name, value != null ? value : Memory.NULL);
        for (Object[] next : speculative) {
            Object sKey = next[0];
            String sName = (String)next[1];
            Object sValue = next[2];
            assert (sKey != null);
            assert (sName != null);
            this.fireEntryChange(sKey, sName, sValue);
        }
        return value;
    }

    private Iterator providers() {
        if (this.customProviders == null) {
            Collection plugins = providers.allInstances();
            ArrayList<TurboProvider> all = new ArrayList<TurboProvider>(plugins.size() + 1);
            all.addAll(plugins);
            all.add(DefaultTurboProvider.getDefault());
            return all.iterator();
        }
        return this.customProviders.providers();
    }

    private Object loadEntry(Object key, String name, List speculative) {
        Iterator it = this.providers();
        while (it.hasNext()) {
            TurboProvider provider = (TurboProvider)it.next();
            try {
                if (!provider.recognizesAttribute(name) || !provider.recognizesEntity(key)) continue;
                TurboProvider.MemoryCache cache = TurboProvider.MemoryCache.createDefault(this.memory, speculative);
                Object value = provider.readEntry(key, name, cache);
                this.statistics.providerHit();
                return value;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                ErrorManager.getDefault().annotate(t, "Error in provider " + provider + ", skipping... ");
                ErrorManager.getDefault().notify(1, t);
            }
        }
        return null;
    }

    public boolean writeEntry(Object key, String name, Object value) {
        Object oldValue;
        if (value != null && (oldValue = this.memory.get(key, name)) != null && oldValue.equals(value)) {
            return true;
        }
        int result = this.storeEntry(key, name, value);
        if (result >= 0) {
            this.memory.put(key, name, value);
            this.fireEntryChange(key, name, value);
            return true;
        }
        return false;
    }

    int storeEntry(Object key, String name, Object value) {
        Iterator it = this.providers();
        while (it.hasNext()) {
            TurboProvider provider = (TurboProvider)it.next();
            try {
                if (!provider.recognizesAttribute(name) || !provider.recognizesEntity(key)) continue;
                if (provider.writeEntry(key, name, value)) {
                    return 0;
                }
                IllegalArgumentException ex = new IllegalArgumentException("Attribute[" + name + "] value rejected by " + provider);
                ErrorManager.getDefault().notify(16, (Throwable)ex);
                return -1;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                ErrorManager.getDefault().annotate(t, "Error in provider " + provider + ", skipping... ");
                ErrorManager.getDefault().notify(1, t);
            }
        }
        return 1;
    }

    public boolean prepareEntry(Object key, String name) {
        this.statistics.attributeRequest();
        if (this.memory.existsEntry(key, name)) {
            this.statistics.memoryHit();
            return true;
        }
        this.scheduleLoad(key, name);
        return false;
    }

    public boolean isPrepared(Object key, String name) {
        return this.memory.existsEntry(key, name);
    }

    public Object getMonitoredKey(Object key) {
        return this.memory.getMonitoredKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTurboListener(TurboListener l) {
        List list = this.listeners;
        synchronized (list) {
            ArrayList<TurboListener> copy = new ArrayList<TurboListener>(this.listeners);
            copy.add(l);
            this.listeners = copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTurboListener(TurboListener l) {
        List list = this.listeners;
        synchronized (list) {
            ArrayList copy = new ArrayList(this.listeners);
            copy.remove(l);
            this.listeners = copy;
        }
    }

    protected void fireEntryChange(Object key, String name, Object value) {
        for (TurboListener next : this.listeners) {
            next.entryChanged(key, name, value);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Turbo delegating to:");
        Iterator it = this.providers();
        while (it.hasNext()) {
            TurboProvider provider = (TurboProvider)it.next();
            sb.append(" [" + provider + "]");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleLoad(Object key, String name) {
        Set set = this.prepareRequests;
        synchronized (set) {
            if (preparationTask == null) {
                preparationTask = new PreparationTask(this.prepareRequests);
                Utils.postParallel(preparationTask, 0);
                this.statistics.backgroundThread();
            }
            preparationTask.notifyNewRequest(new Request(key, name));
        }
    }

    static /* synthetic */ PreparationTask access$502(PreparationTask x0) {
        preparationTask = x0;
        return preparationTask;
    }

    private final class PreparationTask
    implements Runnable {
        private final Set requests;
        private static final int INACTIVITY_TIMEOUT = 123000;

        public PreparationTask(Set requests) {
            this.requests = requests;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                Thread.currentThread().setName("Turbo Async Fetcher");
                while (this.waitForRequests()) {
                    Object value;
                    boolean fire;
                    Class<Memory> clazz;
                    Set set = this.requests;
                    // MONITORENTER : set
                    Request request = (Request)this.requests.iterator().next();
                    this.requests.remove(request);
                    // MONITOREXIT : set
                    Object key = request.key;
                    String name = request.name;
                    if (Turbo.this.memory.existsEntry(key, name)) {
                        clazz = Memory.class;
                        // MONITORENTER : org.netbeans.modules.turbo.Memory.class
                        fire = !Turbo.this.memory.existsEntry(key, name);
                        value = Turbo.this.memory.get(key, name);
                        // MONITOREXIT : clazz
                        if (fire) {
                            Turbo.this.statistics.providerHit();
                        }
                    } else {
                        value = Turbo.this.loadEntry(key, name, null);
                        clazz = Memory.class;
                        // MONITORENTER : org.netbeans.modules.turbo.Memory.class
                        fire = !Turbo.this.memory.existsEntry(key, name);
                        Object oldValue = Turbo.this.memory.get(key, name);
                        Turbo.this.memory.put(key, name, value != null ? value : Memory.NULL);
                        fire |= oldValue != null && !oldValue.equals(value) || oldValue == null && value != null;
                        // MONITOREXIT : clazz
                    }
                    Turbo.this.fireEntryChange(key, name, value);
                }
                return;
            }
            catch (InterruptedException ex) {
                Set set = this.requests;
                // MONITORENTER : set
                this.requests.clear();
                // MONITOREXIT : set
                return;
            }
            finally {
                Set set = this.requests;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForRequests() throws InterruptedException {
            Set set = this.requests;
            synchronized (set) {
                if (this.requests.size() == 0) {
                    this.requests.wait(123000L);
                }
                return this.requests.size() > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyNewRequest(Request request) {
            Set set = this.requests;
            synchronized (set) {
                if (this.requests.add(request)) {
                    Turbo.this.statistics.queueSize(this.requests.size());
                    this.requests.notify();
                } else {
                    Turbo.this.statistics.duplicate();
                    Turbo.this.statistics.providerHit();
                }
            }
        }

        public String toString() {
            return "Turbo.PreparationTask queue=[" + this.requests + "]";
        }
    }

    private static final class Request {
        private final Object key;
        private final String name;

        public Request(Object key, String name) {
            this.name = name;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request request = (Request)o;
            if (this.name != null ? !this.name.equals(request.name) : request.name != null) {
                return false;
            }
            return !(this.key != null ? !this.key.equals(request.key) : request.key != null);
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Request[key=" + this.key + ", attr=" + this.name + "]";
        }
    }

    static class Environment {
        Environment() {
        }

        public Lookup getLookup() {
            return Lookup.getDefault();
        }
    }
}

