/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.turbo.keys;

import java.io.File;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public final class DiskFileKey {
    private final FileObject fileObject;
    private final int hashCode;
    private String absolutePath;

    public static DiskFileKey createKey(FileObject fo) {
        return new DiskFileKey(fo);
    }

    private DiskFileKey(FileObject fo) {
        FileObject nativeFileObject = (FileObject)fo.getAttribute("VCS-Native-FileObject");
        if (nativeFileObject == null) {
            nativeFileObject = fo;
        }
        this.fileObject = fo;
        this.hashCode = fo.getNameExt().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DiskFileKey) {
            DiskFileKey key = (DiskFileKey)o;
            if (this.hashCode != key.hashCode) {
                return false;
            }
            FileObject fo = this.fileObject;
            FileObject fo2 = key.fileObject;
            if (fo == fo2) {
                return true;
            }
            try {
                FileSystem fs = fo.getFileSystem();
                FileSystem fs2 = fo2.getFileSystem();
                if (fs.equals(fs2)) {
                    return fo.equals(fo2);
                }
                if (this.absolutePath == null) {
                    File f = FileUtil.toFile((FileObject)fo);
                    this.absolutePath = f.getAbsolutePath();
                }
                if (key.absolutePath == null) {
                    File f2 = FileUtil.toFile((FileObject)fo2);
                    key.absolutePath = f2.getAbsolutePath();
                }
                return this.absolutePath.equals(key.absolutePath);
            }
            catch (FileStateInvalidException e) {
                ErrorManager err = ErrorManager.getDefault();
                err.notify((Throwable)e);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        if (this.absolutePath != null) {
            return this.absolutePath;
        }
        return this.fileObject.toString();
    }
}

