/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.ui.diff;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.util.Utils;
import org.netbeans.modules.versioning.ui.diff.DiffSidebar;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class DiffSidebarManager
implements PreferenceChangeListener,
PropertyChangeListener {
    static final String SIDEBAR_ENABLED = "diff.sidebarEnabled";
    private static DiffSidebarManager instance;
    private static File tempDir;
    private static final RequestProcessor blockingRequestProcessor;
    static final Logger LOG;
    private static final boolean LOG_STACKTRACE;
    private boolean sidebarEnabled;
    private final Map<DiffSidebar, Object> sideBars = new WeakHashMap<DiffSidebar, Object>();

    public static synchronized DiffSidebarManager getInstance() {
        if (instance == null) {
            instance = new DiffSidebarManager();
            Utils.addPropertyChangeListener((PropertyChangeListener)instance);
        }
        return instance;
    }

    private DiffSidebarManager() {
        this.sidebarEnabled = this.getPreferences().getBoolean(SIDEBAR_ENABLED, true);
        this.getPreferences().addPreferenceChangeListener(this);
    }

    public void refreshSidebars(Set<VCSFileProxy> proxies) {
        HashSet<FileObject> fileObjects = null;
        if (proxies != null) {
            fileObjects = new HashSet<FileObject>(proxies.size());
            for (VCSFileProxy file : proxies) {
                fileObjects.add(file.toFileObject());
            }
            fileObjects.remove(null);
        }
        if (LOG_STACKTRACE && (fileObjects == null || !fileObjects.isEmpty())) {
            LOG.log(Level.INFO, "Refreshing: " + fileObjects, new Exception());
        }
        final HashSet<FileObject> fileObjectsToRefresh = fileObjects;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map<DiffSidebar, Object> map = DiffSidebarManager.this.sideBars;
                synchronized (map) {
                    for (DiffSidebar bar : DiffSidebarManager.this.sideBars.keySet()) {
                        if (!DiffSidebarManager.this.matches(bar, fileObjectsToRefresh)) continue;
                        bar.refresh();
                    }
                }
            }
        });
    }

    private boolean matches(DiffSidebar sidebar, Set<FileObject> fileObjects) {
        if (fileObjects == null) {
            return true;
        }
        for (FileObject fileObject : fileObjects) {
            if (!fileObject.equals(sidebar.getFileObject())) continue;
            return true;
        }
        return false;
    }

    Preferences getPreferences() {
        return NbPreferences.forModule(DiffSidebarManager.class);
    }

    RequestProcessor.Task createDiffSidebarTask(Runnable runnable) {
        return blockingRequestProcessor.create(runnable);
    }

    JComponent createSideBar(JTextComponent target) {
        return this.getSideBar(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiffSidebar getSideBar(JTextComponent target) {
        Map<DiffSidebar, Object> map = this.sideBars;
        synchronized (map) {
            DiffSidebar sideBar = null;
            for (DiffSidebar bar : this.sideBars.keySet()) {
                if (bar.getTextComponent() != target) continue;
                sideBar = bar;
                break;
            }
            if (sideBar == null) {
                Document doc = target.getDocument();
                FileObject file = this.fileForDocument(doc);
                if (file == null || !file.isValid()) {
                    LOG.log(Level.FINE, "no valid file");
                    return null;
                }
                LOG.log(Level.FINE, "requested sidebar for {0}", file.getPath());
                sideBar = new DiffSidebar(target, file);
                this.sideBars.put(sideBar, null);
                sideBar.setSidebarVisible(this.sidebarEnabled);
            }
            return sideBar;
        }
    }

    private FileObject fileForDocument(Document doc) {
        DataObject dobj = (DataObject)doc.getProperty("stream");
        LOG.log(Level.FINEST, "document {0} returns {1} for property=stream", new Object[]{doc, dobj});
        if (dobj == null) {
            return null;
        }
        LOG.log(Level.FINER, "looking up file for {0}", dobj);
        if (dobj instanceof MultiDataObject) {
            return this.fileForDataobject(doc, (MultiDataObject)dobj);
        }
        if (dobj != null) {
            return dobj.getPrimaryFile();
        }
        return null;
    }

    private FileObject fileForDataobject(Document doc, MultiDataObject dobj) {
        for (MultiDataObject.Entry entry : dobj.secondaryEntries()) {
            CookieSet.Factory factory;
            EditorCookie ec;
            StyledDocument entryDocument;
            if (!(entry instanceof CookieSet.Factory) || (entryDocument = (ec = (EditorCookie)(factory = (CookieSet.Factory)entry).createCookie(EditorCookie.class)).getDocument()) != doc) continue;
            return entry.getFile();
        }
        return dobj.getPrimaryFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSidebarEnabled(boolean enable) {
        Map<DiffSidebar, Object> map = this.sideBars;
        synchronized (map) {
            for (DiffSidebar sideBar : this.sideBars.keySet()) {
                sideBar.setSidebarVisible(enable);
            }
            this.sidebarEnabled = enable;
        }
    }

    MarkProvider createMarkProvider(JTextComponent target) {
        DiffSidebar sideBar = this.getSideBar(target);
        return sideBar != null ? sideBar.getMarkProvider() : null;
    }

    DiffSidebar t9y_getSidebar() {
        return this.sideBars.keySet().iterator().next();
    }

    synchronized File getMainTempDir() {
        block1: {
            File dir;
            if (tempDir != null) break block1;
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            while ((dir = new File(tmpDir, "vcs-" + Long.toString(System.currentTimeMillis()))).exists() || !dir.mkdirs()) {
            }
            tempDir = FileUtil.normalizeFile((File)dir);
            tempDir.deleteOnExit();
        }
        return tempDir;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().equals(SIDEBAR_ENABLED)) {
            this.setSidebarEnabled(Boolean.valueOf(evt.getNewValue()));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("Set<File> VCS.StatusChanged")) {
            this.refreshSidebars((Set)evt.getNewValue());
        }
    }

    static {
        blockingRequestProcessor = new RequestProcessor("Diffsidebar long tasks", 1, false, false);
        LOG = Logger.getLogger(DiffSidebarManager.class.getName());
        LOG_STACKTRACE = Boolean.getBoolean("versioning.diffsidebar.refresh.logstacktrace");
    }
}

