/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class CopyCommand
extends SvnCommand {
    private final CopyType type;
    private SVNUrl fromUrl;
    private SVNUrl toUrl;
    private File fromFile;
    private File toFile;
    private String msg;
    private SVNRevision rev;
    private boolean makeParents;
    public static final String MAKE_PARENTS_ARGUMENT = "--parents";

    public CopyCommand(SVNUrl fromUrl, SVNUrl toUrl, String msg, SVNRevision rev) {
        this.fromUrl = fromUrl;
        this.toUrl = toUrl;
        this.msg = msg;
        this.rev = rev;
        this.type = CopyType.url2url;
    }

    public CopyCommand(SVNUrl fromUrl, SVNUrl toUrl, String msg, SVNRevision rev, boolean makeParents) {
        this.fromUrl = fromUrl;
        this.toUrl = toUrl;
        this.msg = msg;
        this.rev = rev;
        this.makeParents = makeParents;
        this.type = CopyType.url2url;
    }

    public CopyCommand(SVNUrl fromUrl, File toFile, SVNRevision rev) {
        this.fromUrl = fromUrl;
        this.toFile = toFile;
        this.rev = rev;
        this.type = CopyType.url2file;
    }

    public CopyCommand(File fromFile, SVNUrl toUrl, String msg) {
        this.fromFile = fromFile;
        this.toUrl = toUrl;
        this.msg = msg;
        this.type = CopyType.file2url;
    }

    public CopyCommand(File fromFile, File toFile) {
        this.fromFile = fromFile;
        this.toFile = toFile;
        this.type = CopyType.file2file;
    }

    public CopyCommand(File fromFile, SVNUrl toUrl, String msg, boolean makeParents) {
        this.fromFile = fromFile;
        this.toUrl = toUrl;
        this.msg = msg;
        this.makeParents = makeParents;
        this.type = CopyType.file2url;
    }

    @Override
    protected int getCommand() {
        return 6;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("copy");
        switch (this.type) {
            case url2url: {
                arguments.add(this.fromUrl);
                arguments.addNonExistent(this.toUrl);
                if (this.rev == null) break;
                arguments.add(this.rev);
                break;
            }
            case url2file: {
                arguments.add(this.fromUrl);
                arguments.add(this.toFile.getAbsolutePath());
                if (this.rev != null) {
                    arguments.add(this.rev);
                }
                this.setCommandWorkingDirectory(this.toFile);
                break;
            }
            case file2url: {
                arguments.add(this.fromFile);
                arguments.addNonExistent(this.toUrl);
                this.setCommandWorkingDirectory(this.fromFile);
                break;
            }
            case file2file: {
                arguments.add(this.fromFile);
                arguments.add(this.toFile);
                this.setCommandWorkingDirectory(this.fromFile);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal copytype: " + (Object)((Object)this.type));
            }
        }
        arguments.addMessage(this.msg);
        if (this.makeParents) {
            arguments.add(MAKE_PARENTS_ARGUMENT);
        }
    }

    private static enum CopyType {
        url2url,
        url2file,
        file2url,
        file2file;

    }
}

