/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.openide.xml.XMLUtil;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LogCommand
extends SvnCommand {
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private byte[] output;
    private final LogType type;
    private final File file;
    private final SVNRevision revStart;
    private final SVNRevision revEnd;
    private final SVNRevision pegRevision;
    private final boolean stopOnCopy;
    private final boolean fetchChangePath;
    private final long limit;
    private final SVNUrl url;
    private final String[] paths;

    public LogCommand(File file, SVNRevision revStart, SVNRevision revEnd, SVNRevision pegRevision, boolean stopOnCopy, boolean fetchChangePath, long limit) {
        this.file = file;
        this.revStart = revStart;
        this.revEnd = revEnd;
        this.pegRevision = pegRevision;
        this.stopOnCopy = stopOnCopy;
        this.fetchChangePath = fetchChangePath;
        this.limit = limit;
        this.type = LogType.file;
        this.url = null;
        this.paths = null;
    }

    public LogCommand(SVNUrl url, String[] paths, SVNRevision revStart, SVNRevision revEnd, SVNRevision pegRevision, boolean stopOnCopy, boolean fetchChangePath, long limit) {
        this.revStart = revStart;
        this.revEnd = revEnd;
        this.pegRevision = pegRevision;
        this.stopOnCopy = stopOnCopy;
        this.fetchChangePath = fetchChangePath;
        this.limit = limit;
        this.url = url;
        this.paths = paths;
        this.type = LogType.url;
        this.file = null;
    }

    @Override
    protected boolean hasBinaryOutput() {
        return true;
    }

    @Override
    protected boolean notifyOutput() {
        return false;
    }

    @Override
    protected int getCommand() {
        return 13;
    }

    @Override
    public void output(byte[] bytes) {
        super.output(bytes);
        this.output = bytes;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("log");
        arguments.add(this.revStart, this.revEnd);
        switch (this.type) {
            case file: {
                if (this.pegRevision == null) {
                    arguments.add(this.file);
                    break;
                }
                arguments.add(this.file.getAbsolutePath() + "@" + this.pegRevision);
                break;
            }
            case url: {
                if (this.pegRevision == null) {
                    arguments.add(this.url);
                } else {
                    arguments.add(this.url, this.pegRevision);
                }
                if (this.paths == null) break;
                arguments.addPathArguments(this.paths);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal logtype: " + (Object)((Object)this.type));
            }
        }
        arguments.add("--xml");
        if (this.fetchChangePath) {
            arguments.add("-v");
        }
        if (this.stopOnCopy) {
            arguments.add("--stop-on-copy");
        }
        if (this.limit > 0L) {
            arguments.add("--limit");
            arguments.add(Long.toString(this.limit));
        }
    }

    public ISVNLogMessage[] getLogMessages() throws SVNClientException {
        if (this.output == null || this.output.length == 0) {
            return new ISVNLogMessage[0];
        }
        try {
            XMLReader saxReader = XMLUtil.createXMLReader();
            XmlEntriesHandler xmlEntriesHandler = new XmlEntriesHandler();
            saxReader.setContentHandler(xmlEntriesHandler);
            saxReader.setErrorHandler(xmlEntriesHandler);
            InputSource source = new InputSource(new ByteArrayInputStream(this.output));
            saxReader.parse(source);
            return xmlEntriesHandler.getLog();
        }
        catch (SAXException ex) {
            throw new SVNClientException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new SVNClientException((Throwable)ex);
        }
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private class LogMessage
    implements ISVNLogMessage {
        private final String msg;
        private final SVNRevision.Number rev;
        private final String author;
        private final Date date;
        private final ISVNLogMessageChangePath[] paths;

        public LogMessage(String msg, SVNRevision.Number rev, String author, Date date, ISVNLogMessageChangePath[] paths) {
            this.msg = msg;
            this.rev = rev;
            this.author = author;
            this.date = date;
            this.paths = paths;
        }

        public SVNRevision.Number getRevision() {
            return this.rev;
        }

        public String getAuthor() {
            return this.author;
        }

        public Date getDate() {
            return this.date;
        }

        public String getMessage() {
            return this.msg;
        }

        public ISVNLogMessageChangePath[] getChangedPaths() {
            return this.paths;
        }

        public long getTimeMicros() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getTimeMillis() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getNumberOfChildren() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ISVNLogMessage[] getChildMessages() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void addChild(ISVNLogMessage arg0) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean hasChildren() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class XmlEntriesHandler
    extends DefaultHandler {
        private static final String PATH_ELEMENT_NAME = "path";
        private static final String ENTRY_ELEMENT_NAME = "logentry";
        private static final String MSG_ELEMENT_NAME = "msg";
        private static final String AUTHOR_ELEMENT_NAME = "author";
        private static final String DATE_ELEMENT_NAME = "date";
        private static final String ACTION_ATTRIBUTE = "action";
        private static final String REVISION_ATTRIBUTE = "revision";
        private List<ISVNLogMessage> logs = new ArrayList<ISVNLogMessage>();
        private Map<String, Object> values;
        private String tag;

        private XmlEntriesHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes elementAttributes) throws SAXException {
            this.tag = qName.trim();
            if (ENTRY_ELEMENT_NAME.equals(qName)) {
                this.values = new HashMap<String, Object>();
                this.values.put(REVISION_ATTRIBUTE, elementAttributes.getValue(REVISION_ATTRIBUTE));
            } else if (PATH_ELEMENT_NAME.equals(qName)) {
                List<Path> paths = this.getPathList();
                Path path = new Path();
                path.action = elementAttributes.getValue(ACTION_ATTRIBUTE).charAt(0);
                path.copyPath = elementAttributes.getValue("copyfrom-path");
                path.copyRev = elementAttributes.getValue("copyfrom-rev");
                paths.add(path);
            } else if (this.values != null) {
                this.values.put(this.tag, "");
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.values == null || this.tag == null) {
                return;
            }
            String s = this.toString(length, ch, start);
            if (this.tag.equals(PATH_ELEMENT_NAME)) {
                List<Path> paths = this.getPathList();
                paths.get((int)(paths.size() - 1)).path = paths.get((int)(paths.size() - 1)).path + s;
            } else {
                Object v = this.values.get(this.tag);
                if (v == null) {
                    this.values.put(this.tag, s);
                } else {
                    this.values.put(this.tag, v + s);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            this.tag = null;
            if (ENTRY_ELEMENT_NAME.equals(name) && this.values != null) {
                SVNLogMessageChangePath[] paths;
                String author = (String)this.values.get(AUTHOR_ELEMENT_NAME);
                if (author == null) {
                    author = "";
                }
                Date date = null;
                String dateValue = (String)this.values.get(DATE_ELEMENT_NAME);
                if (dateValue == null) {
                    throw new SAXException("'date' tag expected under 'logentry'");
                }
                try {
                    date = dateFormat.parse(dateValue);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                String msg = (String)this.values.get(MSG_ELEMENT_NAME);
                if (msg == null) {
                    msg = "";
                }
                SVNRevision.Number rev = this.getRevision((String)this.values.get(REVISION_ATTRIBUTE));
                List<Path> pathsList = this.getPathList();
                if (pathsList.size() > 0) {
                    paths = new SVNLogMessageChangePath[pathsList.size()];
                    for (int i = 0; i < pathsList.size(); ++i) {
                        Path path = pathsList.get(i);
                        paths[i] = new SVNLogMessageChangePath(path.path, this.getRevision(path.copyRev), path.copyPath, path.action);
                    }
                } else {
                    paths = new SVNLogMessageChangePath[]{};
                }
                this.logs.add(new LogMessage(msg, rev, author, date, (ISVNLogMessageChangePath[])paths));
                this.values = null;
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public ISVNLogMessage[] getLog() {
            return this.logs.toArray(new ISVNLogMessage[this.logs.size()]);
        }

        private String toString(int length, char[] ch, int start) {
            char[] c = new char[length];
            System.arraycopy(ch, start, c, 0, length);
            return new String(c);
        }

        private List<Path> getPathList() {
            ArrayList paths = (ArrayList)this.values.get(PATH_ELEMENT_NAME);
            if (paths == null) {
                paths = new ArrayList();
                this.values.put(PATH_ELEMENT_NAME, paths);
            }
            return paths;
        }

        private SVNRevision.Number getRevision(String revisionValue) {
            SVNRevision.Number rev = null;
            if (revisionValue != null && !revisionValue.trim().equals("")) {
                try {
                    rev = new SVNRevision.Number(Long.parseLong(revisionValue));
                }
                catch (NumberFormatException e) {
                    new SVNRevision.Number(-1L);
                }
            }
            return rev;
        }

        private class Path {
            char action;
            String path = "";
            String copyRev;
            String copyPath;

            private Path() {
            }
        }
    }

    private static enum LogType {
        file,
        url;

    }
}

