/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring;

import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;

public class AttributeFinder {
    private final XMLSyntaxSupport syntaxSupport;
    private final int start;
    private int foundOffset = -1;

    public AttributeFinder(XMLSyntaxSupport syntaxSupport, int start) {
        this.syntaxSupport = syntaxSupport;
        this.start = start;
    }

    public boolean find(String attrName) throws BadLocationException {
        this.foundOffset = -1;
        Token item = this.syntaxSupport.getNextToken(this.start);
        if (item == null || item.id() != XMLTokenId.TAG) {
            return false;
        }
        return (Boolean)this.syntaxSupport.runWithSequence(this.start, s -> {
            String currentAttrName = null;
            while (s.moveNext()) {
                Token t = s.token();
                XMLTokenId id = (XMLTokenId)t.id();
                if (id == XMLTokenId.ARGUMENT) {
                    currentAttrName = t.text().toString();
                    if (currentAttrName == null || !currentAttrName.equals(attrName)) continue;
                    this.foundOffset = s.offset();
                    return true;
                }
                if (id != XMLTokenId.TAG) continue;
                break;
            }
            return false;
        });
    }

    public int getFoundOffset() {
        return this.foundOffset;
    }
}

