/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.Locale;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.spellchecker.ComponentPeer;
import org.netbeans.modules.spellchecker.DictionaryImpl;
import org.netbeans.modules.spellchecker.api.LocaleQuery;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class AddToDictionaryCompletionItem
implements CompletionItem {
    private String word;
    private boolean projects;

    public AddToDictionaryCompletionItem(String word, boolean projects) {
        this.word = word;
        this.projects = projects;
    }

    public void defaultAction(JTextComponent component) {
        Completion.get().hideCompletion();
        Completion.get().hideDocumentation();
        Document document = component.getDocument();
        DataObject dataObject = (DataObject)document.getProperty("stream");
        FileObject fileObject = dataObject.getPrimaryFile();
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        Locale locale = LocaleQuery.findLocale((FileObject)fileObject);
        DictionaryImpl dictionary = this.projects && project != null ? ComponentPeer.getProjectDictionary(project, locale) : ComponentPeer.getUsersLocalDictionary(locale);
        dictionary.addEntry(this.word);
        ComponentPeer componentPeer = (ComponentPeer)component.getClientProperty(ComponentPeer.class);
        componentPeer.reschedule();
    }

    public void processKeyEvent(KeyEvent evt) {
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.getText(), null, (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        if (selected) {
            g.setColor(backgroundColor);
            g.fillRect(0, 0, width, height);
            g.setColor(defaultColor);
        }
        CompletionUtilities.renderHtml(null, (String)this.getText(), null, (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent component) {
        return true;
    }

    public int getSortPriority() {
        return 200;
    }

    public CharSequence getSortText() {
        return this.getText();
    }

    protected String getText() {
        if (this.projects) {
            return NbBundle.getMessage(AddToDictionaryCompletionItem.class, (String)"CTL_Add_to_projects");
        }
        return NbBundle.getMessage(AddToDictionaryCompletionItem.class, (String)"CTL_Add_to_private");
    }

    public CharSequence getInsertPrefix() {
        return "";
    }
}

