/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker.bindings.htmlxml;

import java.util.Iterator;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.spellchecker.bindings.htmlxml.AbstractTokenList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class HtmlTokenList
extends AbstractTokenList {
    private String fileType;
    private boolean hidden = false;
    private Iterator<TokenSequence<?>> tss;
    private TokenSequence<?> ts;

    public HtmlTokenList(BaseDocument doc, String fileType) {
        super(doc);
        this.fileType = fileType;
    }

    @Override
    public void setStartOffset(int offset) {
        super.setStartOffset(offset);
        if (this.fileType != null) {
            FileObject fileObject = FileUtil.getConfigFile((String)("Spellcheckers/" + this.fileType));
            Boolean b = (Boolean)fileObject.getAttribute("Hidden");
            this.hidden = Boolean.TRUE.equals(b);
        }
        TokenHierarchy th = TokenHierarchy.get((Document)this.doc);
        LanguagePath htmlPath = null;
        Set paths = th.languagePaths();
        for (LanguagePath path : paths) {
            if (path.innerLanguage() != HTMLTokenId.language()) continue;
            if (htmlPath == null) {
                htmlPath = path;
                continue;
            }
            if (htmlPath.size() <= path.size()) continue;
            htmlPath = path;
        }
        assert (htmlPath != null);
        this.tss = th.tokenSequenceList(htmlPath, offset, Integer.MAX_VALUE).iterator();
        if (this.tss.hasNext()) {
            this.ts = this.tss.next();
            this.ts.move(offset);
        }
    }

    @Override
    protected int[] findNextSpellSpan() throws BadLocationException {
        if (this.ts == null || !this.ts.isValid() || this.hidden) {
            return new int[]{-1, -1};
        }
        this.ts.move(this.nextSearchOffset);
        while (this.ts.moveNext()) {
            TokenId id = this.ts.token().id();
            if (id != HTMLTokenId.SGML_COMMENT && id != HTMLTokenId.BLOCK_COMMENT && id != HTMLTokenId.TEXT) continue;
            return new int[]{this.ts.offset(), this.ts.offset() + this.ts.token().length()};
        }
        if (this.tss.hasNext()) {
            this.ts = this.tss.next();
            return this.findNextSpellSpan();
        }
        return new int[]{-1, -1};
    }
}

