/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.webclient.api;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.openide.filesystems.FileObject;

public class RunInfo {
    private final Project project;
    private final RerunHandler rerunHandler;
    private final String testFile;
    private final Map<String, String> envVars = new ConcurrentHashMap<String, String>();
    private boolean testingProject;
    private FileObject[] activatedFOs;
    private boolean isSelenium;
    private boolean showOutput;
    private volatile boolean absoluteUrls = false;

    private RunInfo(Builder builder) {
        assert (builder != null);
        assert (builder.project != null);
        assert (builder.rerunHandler != null);
        this.activatedFOs = builder.activatedFOs;
        this.project = builder.project;
        this.rerunHandler = builder.rerunHandler;
        this.testFile = builder.testFile;
        this.envVars.putAll(builder.envVars);
        this.testingProject = builder.testingProject;
        this.isSelenium = builder.isSelenium;
        this.showOutput = builder.showOutput;
    }

    public FileObject[] getActivatedFOs() {
        return this.activatedFOs;
    }

    public Project getProject() {
        return this.project;
    }

    public RerunHandler getRerunHandler() {
        return this.rerunHandler;
    }

    @CheckForNull
    public String getTestFile() {
        return this.testFile;
    }

    public Map<String, String> getEnvVars() {
        return new HashMap<String, String>(this.envVars);
    }

    public boolean isAbsoluteUrls() {
        return this.absoluteUrls;
    }

    public void setAbsoluteUrls(boolean absoluteUrls) {
        this.absoluteUrls = absoluteUrls;
    }

    public boolean isTestingProject() {
        return this.testingProject;
    }

    public boolean isSelenium() {
        return this.isSelenium;
    }

    public boolean isShowOutput() {
        return this.showOutput;
    }

    public String toString() {
        return "RunInfo{project=" + this.project + ", testFile=" + this.testFile + ", absoluteUrls=" + this.absoluteUrls + '}';
    }

    public static final class Builder {
        final Project project;
        RerunHandler rerunHandler;
        String nbConfigFile;
        String projectConfigFile;
        String testFile;
        Map<String, String> envVars = new HashMap<String, String>();
        boolean testingProject;
        FileObject[] activatedFOs;
        boolean isSelenium;
        boolean showOutput = true;

        public Builder(FileObject[] activatedFOs) {
            assert (activatedFOs != null);
            assert (activatedFOs.length > 0);
            this.activatedFOs = activatedFOs;
            this.project = FileOwnerQuery.getOwner((FileObject)activatedFOs[0]);
        }

        public Builder setShowOutput(boolean showOutput) {
            this.showOutput = showOutput;
            return this;
        }

        public Builder setIsSelenium(boolean isSelenium) {
            this.isSelenium = isSelenium;
            return this;
        }

        public Builder setTestingProject(boolean testingProject) {
            this.testingProject = testingProject;
            return this;
        }

        public Builder setRerunHandler(RerunHandler rerunHandler) {
            assert (rerunHandler != null);
            this.rerunHandler = rerunHandler;
            return this;
        }

        public Builder setTestFile(@NullAllowed String testFile) {
            this.testFile = testFile;
            return this;
        }

        public Builder addEnvVar(String name, String value) {
            assert (name != null);
            assert (value != null);
            this.envVars.put(name, value);
            return this;
        }

        public Builder addEnvVars(Map<String, String> envVars) {
            assert (envVars != null);
            this.envVars.putAll(envVars);
            return this;
        }

        public RunInfo build() {
            return new RunInfo(this);
        }
    }
}

