/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.properties.PropertyBundleEvent;
import org.netbeans.modules.properties.PropertyBundleListener;

public class PropertyBundleSupport
implements Serializable {
    static final long serialVersionUID = -655481419012858008L;
    protected EventListenerList listenerList = new EventListenerList();
    private Object source;

    public PropertyBundleSupport(Object source) {
        if (source == null) {
            throw new NullPointerException();
        }
        this.source = source;
    }

    public void addPropertyBundleListener(PropertyBundleListener l) {
        this.listenerList.add(PropertyBundleListener.class, l);
    }

    public void removePropertyBundleListener(PropertyBundleListener l) {
        this.listenerList.remove(PropertyBundleListener.class, l);
    }

    public void fireBundleStructureChanged() {
        this.fireBundleChanged(new PropertyBundleEvent(this.source, 1));
    }

    public void fireBundleDataChanged() {
        this.fireBundleChanged(new PropertyBundleEvent(this.source, 2));
    }

    public void fireFileChanged(String entryName) {
        this.fireBundleChanged(new PropertyBundleEvent(this.source, entryName));
    }

    public void fireItemChanged(String entryName, String itemName) {
        this.fireBundleChanged(new PropertyBundleEvent(this.source, entryName, itemName));
    }

    public void fireBundleChanged(PropertyBundleEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PropertyBundleListener.class) continue;
            ((PropertyBundleListener)listeners[i + 1]).bundleChanged(e);
        }
    }
}

