/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.TemplatesPanelGUI;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.AsyncGUIJob;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ProjectTemplatePanel
implements WizardDescriptor.Panel<WizardDescriptor> {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private TemplatesPanelGUI panel;
    private WarmupJob warmUp;
    private boolean warmUpActive;
    private boolean needsReselect = false;
    private WizardDescriptor wizard;

    public void readSettings(WizardDescriptor settings) {
        this.wizard = settings;
        this.panel.setWizardDescriptor(this.wizard);
        TemplateWizard wd = (TemplateWizard)settings;
        wd.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(0));
        wd.putProperty("WizardPanel_contentData", (Object)new String[]{NbBundle.getBundle(ProjectTemplatePanel.class).getString("LBL_TemplatesPanel_Name"), NbBundle.getBundle(ProjectTemplatePanel.class).getString("LBL_TemplatesPanel_Dots")});
        FileObject templatesFolder = (FileObject)wd.getProperty("templatesFolder");
        String preselectedCategory = (String)wd.getProperty("PRESELECT_CATEGORY");
        if (templatesFolder != null && templatesFolder.isFolder() && (wd.getTemplate() == null || preselectedCategory != null || this.needsReselect)) {
            String preselectedTemplate = (String)wd.getProperty("PRESELECT_TEMPLATE");
            String selectedCategory = OpenProjectListSettings.getInstance().getLastSelectedProjectCategory();
            String selectedTemplate = OpenProjectListSettings.getInstance().getLastSelectedProjectType();
            String template = preselectedTemplate == null ? (preselectedCategory != null ? null : selectedTemplate) : (preselectedCategory != null ? preselectedTemplate : selectedTemplate);
            TemplatesPanelGUI p = (TemplatesPanelGUI)this.getComponent();
            if (this.isWarmUpActive()) {
                WarmupJob wup = this.getWarmUp();
                wup.setTemplatesFolder(templatesFolder);
                wup.setSelectedCategory(preselectedCategory != null ? preselectedCategory : selectedCategory);
                wup.setSelectedTemplate(template);
            } else {
                p.setTemplatesFolder(templatesFolder);
                p.setSelectedCategoryByName(preselectedCategory != null ? preselectedCategory : selectedCategory);
                p.setSelectedTemplateByName(template);
            }
        }
        wd.putProperty("NewProjectWizard_Title", null);
    }

    public void storeSettings(WizardDescriptor settings) {
        TemplateWizard wd = (TemplateWizard)settings;
        String preselectedCategory = (String)wd.getProperty("PRESELECT_CATEGORY");
        TemplatesPanelGUI gui = (TemplatesPanelGUI)this.getComponent();
        FileObject fo = gui.getSelectedTemplate();
        if (fo != null && fo.isValid()) {
            try {
                wd.setTemplate(DataObject.find((FileObject)fo));
            }
            catch (DataObjectNotFoundException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        if (preselectedCategory == null) {
            String path = gui.getSelectedCategoryName();
            if (path != null) {
                OpenProjectListSettings.getInstance().setLastSelectedProjectCategory(path);
            }
            if ((path = gui.getSelectedTemplateName()) != null) {
                OpenProjectListSettings.getInstance().setLastSelectedProjectType(path);
            }
            this.needsReselect = false;
        } else {
            this.needsReselect = true;
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public boolean isValid() {
        return ((TemplatesPanelGUI)this.getComponent()).getSelectedTemplate() != null;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(ProjectTemplatePanel.class);
    }

    public synchronized Component getComponent() {
        if (this.panel == null) {
            Builder firer = new Builder();
            this.panel = new TemplatesPanelGUI(firer);
            this.panel.setWizardDescriptor(this.wizard);
            Utilities.attachInitJob((Component)this.panel, (AsyncGUIJob)this.getWarmUp());
            this.warmUpActive = true;
            this.panel.setName(NbBundle.getBundle(ProjectTemplatePanel.class).getString("LBL_TemplatesPanel_Name"));
        }
        return this.panel;
    }

    private synchronized WarmupJob getWarmUp() {
        if (this.warmUp == null) {
            this.warmUp = new WarmupJob();
        }
        return this.warmUp;
    }

    private synchronized boolean isWarmUpActive() {
        return this.warmUpActive;
    }

    private class WarmupJob
    implements AsyncGUIJob {
        private FileObject templatesFolder;
        private String category;
        private String template;

        private WarmupJob() {
        }

        public void construct() {
            ProjectTemplatePanel.this.panel.warmUp(this.templatesFolder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            Cursor cursor = null;
            try {
                cursor = ProjectTemplatePanel.this.panel.getCursor();
                ProjectTemplatePanel.this.panel.setCursor(Cursor.getPredefinedCursor(3));
                ProjectTemplatePanel.this.panel.doFinished(this.templatesFolder, this.category, this.template);
            }
            finally {
                if (cursor != null) {
                    ProjectTemplatePanel.this.panel.setCursor(cursor);
                }
                ProjectTemplatePanel projectTemplatePanel = ProjectTemplatePanel.this;
                synchronized (projectTemplatePanel) {
                    ProjectTemplatePanel.this.warmUpActive = false;
                }
            }
        }

        void setTemplatesFolder(FileObject fo) {
            this.templatesFolder = fo;
        }

        void setSelectedCategory(String s) {
            this.category = s;
        }

        void setSelectedTemplate(String s) {
            this.template = s;
        }
    }

    private class Builder
    implements TemplatesPanelGUI.Builder {
        private Builder() {
        }

        @Override
        public Children createCategoriesChildren(DataFolder folder, String filterText) {
            assert (folder != null) : "Folder cannot be null.";
            return new CategoriesChildren(folder, filterText);
        }

        @Override
        public Children createTemplatesChildren(DataFolder folder, String filterText) {
            return new TemplateChildren(folder, filterText);
        }

        @Override
        public String getCategoriesName() {
            return NbBundle.getMessage(ProjectTemplatePanel.class, (String)"CTL_Categories");
        }

        @Override
        public String getTemplatesName() {
            return NbBundle.getMessage(ProjectTemplatePanel.class, (String)"CTL_Projects");
        }

        @Override
        public void fireChange() {
            ProjectTemplatePanel.this.changeSupport.fireChange();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (null != ProjectTemplatePanel.this.wizard) {
                ProjectTemplatePanel.this.wizard.doNextClick();
            }
        }
    }

    private static class TemplateChildren
    extends Children.Keys<DataObject> {
        private DataFolder folder;
        private final String filterText;

        public TemplateChildren(DataFolder folder, String filterText) {
            this.folder = folder;
            this.filterText = filterText;
        }

        protected void addNotify() {
            this.setKeys(this.folder.getChildren());
        }

        protected void removeNotify() {
            this.setKeys(new DataObject[0]);
        }

        protected Node[] createNodes(DataObject dobj) {
            if (dobj.isTemplate()) {
                FilterNode templateNode = new FilterNode(dobj.getNodeDelegate(), Children.LEAF);
                if (null == this.filterText || templateNode.getDisplayName().toLowerCase().contains(this.filterText.toLowerCase())) {
                    return new Node[]{templateNode};
                }
            }
            return new Node[0];
        }
    }

    private static class CategoriesChildren
    extends Children.Keys<DataObject> {
        private DataFolder root;
        private final String filterText;

        public CategoriesChildren(DataFolder folder, String filterText) {
            this.root = folder;
            this.filterText = filterText;
        }

        protected void addNotify() {
            this.setKeys(this.root.getChildren());
        }

        protected void removeNotify() {
            this.setKeys(new DataObject[0]);
        }

        protected Node[] createNodes(DataObject dobj) {
            if (dobj instanceof DataFolder) {
                DataFolder folder = (DataFolder)dobj;
                int type = 0;
                for (DataObject child : folder.getChildren()) {
                    type = 1;
                    if (Boolean.TRUE.equals(child.getPrimaryFile().getAttribute("template")) || !child.getPrimaryFile().isFolder()) continue;
                    type = 2;
                    break;
                }
                if (type == 1) {
                    FilterNode categoryNode = new FilterNode(dobj.getNodeDelegate(), Children.LEAF);
                    boolean hasFilteredChildren = false;
                    for (DataObject child : folder.getChildren()) {
                        if (!child.isTemplate() || null != this.filterText && !child.getNodeDelegate().getDisplayName().toLowerCase().contains(this.filterText.toLowerCase())) continue;
                        hasFilteredChildren = true;
                        break;
                    }
                    if (hasFilteredChildren) {
                        return new Node[]{categoryNode};
                    }
                } else if (type == 2) {
                    return new Node[]{new FilterNode(dobj.getNodeDelegate(), (Children)new CategoriesChildren((DataFolder)dobj, this.filterText))};
                }
            }
            return new Node[0];
        }
    }
}

