/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.GroupEditPanel;
import org.netbeans.modules.project.ui.groups.SubprojectsGroup;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SubprojectsGroupEditPanel
extends GroupEditPanel {
    private final SubprojectsGroup g;
    private JButton masterProjectButton;
    private JTextField masterProjectField;
    private JLabel masterProjectLabel;
    private JTextField nameField;
    private JLabel nameLabel;

    public SubprojectsGroupEditPanel(SubprojectsGroup g) {
        File d;
        this.g = g;
        this.initComponents();
        DocumentListener l = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SubprojectsGroupEditPanel.this.firePropertyChange("ready", null, null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SubprojectsGroupEditPanel.this.firePropertyChange("ready", null, null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.nameField.setText(g.getName());
        this.nameField.getDocument().addDocumentListener(l);
        FileObject dir = g.getMasterProjectDirectory();
        if (dir != null && (d = FileUtil.toFile((FileObject)dir)) != null) {
            this.masterProjectField.setText(d.getAbsolutePath());
        }
        this.masterProjectField.getDocument().addDocumentListener(l);
    }

    @Override
    public void applyChanges() {
        this.g.setName(this.nameField.getText().trim());
        this.updateMasterProject();
    }

    private void updateMasterProject() {
        File f;
        FileObject fo;
        String s = this.masterProjectField.getText();
        if (s != null && s.length() > 0 && (fo = FileUtil.toFileObject((File)(f = new File(s)))) != null && fo.isFolder()) {
            try {
                Project p = ProjectManager.getDefault().findProject(fo);
                if (p != null) {
                    String path = p.getProjectDirectory().toURL().toExternalForm();
                    Preferences pref = Group.NODE.node(this.g.id);
                    pref.put("path", path);
                    if (this.g.equals(Group.getActiveGroup())) {
                        RequestProcessor.getDefault().post(new Runnable(){

                            @Override
                            public void run() {
                                Group.open(SubprojectsGroupEditPanel.this.g, null, false, null);
                            }
                        });
                    }
                }
            }
            catch (IOException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.masterProjectLabel = new JLabel();
        this.masterProjectField = new JTextField();
        this.masterProjectButton = new JButton();
        this.nameLabel.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(SubprojectsGroupEditPanel.class, (String)"SubprojectsGroupEditPanel.nameLabel.text"));
        this.masterProjectLabel.setLabelFor(this.masterProjectField);
        Mnemonics.setLocalizedText((JLabel)this.masterProjectLabel, (String)NbBundle.getMessage(SubprojectsGroupEditPanel.class, (String)"SubprojectsGroupEditPanel.masterProjectLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.masterProjectButton, (String)NbBundle.getMessage(SubprojectsGroupEditPanel.class, (String)"SubprojectsGroupEditPanel.masterProjectButton.text"));
        this.masterProjectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubprojectsGroupEditPanel.this.masterProjectButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLabel).addComponent(this.masterProjectLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameField, -1, 304, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.masterProjectField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.masterProjectButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.masterProjectLabel).addComponent(this.masterProjectField, -2, -1, -2).addComponent(this.masterProjectButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SubprojectsGroupEditPanel.class, (String)"SubprojectsGroupEditPanel.nameLabel.AccessibleContext.accessibleDescription"));
        this.nameField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SubprojectsGroupEditPanel.class, (String)"SubprojectsGroupEditPanel.nameField.AccessibleContext.accessibleName"));
        this.nameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SubprojectsGroupEditPanel.class, (String)"SubprojectsGroupEditPanel.nameField.AccessibleContext.accessibleDescription"));
        this.masterProjectLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SubprojectsGroupEditPanel.class, (String)"SubprojectsGroupEditPanel.masterProjectLabel.AccessibleContext.accessibleDescription"));
        this.masterProjectField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SubprojectsGroupEditPanel.class, (String)"SubprojectsGroupEditPanel.masterProjectField.AccessibleContext.accessibleName"));
        this.masterProjectField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SubprojectsGroupEditPanel.class, (String)"SubprojectsGroupEditPanel.masterProjectField.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SubprojectsGroupEditPanel.class, (String)"SubprojectsGroupEditPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SubprojectsGroupEditPanel.class, (String)"SubprojectsGroupEditPanel.AccessibleContext.accessibleDescription"));
    }

    private void masterProjectButtonActionPerformed(ActionEvent evt) {
        File f;
        JFileChooser chooser = ProjectChooser.projectChooser();
        if (chooser.showOpenDialog(this) == 0 && (f = chooser.getSelectedFile()) != null) {
            this.masterProjectField.setText(f.getAbsolutePath());
        }
    }

    @Override
    public boolean isReady() {
        if (!this.doCheckExistingGroups(this.nameField, this.g)) {
            return false;
        }
        String s = this.masterProjectField.getText();
        if (s == null || s.length() == 0) {
            return false;
        }
        File f = FileUtil.normalizeFile((File)new File(s));
        FileObject fo = FileUtil.toFileObject((File)f);
        if (fo != null && fo.isFolder()) {
            try {
                return ProjectManager.getDefault().findProject(fo) != null;
            }
            catch (IOException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        } else {
            return false;
        }
        return true;
    }
}

