/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.FilteringToolbar;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.utils.formatting.DefaultMethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.Formattable;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.java.ExternalPackages;
import org.netbeans.modules.profiler.api.java.ProfilerTypeUtils;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.api.java.SourcePackageInfo;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.SessionStorage;
import org.netbeans.modules.profiler.v2.impl.Bundle;
import org.netbeans.modules.profiler.v2.impl.WeakProcessor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public final class ClassMethodSelector {
    private static final WeakProcessor PROCESSOR = new WeakProcessor("Profiler ClassMethodSelector Processor");
    private static final MethodNameFormatter METHOD_FORMATTER = new DefaultMethodNameFormatter(2);
    private static final int LIST_WIDTH = 200;
    private static final Preferences PREF = NbPreferences.forModule(ClassMethodSelector.class);

    public static List<SourceClassInfo> selectClasses(ProfilerSession session) {
        UI ui = UI.forSession(session, false);
        HelpCtx helpCtx = new HelpCtx("SelectClassDialog.HelpCtx");
        DialogDescriptor dd = new DialogDescriptor((Object)ui, Bundle.ClassMethodSelector_selectClass(), true, new Object[]{ui.getOKButton(), DialogDescriptor.CANCEL_OPTION}, (Object)ui.getOKButton(), 0, helpCtx, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.setVisible(true);
        return dd.getValue() == ui.getOKButton() ? ui.selectedClasses() : Collections.EMPTY_LIST;
    }

    public static List<SourceMethodInfo> selectMethods(ProfilerSession session) {
        UI ui = UI.forSession(session, true);
        HelpCtx helpCtx = new HelpCtx("SelectMethodDialog.HelpCtx");
        DialogDescriptor dd = new DialogDescriptor((Object)ui, Bundle.ClassMethodSelector_selectMethod(), true, new Object[]{ui.getOKButton(), DialogDescriptor.CANCEL_OPTION}, (Object)ui.getOKButton(), 0, helpCtx, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.setVisible(true);
        return dd.getValue() == ui.getOKButton() ? ui.selectedMethods() : Collections.EMPTY_LIST;
    }

    private ClassMethodSelector() {
    }

    private static abstract class FilteredListModel<E>
    implements ListModel<E> {
        private final Collection<ListDataListener> listeners;
        private final ListModel<E> data;
        private ListSelectionModel selection;
        private E selected;
        private GenericFilter filter;
        private final List<Integer> indices;

        public FilteredListModel(ListModel data) {
            this.data = data;
            this.listeners = new HashSet<ListDataListener>();
            this.indices = new ArrayList<Integer>();
            this.doFilter();
            this.data.addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent e) {
                    this.doFilter();
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    this.doFilter();
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                    this.doFilter();
                }
            });
        }

        protected abstract boolean matchesFilter(E var1, GenericFilter var2);

        public void setSelectionModel(final ListSelectionModel selection) {
            this.selection = selection;
            selection.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int index = selection.getMinSelectionIndex();
                        selected = index == -1 ? null : this.getElementAt(index);
                    }
                }
            });
        }

        public void setFilter(GenericFilter filter) {
            this.filter = filter.isAll() ? null : filter;
            this.doFilter();
        }

        public GenericFilter getFilter() {
            return this.filter;
        }

        @Override
        public int getSize() {
            return this.filter == null ? this.data.getSize() : this.indices.size();
        }

        @Override
        public E getElementAt(int index) {
            return this.data.getElementAt(this.filter == null ? index : this.indices.get(index));
        }

        @Override
        public void addListDataListener(ListDataListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeListDataListener(ListDataListener listener) {
            this.listeners.remove(listener);
        }

        private void doFilter() {
            E element;
            int i;
            this.indices.clear();
            int _selected = -1;
            if (this.filter != null) {
                for (i = 0; i < this.data.getSize(); ++i) {
                    element = this.data.getElementAt(i);
                    if (!this.matchesFilter(element, this.filter)) continue;
                    if (this.selection != null && element.equals(this.selected)) {
                        _selected = this.indices.size();
                    }
                    this.indices.add(i);
                }
            } else if (this.selection != null) {
                for (i = 0; i < this.data.getSize(); ++i) {
                    element = this.data.getElementAt(i);
                    if (!element.equals(this.selected)) continue;
                    _selected = i;
                }
            }
            if (!this.listeners.isEmpty()) {
                ListDataEvent event = new ListDataEvent(this, 0, 0, this.indices.size());
                for (ListDataListener listener : this.listeners) {
                    listener.contentsChanged(event);
                }
            }
            if (this.selection != null) {
                if (_selected == -1) {
                    this.selection.clearSelection();
                } else {
                    this.selection.setSelectionInterval(_selected, _selected);
                }
            }
        }
    }

    private static class HintRenderer
    extends LabelRenderer {
        HintRenderer() {
            super(true);
            this.setHorizontalAlignment(0);
            this.setForeground(UIUtils.getDisabledLineColor());
        }

        void setup(Boolean mode, Dimension size) {
            if (Boolean.FALSE.equals(mode)) {
                this.setText(Bundle.ClassMethodSelector_lblComputing());
            } else if (Boolean.TRUE.equals(mode)) {
                this.setText(Bundle.ClassMethodSelector_lblNoItems());
            } else {
                this.setText(Bundle.ClassMethodSelector_lblNoSelection());
            }
            this.setSize(size);
        }
    }

    private static abstract class MethodSelector
    extends JPanel {
        private final JList<SourceMethodInfo> methodsList;
        private final DefaultListModel<SourceMethodInfo> methodsListModel = new DefaultListModel();
        private final AbstractButton methodsInheritedB;
        private final AbstractButton methodsNonPublicB;
        private final AbstractButton methodsStaticB;
        private boolean isInitialized;

        abstract void methodSelected();

        abstract void reload();

        SourceMethodInfo getSelected() {
            return this.methodsList.getSelectedValue();
        }

        List<SourceMethodInfo> getAllSelected() {
            return this.methodsList.getSelectedValuesList();
        }

        void init(final SourceClassInfo _class) {
            this.isInitialized = _class != null;
            this.methodsListModel.clear();
            this.methodsList.setEnabled(!this.isInitialized);
            if (this.isInitialized) {
                final boolean inherited = this.methodsInheritedB.isSelected();
                final boolean nonpublic = this.methodsNonPublicB.isSelected();
                final boolean staticc = this.methodsStaticB.isSelected();
                PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        final Collection methods = MethodSelector.getMethods(_class, inherited, nonpublic, staticc);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                methodsList.setEnabled(true);
                                for (SourceMethodInfo mthd : methods) {
                                    methodsListModel.addElement(mthd);
                                }
                            }
                        });
                    }
                });
            }
        }

        private static Collection<SourceMethodInfo> getMethods(SourceClassInfo cls, boolean inherited, boolean nonpublic, boolean staticc) {
            TreeSet<SourceMethodInfo> sortedMethods = new TreeSet<SourceMethodInfo>(new Comparator<SourceMethodInfo>(){

                @Override
                public int compare(SourceMethodInfo m1, SourceMethodInfo m2) {
                    Formattable f1 = METHOD_FORMATTER.formatMethodName("", m1.getName(), m1.getSignature());
                    Formattable f2 = METHOD_FORMATTER.formatMethodName("", m2.getName(), m2.getSignature());
                    return f1.toFormatted().compareTo(f2.toFormatted());
                }
            });
            HashSet methods = new HashSet(cls.getConstructors());
            methods.addAll(cls.getMethods(inherited));
            for (SourceMethodInfo method : methods) {
                int modifiers = method.getModifiers();
                if (!nonpublic && !Modifier.isPublic(modifiers) || !staticc && Modifier.isStatic(modifiers)) continue;
                sortedMethods.add(method);
            }
            return sortedMethods;
        }

        MethodSelector() {
            final FilteredListModel<SourceMethodInfo> filteredMethods = new FilteredListModel<SourceMethodInfo>(this.methodsListModel){

                @Override
                protected boolean matchesFilter(SourceMethodInfo mtd, GenericFilter filter) {
                    return filter.passes(mtd.getName());
                }
            };
            final HintRenderer hintRenderer = new HintRenderer();
            this.methodsList = new JList(filteredMethods){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    Dimension dim = super.getPreferredScrollableViewportSize();
                    dim.width = 200;
                    return dim;
                }

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (this.getModel().getSize() == 0) {
                        if (!this.isEnabled()) {
                            hintRenderer.setup(false, this.getSize());
                        } else if (isInitialized) {
                            hintRenderer.setup(true, this.getSize());
                        } else {
                            hintRenderer.setup(null, this.getSize());
                        }
                        hintRenderer.paint(g);
                    }
                }
            };
            this.methodsList.setSelectionMode(2);
            filteredMethods.setSelectionModel(this.methodsList.getSelectionModel());
            this.methodsList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    DefaultListCellRenderer c = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    SourceMethodInfo val = (SourceMethodInfo)value;
                    c.setText(METHOD_FORMATTER.formatMethodName("", val.getName(), val.getSignature()).toFormatted());
                    c.setIcon(Icons.getIcon((String)"LanguageIcons.MethodPublic"));
                    return c;
                }
            });
            this.methodsList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        this.methodSelected();
                    }
                }
            });
            JLabel methodsLabel = new JLabel(Bundle.ClassMethodSelector_capMethods(), 10);
            methodsLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.methodsInheritedB = new JToggleButton(Icons.getIcon((String)"LanguageIcons.MethodInheritedStatic")){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    super.fireActionPerformed(e);
                    this.reload();
                    PREF.putBoolean("Profiler.CMS.methodsInheritedB", methodsInheritedB.isSelected());
                }
            };
            this.methodsInheritedB.putClientProperty("JButton.buttonType", "segmented");
            this.methodsInheritedB.putClientProperty("JButton.segmentPosition", "first");
            this.methodsInheritedB.setToolTipText(Bundle.ClassMethodSelector_showInheritedMethods());
            this.methodsInheritedB.setSelected(PREF.getBoolean("Profiler.CMS.methodsInheritedB", false));
            this.methodsNonPublicB = new JToggleButton(Icons.getIcon((String)"LanguageIcons.MethodPrivate")){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    super.fireActionPerformed(e);
                    this.reload();
                    PREF.putBoolean("Profiler.CMS.methodsNonPublicB", methodsNonPublicB.isSelected());
                }
            };
            this.methodsNonPublicB.putClientProperty("JButton.buttonType", "segmented");
            this.methodsNonPublicB.putClientProperty("JButton.segmentPosition", "middle");
            this.methodsNonPublicB.setToolTipText(Bundle.ClassMethodSelector_showNonPublicMethods());
            this.methodsNonPublicB.setSelected(PREF.getBoolean("Profiler.CMS.methodsNonPublicB", true));
            this.methodsStaticB = new JToggleButton(Icons.getIcon((String)"LanguageIcons.MethodPublicStatic")){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    super.fireActionPerformed(e);
                    this.reload();
                    PREF.putBoolean("Profiler.CMS.methodsStaticB", methodsStaticB.isSelected());
                }
            };
            this.methodsStaticB.putClientProperty("JButton.buttonType", "segmented");
            this.methodsStaticB.putClientProperty("JButton.segmentPosition", "last");
            this.methodsStaticB.setToolTipText(Bundle.ClassMethodSelector_showStaticMethods());
            this.methodsStaticB.setSelected(PREF.getBoolean("Profiler.CMS.methodsStaticB", true));
            FilteringToolbar methodsTools = new FilteringToolbar(Bundle.ClassMethodSelector_lblFilterItems()){

                protected void filterChanged() {
                    filteredMethods.setFilter(this.getFilter());
                }
            };
            methodsTools.add(Box.createHorizontalStrut(2));
            methodsTools.addSeparator();
            methodsTools.add(Box.createHorizontalStrut(2));
            methodsTools.add(this.methodsInheritedB);
            methodsTools.add(Box.createHorizontalStrut(2));
            methodsTools.add(this.methodsStaticB);
            methodsTools.add(Box.createHorizontalStrut(2));
            methodsTools.add(this.methodsNonPublicB);
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.add((Component)methodsLabel, "North");
            this.add((Component)new JScrollPane(this.methodsList), "Center");
            this.add((Component)methodsTools, "South");
        }
    }

    private static abstract class ClassSelector
    extends JPanel {
        private final JList<SourceClassInfo> classesList;
        private final DefaultListModel<SourceClassInfo> classesListModel = new DefaultListModel();
        private final AbstractButton classesInnerB;
        private final AbstractButton classesAnonymousB;
        private boolean isInitialized;

        abstract void classSelected();

        abstract void reload();

        SourceClassInfo getSelected() {
            return this.classesList.getSelectedValue();
        }

        List<SourceClassInfo> getAllSelected() {
            return this.classesList.getSelectedValuesList();
        }

        void init(final SourcePackageInfo _package) {
            this.isInitialized = _package != null;
            this.classesListModel.clear();
            this.classesList.setEnabled(!this.isInitialized);
            if (this.isInitialized) {
                final boolean inner = this.classesInnerB.isSelected();
                final boolean anonymous = this.classesAnonymousB.isSelected();
                PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        final Collection classes = ClassSelector.getClasses(_package, inner, anonymous);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                classesList.setEnabled(true);
                                for (SourceClassInfo clss : classes) {
                                    classesListModel.addElement(clss);
                                }
                            }
                        });
                    }
                });
            }
        }

        private static Collection<SourceClassInfo> getClasses(SourcePackageInfo pkg, boolean inner, boolean anonymous) {
            HashSet<SourceClassInfo> classes = pkg.getClasses();
            if (inner) {
                HashSet<SourceClassInfo> _classes = new HashSet<SourceClassInfo>();
                while (!classes.isEmpty()) {
                    SourceClassInfo cls = (SourceClassInfo)classes.iterator().next();
                    classes.remove(cls);
                    if (anonymous || !cls.isAnonymous()) {
                        _classes.add(cls);
                    }
                    classes.addAll(cls.getInnerClases());
                }
                classes = _classes;
            }
            TreeSet<SourceClassInfo> sortedClasses = new TreeSet<SourceClassInfo>(new Comparator<SourceClassInfo>(){

                @Override
                public int compare(SourceClassInfo c1, SourceClassInfo c2) {
                    return c1.getSimpleName().compareTo(c2.getSimpleName());
                }
            });
            sortedClasses.addAll(classes);
            return sortedClasses;
        }

        ClassSelector(boolean singleSelection) {
            final FilteredListModel<SourceClassInfo> filteredClasses = new FilteredListModel<SourceClassInfo>(this.classesListModel){

                @Override
                protected boolean matchesFilter(SourceClassInfo cls, GenericFilter filter) {
                    return filter.passes(cls.getSimpleName());
                }
            };
            final HintRenderer hintRenderer = new HintRenderer();
            this.classesList = new JList(filteredClasses){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    Dimension dim = super.getPreferredScrollableViewportSize();
                    dim.width = 200;
                    return dim;
                }

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (this.getModel().getSize() == 0) {
                        if (!this.isEnabled()) {
                            hintRenderer.setup(false, this.getSize());
                        } else if (isInitialized) {
                            hintRenderer.setup(true, this.getSize());
                        } else {
                            hintRenderer.setup(null, this.getSize());
                        }
                        hintRenderer.paint(g);
                    }
                }
            };
            this.classesList.setSelectionMode(singleSelection ? 0 : 2);
            filteredClasses.setSelectionModel(this.classesList.getSelectionModel());
            this.classesList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    DefaultListCellRenderer c = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    SourceClassInfo val = (SourceClassInfo)value;
                    c.setText(val.getSimpleName());
                    c.setIcon(Icons.getIcon((String)"LanguageIcons.Class"));
                    return c;
                }
            });
            this.classesList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        this.classSelected();
                    }
                }
            });
            JLabel classesLabel = new JLabel(Bundle.ClassMethodSelector_capClasses(), 10);
            classesLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.classesInnerB = new JToggleButton(Icons.getIcon((String)"LanguageIcons.Class")){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    super.fireActionPerformed(e);
                    this.reload();
                    classesAnonymousB.setEnabled(this.isSelected());
                    PREF.putBoolean("Profiler.CMS.classesInnerB", classesInnerB.isSelected());
                }
            };
            this.classesInnerB.putClientProperty("JButton.buttonType", "segmented");
            this.classesInnerB.putClientProperty("JButton.segmentPosition", "first");
            this.classesInnerB.setToolTipText(Bundle.ClassMethodSelector_showInnerClasses());
            this.classesInnerB.setSelected(PREF.getBoolean("Profiler.CMS.classesInnerB", true));
            this.classesAnonymousB = new JToggleButton(Icons.getIcon((String)"LanguageIcons.ClassAnonymous")){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    super.fireActionPerformed(e);
                    this.reload();
                    PREF.putBoolean("Profiler.CMS.classesAnonymousB", classesAnonymousB.isSelected());
                }

                @Override
                public void setEnabled(boolean enabled) {
                    super.setEnabled(enabled);
                    if (!this.isEnabled()) {
                        this.setSelected(false);
                    }
                }
            };
            this.classesAnonymousB.putClientProperty("JButton.buttonType", "segmented");
            this.classesAnonymousB.putClientProperty("JButton.segmentPosition", "last");
            this.classesAnonymousB.setToolTipText(Bundle.ClassMethodSelector_showAnonymousClasses());
            this.classesAnonymousB.setSelected(PREF.getBoolean("Profiler.CMS.classesAnonymousB", false));
            FilteringToolbar classesTools = new FilteringToolbar(Bundle.ClassMethodSelector_lblFilterItems()){

                protected void filterChanged() {
                    filteredClasses.setFilter(this.getFilter());
                }
            };
            classesTools.add(Box.createHorizontalStrut(2));
            classesTools.addSeparator();
            classesTools.add(Box.createHorizontalStrut(2));
            classesTools.add(this.classesInnerB);
            classesTools.add(Box.createHorizontalStrut(2));
            classesTools.add(this.classesAnonymousB);
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.add((Component)classesLabel, "North");
            this.add((Component)new JScrollPane(this.classesList), "Center");
            this.add((Component)classesTools, "South");
        }
    }

    private static abstract class PackageSelector
    extends JPanel {
        private final JList<SourcePackageInfo> packageList;
        private final DefaultListModel<SourcePackageInfo> packageListModel = new DefaultListModel();
        private final AbstractButton packagesSourcesB;
        private final AbstractButton packagesDependenciesB;
        private boolean isInitialized;

        abstract void packageSelected();

        abstract void reload();

        SourcePackageInfo getSelected() {
            return this.packageList.getSelectedValue();
        }

        void init(final Lookup.Provider _project) {
            this.isInitialized = _project != null;
            this.packageListModel.clear();
            this.packageList.setEnabled(!this.isInitialized);
            if (this.isInitialized) {
                final boolean sources = this.packagesSourcesB.isSelected();
                final boolean dependencies = this.packagesDependenciesB.isSelected();
                PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        final Collection packages = PackageSelector.getProjectPackages(_project, sources, dependencies);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                packageList.setEnabled(true);
                                for (SourcePackageInfo pkg : packages) {
                                    packageListModel.addElement(pkg);
                                }
                            }
                        });
                    }
                });
            }
        }

        void init(final FileObject _file) {
            this.isInitialized = _file != null;
            this.packageListModel.clear();
            this.packageList.setEnabled(!this.isInitialized);
            if (this.isInitialized) {
                PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        final Collection packages = PackageSelector.getFilePackages(_file);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                packageList.setEnabled(true);
                                for (SourcePackageInfo pkg : packages) {
                                    packageListModel.addElement(pkg);
                                }
                            }
                        });
                    }
                });
            }
        }

        private static Collection<SourcePackageInfo> getProjectPackages(Lookup.Provider project, boolean sources, boolean dependencies) {
            HashSet packages = new HashSet();
            if (sources) {
                packages.addAll(ProfilerTypeUtils.getPackages((boolean)false, (SourcePackageInfo.Scope)SourcePackageInfo.Scope.SOURCE, (Lookup.Provider)project));
            }
            if (dependencies) {
                packages.addAll(ProfilerTypeUtils.getPackages((boolean)false, (SourcePackageInfo.Scope)SourcePackageInfo.Scope.DEPENDENCIES, (Lookup.Provider)project));
            }
            TreeSet<SourcePackageInfo> sortedPackages = new TreeSet<SourcePackageInfo>(new Comparator<SourcePackageInfo>(){

                @Override
                public int compare(SourcePackageInfo p1, SourcePackageInfo p2) {
                    return p1.getBinaryName().compareTo(p2.getBinaryName());
                }
            });
            sortedPackages.addAll(packages);
            return sortedPackages;
        }

        private static Collection<SourcePackageInfo> getFilePackages(FileObject file) {
            HashSet packages = new HashSet(ExternalPackages.forPath((FileObject)file, (boolean)true));
            TreeSet<SourcePackageInfo> sortedPackages = new TreeSet<SourcePackageInfo>(new Comparator<SourcePackageInfo>(){

                @Override
                public int compare(SourcePackageInfo p1, SourcePackageInfo p2) {
                    return p1.getBinaryName().compareTo(p2.getBinaryName());
                }
            });
            sortedPackages.addAll(packages);
            return sortedPackages;
        }

        PackageSelector(boolean fromProject) {
            final FilteredListModel<SourcePackageInfo> filteredPackages = new FilteredListModel<SourcePackageInfo>(this.packageListModel){

                @Override
                protected boolean matchesFilter(SourcePackageInfo pkg, GenericFilter filter) {
                    return filter.passes(pkg.getBinaryName());
                }
            };
            final HintRenderer hintRenderer = new HintRenderer();
            this.packageList = new JList(filteredPackages){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    Dimension dim = super.getPreferredScrollableViewportSize();
                    dim.width = 200;
                    return dim;
                }

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (this.getModel().getSize() == 0) {
                        if (!this.isEnabled()) {
                            hintRenderer.setup(false, this.getSize());
                        } else if (isInitialized) {
                            hintRenderer.setup(true, this.getSize());
                        } else {
                            hintRenderer.setup(null, this.getSize());
                        }
                        hintRenderer.paint(g);
                    }
                }
            };
            this.packageList.setSelectionMode(0);
            filteredPackages.setSelectionModel(this.packageList.getSelectionModel());
            this.packageList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    DefaultListCellRenderer c = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    SourcePackageInfo val = (SourcePackageInfo)value;
                    c.setText(val.getBinaryName());
                    c.setIcon(Icons.getIcon((String)"LanguageIcons.Package"));
                    return c;
                }
            });
            this.packageList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        this.packageSelected();
                    }
                }
            });
            JLabel packagesLabel = new JLabel(Bundle.ClassMethodSelector_capPackages(), 10);
            packagesLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            FilteringToolbar packagesTools = new FilteringToolbar(Bundle.ClassMethodSelector_lblFilterItems()){

                protected void filterChanged() {
                    filteredPackages.setFilter(this.getFilter());
                }
            };
            if (fromProject) {
                this.packagesSourcesB = new JToggleButton(Icons.getIcon((String)"LanguageIcons.Constructors")){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        this.reload();
                        PREF.putBoolean("Profiler.CMS.packagesSourcesB", packagesSourcesB.isSelected());
                    }
                };
                this.packagesSourcesB.putClientProperty("JButton.buttonType", "segmented");
                this.packagesSourcesB.putClientProperty("JButton.segmentPosition", "first");
                this.packagesSourcesB.setToolTipText(Bundle.ClassMethodSelector_showProjectPackages());
                this.packagesSourcesB.setSelected(PREF.getBoolean("Profiler.CMS.packagesSourcesB", true));
                this.packagesDependenciesB = new JToggleButton(Icons.getIcon((String)"LanguangeIcons.Jar")){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        this.reload();
                        PREF.putBoolean("Profiler.CMS.packagesDependenciesB", packagesDependenciesB.isSelected());
                    }
                };
                this.packagesDependenciesB.putClientProperty("JButton.buttonType", "segmented");
                this.packagesDependenciesB.putClientProperty("JButton.segmentPosition", "last");
                this.packagesDependenciesB.setToolTipText(Bundle.ClassMethodSelector_showDependenciesPackages());
                this.packagesDependenciesB.setSelected(PREF.getBoolean("Profiler.CMS.packagesDependenciesB", false));
                packagesTools.add(Box.createHorizontalStrut(2));
                packagesTools.addSeparator();
                packagesTools.add(Box.createHorizontalStrut(2));
                packagesTools.add(this.packagesSourcesB);
                packagesTools.add(Box.createHorizontalStrut(2));
                packagesTools.add(this.packagesDependenciesB);
            } else {
                this.packagesSourcesB = null;
                this.packagesDependenciesB = null;
            }
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.add((Component)packagesLabel, "North");
            this.add((Component)new JScrollPane(this.packageList), "Center");
            this.add((Component)packagesTools, "South");
        }
    }

    private static abstract class ProjectSelector
    extends JPanel {
        private final JList<Lookup.Provider> projectList;
        private final DefaultListModel<Lookup.Provider> projectListModel = new DefaultListModel();
        private boolean isInitialized;

        abstract void projectSelected();

        Lookup.Provider getSelected() {
            return this.projectList.getSelectedValue();
        }

        void init(final Lookup.Provider _project) {
            this.isInitialized = true;
            this.projectListModel.clear();
            this.projectList.setEnabled(!this.isInitialized);
            if (this.isInitialized) {
                PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        final Lookup.Provider[] projects = ProjectSelector.getProjects();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                projectList.setEnabled(true);
                                for (Lookup.Provider prj : projects) {
                                    projectListModel.addElement(prj);
                                }
                                if (_project != null) {
                                    projectList.setSelectedValue(_project, true);
                                }
                            }
                        });
                    }
                });
            }
        }

        private static Lookup.Provider[] getProjects() {
            return ProjectUtilities.getSortedProjects((Lookup.Provider[])ProjectUtilities.getOpenedProjects());
        }

        ProjectSelector() {
            final FilteredListModel<Lookup.Provider> filteredProjects = new FilteredListModel<Lookup.Provider>(this.projectListModel){

                @Override
                protected boolean matchesFilter(Lookup.Provider proj, GenericFilter filter) {
                    return filter.passes(ProjectUtilities.getDisplayName((Lookup.Provider)proj));
                }
            };
            final HintRenderer hintRenderer = new HintRenderer();
            this.projectList = new JList(filteredProjects){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    Dimension dim = super.getPreferredScrollableViewportSize();
                    dim.width = 200;
                    return dim;
                }

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (this.getModel().getSize() == 0) {
                        hintRenderer.setup(true, this.getSize());
                        hintRenderer.paint(g);
                    }
                }
            };
            this.projectList.setSelectionMode(0);
            filteredProjects.setSelectionModel(this.projectList.getSelectionModel());
            this.projectList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    DefaultListCellRenderer c = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    Lookup.Provider val = (Lookup.Provider)value;
                    c.setText(ProjectUtilities.getDisplayName((Lookup.Provider)val));
                    c.setIcon(ProjectUtilities.getIcon((Lookup.Provider)val));
                    return c;
                }
            });
            this.projectList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        this.projectSelected();
                    }
                }
            });
            JLabel projectsLabel = new JLabel(Bundle.ClassMethodSelector_capProjects(), 10);
            projectsLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            FilteringToolbar projectsTools = new FilteringToolbar(Bundle.ClassMethodSelector_lblFilterItems()){

                protected void filterChanged() {
                    filteredProjects.setFilter(this.getFilter());
                }
            };
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.add((Component)projectsLabel, "North");
            this.add((Component)new JScrollPane(this.projectList), "Center");
            this.add((Component)projectsTools, "South");
        }
    }

    private static abstract class FileSelector
    extends JPanel {
        private final JList<FileObject> fileList;
        private final DefaultListModel<FileObject> fileListModel = new DefaultListModel();
        private final AbstractButton addFileB;
        private final AbstractButton removeFileB;
        private boolean isInitialized;

        abstract void fileSelected();

        abstract SessionStorage getStorage();

        FileObject getSelected() {
            return this.fileList.getSelectedValue();
        }

        void init() {
            this.isInitialized = true;
            this.fileListModel.clear();
            this.fileList.setEnabled(!this.isInitialized);
            if (this.isInitialized) {
                PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        SessionStorage _storage = this.getStorage();
                        final Collection files = FileSelector.getFiles(_storage);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                fileList.setEnabled(true);
                                for (FileObject fo : files) {
                                    fileListModel.addElement(fo);
                                }
                            }
                        });
                    }
                });
            }
        }

        private static Collection<FileObject> getFiles(SessionStorage _storage) {
            ArrayList<FileObject> files = new ArrayList<FileObject>();
            String _files = _storage.readFlag("CMS.files", "");
            if (!_files.isEmpty()) {
                for (String file : _files.split("#")) {
                    FileObject fo;
                    File f = new File(file);
                    FileObject fileObject = fo = f.exists() ? FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f)) : null;
                    if (fo == null) continue;
                    files.add(fo);
                }
            }
            return files;
        }

        private void persist() {
            StringBuilder sb = new StringBuilder();
            Enumeration<FileObject> files = this.fileListModel.elements();
            while (files.hasMoreElements()) {
                FileObject file = files.nextElement();
                sb.append(FileUtil.toFile((FileObject)file).getAbsolutePath());
                if (!files.hasMoreElements()) continue;
                sb.append("#");
            }
            if (sb.length() == 0) {
                this.getStorage().storeFlag("CMS.files", null);
            } else {
                this.getStorage().storeFlag("CMS.files", sb.toString());
            }
        }

        FileSelector() {
            final FilteredListModel<FileObject> filteredFiles = new FilteredListModel<FileObject>(this.fileListModel){

                @Override
                protected boolean matchesFilter(FileObject file, GenericFilter filter) {
                    return filter.passes(file.getNameExt());
                }
            };
            final HintRenderer hintRenderer = new HintRenderer();
            this.fileList = new JList(filteredFiles){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    Dimension dim = super.getPreferredScrollableViewportSize();
                    dim.width = 200;
                    return dim;
                }

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (this.getModel().getSize() == 0) {
                        hintRenderer.setup(true, this.getSize());
                        hintRenderer.paint(g);
                    }
                }
            };
            this.fileList.setSelectionMode(0);
            filteredFiles.setSelectionModel(this.fileList.getSelectionModel());
            this.fileList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    DefaultListCellRenderer c = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    FileObject file = (FileObject)value;
                    c.setText(file.getNameExt());
                    c.setIcon(Icons.getIcon((String)(file.isFolder() ? "LanguageIcons.Libraries" : "LanguangeIcons.Jar")));
                    return c;
                }
            });
            this.fileList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        this.fileSelected();
                        removeFileB.setEnabled(fileList.getSelectedValue() != null);
                    }
                }
            });
            JLabel projectsLabel = new JLabel(Bundle.ClassMethodSelector_capFiles(), 10);
            projectsLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            FilteringToolbar fileTools = new FilteringToolbar(Bundle.ClassMethodSelector_lblFilterItems()){

                protected void filterChanged() {
                    filteredFiles.setFilter(this.getFilter());
                }
            };
            String iconMask = "GeneralIcons.Folder";
            Image baseIcon = Icons.getImage((String)iconMask);
            Image addBadge = Icons.getImage((String)"GeneralIcons.BadgeAdd");
            Image addImage = ImageUtilities.mergeImages((Image)baseIcon, (Image)addBadge, (int)0, (int)0);
            this.addFileB = new JButton(ImageUtilities.image2Icon((Image)addImage)){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    FileObject f;
                    super.fireActionPerformed(e);
                    FileChooserBuilder b = new FileChooserBuilder(ClassMethodSelector.class);
                    b.setAcceptAllFileFilterUsed(false);
                    File file = b.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            if (f.isDirectory()) {
                                return true;
                            }
                            String ext = null;
                            String n = f.getName();
                            int index = n.lastIndexOf(".");
                            if (index > -1) {
                                ext = n.substring(index + 1);
                            }
                            return ext != null && ext.equalsIgnoreCase("jar");
                        }

                        @Override
                        public String getDescription() {
                            return Bundle.ClassMethodSelector_jarsFoldersFilterDescr();
                        }
                    }).setTitle(Bundle.ClassMethodSelector_selectJarOrFolder()).showOpenDialog();
                    if (file != null && (f = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file))) != null) {
                        fileListModel.addElement(f);
                        this.persist();
                    }
                }
            };
            this.addFileB.setToolTipText(Bundle.ClassMethodSelector_addFileOrFolder());
            Image removeBadge = Icons.getImage((String)"GeneralIcons.BadgeRemove");
            Image removeImage = ImageUtilities.mergeImages((Image)baseIcon, (Image)removeBadge, (int)0, (int)0);
            this.removeFileB = new JButton(ImageUtilities.image2Icon((Image)removeImage)){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    super.fireActionPerformed(e);
                    List files = fileList.getSelectedValuesList();
                    if (!files.isEmpty()) {
                        for (FileObject file : files) {
                            fileListModel.removeElement(file);
                        }
                        this.persist();
                    }
                }
            };
            this.removeFileB.setToolTipText(Bundle.ClassMethodSelector_removeSelectedItem());
            this.removeFileB.setEnabled(this.fileList.getSelectedValue() != null);
            fileTools.add(Box.createHorizontalStrut(2));
            fileTools.addSeparator();
            fileTools.add(Box.createHorizontalStrut(2));
            fileTools.add(this.addFileB);
            fileTools.add(Box.createHorizontalStrut(2));
            fileTools.add(this.removeFileB);
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.add((Component)projectsLabel, "North");
            this.add((Component)new JScrollPane(this.fileList), "Center");
            this.add((Component)fileTools, "South");
        }
    }

    private static class UI
    extends JPanel {
        private final JButton okButton = new JButton(Bundle.ClassMethodSelector_btnOk());
        private final JPanel p_selectors;
        private final MethodSelector p_methodSelector;
        private final ClassSelector p_classSelector;
        private final PackageSelector p_packageSelector;
        private final ProjectSelector p_projectSelector;
        private final JPanel f_selectors;
        private final MethodSelector f_methodSelector;
        private final ClassSelector f_classSelector;
        private final PackageSelector f_packageSelector;
        private final FileSelector f_fileSelector;
        private JComponent selected;

        static UI forSession(ProfilerSession session, boolean method) {
            return new UI(session, method);
        }

        JButton getOKButton() {
            return this.okButton;
        }

        List<SourceClassInfo> selectedClasses() {
            if (this.p_selectors == this.selected && this.p_classSelector != null) {
                return this.p_classSelector.getAllSelected();
            }
            if (this.f_selectors == this.selected && this.f_classSelector != null) {
                return this.f_classSelector.getAllSelected();
            }
            return null;
        }

        List<SourceMethodInfo> selectedMethods() {
            if (this.p_selectors == this.selected && this.p_methodSelector != null) {
                return this.p_methodSelector.getAllSelected();
            }
            if (this.f_selectors == this.selected && this.f_methodSelector != null) {
                return this.f_methodSelector.getAllSelected();
            }
            return null;
        }

        private UI(final ProfilerSession session, final boolean method) {
            this.okButton.setEnabled(false);
            final boolean[] p_init = new boolean[1];
            if (session.getProject() != null) {
                this.p_methodSelector = method ? new MethodSelector(){

                    @Override
                    void methodSelected() {
                        okButton.setEnabled(this.getSelected() != null);
                    }

                    @Override
                    void reload() {
                        this.init(p_classSelector.getSelected());
                    }
                } : null;
                this.p_classSelector = new ClassSelector(method){

                    @Override
                    void classSelected() {
                        if (!method) {
                            okButton.setEnabled(this.getSelected() != null);
                        } else {
                            p_methodSelector.init(this.getSelected());
                        }
                    }

                    @Override
                    void reload() {
                        this.init(p_packageSelector.getSelected());
                    }
                };
                this.p_packageSelector = new PackageSelector(true){

                    @Override
                    void packageSelected() {
                        p_classSelector.init(this.getSelected());
                    }

                    @Override
                    void reload() {
                        this.init(p_projectSelector.getSelected());
                    }
                };
                this.p_projectSelector = new ProjectSelector(){

                    @Override
                    void projectSelected() {
                        p_packageSelector.init(this.getSelected());
                    }
                };
                this.p_selectors = new JPanel(new GridLayout(1, method ? 4 : 3, 10, 10));
                this.p_selectors.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
                this.p_selectors.add(this.p_projectSelector);
                this.p_selectors.add(this.p_packageSelector);
                this.p_selectors.add(this.p_classSelector);
                if (method) {
                    this.p_selectors.add(this.p_methodSelector);
                }
            } else {
                this.p_selectors = null;
                this.p_methodSelector = null;
                this.p_classSelector = null;
                this.p_packageSelector = null;
                this.p_projectSelector = null;
            }
            final boolean[] f_init = new boolean[1];
            this.f_methodSelector = method ? new MethodSelector(){

                @Override
                void methodSelected() {
                    okButton.setEnabled(this.getSelected() != null);
                }

                @Override
                void reload() {
                    this.init(f_classSelector.getSelected());
                }
            } : null;
            this.f_classSelector = new ClassSelector(method){

                @Override
                void classSelected() {
                    if (!method) {
                        okButton.setEnabled(this.getSelected() != null);
                    } else {
                        f_methodSelector.init(this.getSelected());
                    }
                }

                @Override
                void reload() {
                    this.init(f_packageSelector.getSelected());
                }
            };
            this.f_packageSelector = new PackageSelector(false){

                @Override
                void packageSelected() {
                    f_classSelector.init(this.getSelected());
                }

                @Override
                void reload() {
                    this.init(f_fileSelector.getSelected());
                }
            };
            this.f_fileSelector = new FileSelector(){

                @Override
                void fileSelected() {
                    f_packageSelector.init(this.getSelected());
                }

                @Override
                SessionStorage getStorage() {
                    return session.getStorage();
                }
            };
            this.f_selectors = new JPanel(new GridLayout(1, method ? 4 : 3, 10, 10));
            this.f_selectors.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
            this.f_selectors.add(this.f_fileSelector);
            this.f_selectors.add(this.f_packageSelector);
            this.f_selectors.add(this.f_classSelector);
            if (method) {
                this.f_selectors.add(this.f_methodSelector);
            }
            JTabbedPane p = new JTabbedPane(){

                @Override
                protected void fireStateChanged() {
                    super.fireStateChanged();
                    Component sel = this.getSelectedComponent();
                    if (sel == p_selectors) {
                        selected = p_selectors;
                        if (!p_init[0]) {
                            p_projectSelector.init(session.getProject());
                            p_init[0] = true;
                        }
                        if (p_methodSelector != null) {
                            p_methodSelector.methodSelected();
                        } else {
                            p_classSelector.classSelected();
                        }
                    } else if (sel == f_selectors) {
                        selected = f_selectors;
                        if (!f_init[0]) {
                            f_fileSelector.init();
                            f_init[0] = true;
                        }
                        if (f_methodSelector != null) {
                            f_methodSelector.methodSelected();
                        } else {
                            f_classSelector.classSelected();
                        }
                    }
                }
            };
            if (UIUtils.isAquaLookAndFeel()) {
                p.setBorder(BorderFactory.createEmptyBorder(0, -11, -13, -10));
            } else {
                Insets i = UIManager.getInsets("TabbedPane.contentBorderInsets");
                if (i == null) {
                    p.setBorder(BorderFactory.createEmptyBorder());
                } else {
                    p.setBorder(BorderFactory.createEmptyBorder(0, -i.left, -i.bottom, -i.right));
                }
            }
            if (this.p_selectors != null) {
                p.addTab(Bundle.ClassMethodSelector_capFromProject(), null, this.p_selectors, null);
            }
            if (this.f_selectors != null) {
                p.addTab(Bundle.ClassMethodSelector_capFromJarFolder(), null, this.f_selectors, null);
            }
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.add((Component)p, "Center");
        }
    }
}

