/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.features;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.filters.TextFilter;
import org.netbeans.lib.profiler.results.jdbc.JdbcCCTProvider;
import org.netbeans.lib.profiler.ui.swing.TextArea;
import org.netbeans.modules.profiler.v2.features.Bundle;
import org.netbeans.modules.profiler.v2.features.FeatureMode;
import org.netbeans.modules.profiler.v2.ui.SettingsPanel;
import org.openide.util.NbPreferences;

class SQLFeatureModes {
    SQLFeatureModes() {
    }

    static abstract class FilteredQueriesMode
    extends SQLMode {
        private static final String QUERIES_FILTER_FLAG = "QUERIES_FILTER_FLAG";
        private static final int MIN_ROWS = 1;
        private static final int MAX_ROWS = 15;
        private static final int DEFAULT_ROWS = 3;
        private static final int MIN_COLUMNS = 10;
        private static final int MAX_COLUMNS = 100;
        private static final int DEFAULT_COLUMNS = 50;
        private JComponent ui;
        private TextArea filterArea;

        FilteredQueriesMode() {
        }

        @Override
        String getID() {
            return "FilteredQueriesMode";
        }

        @Override
        String getName() {
            return Bundle.SQLFeatureModes_filteredQueries();
        }

        @Override
        void configureSettings(ProfilingSettings settings) {
            super.configureSettings(settings);
            String filter = FilteredQueriesMode.getFlatValues(this.readFlag(QUERIES_FILTER_FLAG, "").split("\\n"));
            settings.setInstrumentationFilter((GenericFilter)new TextFilter(filter, 10, false));
        }

        @Override
        void confirmSettings() {
            if (this.ui != null && this.filterArea != null) {
                assert (SwingUtilities.isEventDispatchThread());
                String filter = this.filterArea.showsHint() ? "" : this.filterArea.getText().trim();
                this.storeFlag(QUERIES_FILTER_FLAG, filter.isEmpty() ? null : filter);
            }
        }

        @Override
        boolean pendingChanges() {
            if (this.ui != null) {
                String filter;
                assert (SwingUtilities.isEventDispatchThread());
                String string = filter = this.filterArea.showsHint() ? "" : this.filterArea.getText().trim();
                if (!filter.equals(this.readFlag(QUERIES_FILTER_FLAG, ""))) {
                    return true;
                }
            }
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            assert (SwingUtilities.isEventDispatchThread());
            return !(this.ui != null ? this.filterArea.showsHint() || this.filterArea.getText().trim().isEmpty() : this.readFlag(QUERIES_FILTER_FLAG, "").isEmpty());
        }

        private static String getFlatValues(String[] values) {
            StringBuilder convertedValue = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                String filterValue = values[i].trim();
                if (i != values.length - 1 && !filterValue.endsWith(",")) {
                    filterValue = filterValue + ",";
                }
                convertedValue.append(filterValue);
            }
            return convertedValue.toString();
        }

        @Override
        JComponent getUI() {
            if (this.ui == null) {
                JPanel p = new JPanel(new GridBagLayout());
                p.setOpaque(false);
                SettingsPanel classesPanel = new SettingsPanel();
                classesPanel.add(new JLabel(Bundle.SQLFeatureModes_queryContains()));
                GridBagConstraints c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 0;
                c.fill = 0;
                c.insets = new Insets(0, 0, 0, 5);
                c.anchor = 18;
                p.add((Component)classesPanel, c);
                final JScrollPane[] container = new JScrollPane[1];
                this.filterArea = new TextArea(this.readFlag(QUERIES_FILTER_FLAG, "")){

                    protected void changed() {
                        FilteredQueriesMode.this.settingsChanged();
                    }

                    protected boolean changeSize(boolean vertical, boolean direction) {
                        if (vertical) {
                            int rows = FilteredQueriesMode.this.readRows();
                            rows = direction ? Math.min(rows + 1, 15) : Math.max(rows - 1, 1);
                            FilteredQueriesMode.this.storeRows(rows);
                        } else {
                            int cols = FilteredQueriesMode.this.readColumns();
                            cols = direction ? Math.min(cols + 3, 100) : Math.max(cols - 3, 10);
                            FilteredQueriesMode.this.storeColumns(cols);
                        }
                        this.layoutImpl();
                        return true;
                    }

                    protected boolean resetSize() {
                        FilteredQueriesMode.this.storeRows(3);
                        FilteredQueriesMode.this.storeColumns(50);
                        this.layoutImpl();
                        return true;
                    }

                    private void layoutImpl() {
                        this.setRows(FilteredQueriesMode.this.readRows());
                        this.setColumns(FilteredQueriesMode.this.readColumns());
                        container[0].setPreferredSize(null);
                        container[0].setPreferredSize(container[0].getPreferredSize());
                        container[0].setMinimumSize(container[0].getPreferredSize());
                        JRootPane root = SwingUtilities.getRootPane(container[0]);
                        root.doLayout();
                        root.repaint();
                        this.setColumns(0);
                    }

                    protected void customizePopup(JPopupMenu popup) {
                        popup.addSeparator();
                        popup.add(this.createResizeMenu());
                    }

                    public Point getToolTipLocation(MouseEvent event) {
                        Container scroll = this.getParent().getParent();
                        return SwingUtilities.convertPoint(scroll, 0, scroll.getHeight(), (Component)((Object)this));
                    }
                };
                this.filterArea.setFont(new Font("Monospaced", 0, this.filterArea.getFont().getSize()));
                this.filterArea.setRows(this.readRows());
                this.filterArea.setColumns(this.readColumns());
                container[0] = new JScrollPane((Component)this.filterArea);
                container[0].setPreferredSize(container[0].getPreferredSize());
                container[0].setMinimumSize(container[0].getPreferredSize());
                this.filterArea.setColumns(0);
                this.filterArea.setHint(Bundle.SQLFeatureModes_filterHint());
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 0;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.fill = 3;
                c.insets = new Insets(0, 0, 0, 5);
                c.anchor = 18;
                p.add((Component)container[0], c);
                this.ui = p;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FilteredQueriesMode.this.settingsChanged();
                    }
                });
            }
            return this.ui;
        }

        private int readRows() {
            return NbPreferences.forModule(SQLFeatureModes.class).getInt("SQLFeatureModes.rows", 3);
        }

        private void storeRows(int rows) {
            NbPreferences.forModule(SQLFeatureModes.class).putInt("SQLFeatureModes.rows", rows);
        }

        private int readColumns() {
            return NbPreferences.forModule(SQLFeatureModes.class).getInt("SQLFeatureModes.columns", 50);
        }

        private void storeColumns(int columns) {
            NbPreferences.forModule(SQLFeatureModes.class).putInt("SQLFeatureModes.columns", columns);
        }
    }

    static abstract class AllQueriesMode
    extends SQLMode {
        AllQueriesMode() {
        }

        @Override
        String getID() {
            return "AllQueriesMode";
        }

        @Override
        String getName() {
            return Bundle.SQLFeatureModes_allQueries();
        }

        @Override
        void configureSettings(ProfilingSettings settings) {
            super.configureSettings(settings);
            settings.setInstrumentationFilter((GenericFilter)new TextFilter());
        }

        @Override
        void confirmSettings() {
        }

        @Override
        boolean pendingChanges() {
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            return true;
        }

        @Override
        JComponent getUI() {
            return null;
        }
    }

    private static abstract class SQLMode
    extends FeatureMode {
        private static final String[] JDBC_MARKER_CLASSES = new String[]{JdbcCCTProvider.DRIVER_INTERFACE, JdbcCCTProvider.CONNECTION_INTERFACE, JdbcCCTProvider.STATEMENT_INTERFACE, JdbcCCTProvider.PREPARED_STATEMENT_INTERFACE, JdbcCCTProvider.CALLABLE_STATEMENT_INTERFACE};

        private SQLMode() {
        }

        @Override
        void configureSettings(ProfilingSettings settings) {
            settings.setProfilingType(256);
            settings.setCPUProfilingType(0);
            ClientUtils.SourceCodeSelection[] roots = new ClientUtils.SourceCodeSelection[JDBC_MARKER_CLASSES.length];
            for (int i = 0; i < JDBC_MARKER_CLASSES.length; ++i) {
                roots[i] = new ClientUtils.SourceCodeSelection(JDBC_MARKER_CLASSES[i], "*", null);
                roots[i].setMarkerMethod(true);
            }
            settings.addRootMethods(roots);
        }
    }
}

