/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.options.ui.v2.impl;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.options.ui.v2.ProfilerOptionsPanel;
import org.netbeans.modules.profiler.options.ui.v2.impl.Bundle;
import org.openide.awt.Mnemonics;

public final class EngineOptionsPanel
extends ProfilerOptionsPanel {
    private JCheckBox excludeTimeCheckbox;
    private JCheckBox instrumentEmptyMethodsCheckbox;
    private JCheckBox instrumentGettersSettersCheckbox;
    private JCheckBox instrumentMethodInvokeCheckbox;
    private JCheckBox limitThreadsCheckbox;
    private JCheckBox profileSpawnedThreadsCheckbox;
    private JComboBox instrumentationSchemeCombo;
    private JRadioButton exactTimingRadio;
    private JRadioButton sampledTimingRadio;
    private JSpinner limitThreadsSpinner;
    private JSpinner sampledTimingSpinner;
    private JSpinner samplingFrequencySpinner;
    private JCheckBox runGCCheckbox;
    private JCheckBox sampledThreadsChoice;

    public EngineOptionsPanel() {
        this.initUI();
    }

    @Override
    public String getDisplayName() {
        return Bundle.EngineOptionsPanel_Name();
    }

    @Override
    public void storeTo(ProfilerIDESettings settings) {
        ProfilingSettings pSettings = settings.getDefaultProfilingSettings();
        pSettings.setSamplingFrequency(((Integer)this.samplingFrequencySpinner.getValue()).intValue());
        int samplingInterval = (Integer)this.sampledTimingSpinner.getValue();
        if (this.exactTimingRadio.isSelected()) {
            samplingInterval = -samplingInterval;
        }
        pSettings.setSamplingInterval(samplingInterval);
        pSettings.setExcludeWaitTime(this.excludeTimeCheckbox.isSelected());
        pSettings.setInstrumentSpawnedThreads(this.profileSpawnedThreadsCheckbox.isSelected());
        int limitThreads = (Integer)this.limitThreadsSpinner.getValue();
        if (!this.limitThreadsCheckbox.isSelected()) {
            limitThreads = -limitThreads;
        }
        pSettings.setNProfiledThreadsLimit(limitThreads);
        int instrScheme = this.instrumentationSchemeCombo.getSelectedIndex();
        if (instrScheme == 0) {
            pSettings.setInstrScheme(1);
        } else if (instrScheme == 1) {
            pSettings.setInstrScheme(2);
        } else {
            pSettings.setInstrScheme(3);
        }
        pSettings.setInstrumentMethodInvoke(this.instrumentMethodInvokeCheckbox.isSelected());
        pSettings.setInstrumentGetterSetterMethods(this.instrumentGettersSettersCheckbox.isSelected());
        pSettings.setInstrumentEmptyMethods(this.instrumentEmptyMethodsCheckbox.isSelected());
        pSettings.setRunGCOnGetResultsInMemoryProfiling(this.runGCCheckbox.isSelected());
        pSettings.setThreadsSamplingEnabled(this.sampledThreadsChoice.isSelected());
        settings.saveDefaultProfilingSettings();
    }

    @Override
    public void loadFrom(ProfilerIDESettings settings) {
        ProfilingSettings pSettings = settings.getDefaultProfilingSettings();
        this.samplingFrequencySpinner.setValue(pSettings.getSamplingFrequency());
        int samplingInterval = pSettings.getSamplingInterval();
        this.exactTimingRadio.setSelected(samplingInterval <= 0);
        this.sampledTimingRadio.setSelected(samplingInterval > 0);
        this.sampledTimingSpinner.setValue(Math.abs(samplingInterval));
        this.excludeTimeCheckbox.setSelected(pSettings.getExcludeWaitTime());
        this.profileSpawnedThreadsCheckbox.setSelected(pSettings.getInstrumentSpawnedThreads());
        int limitThreads = pSettings.getNProfiledThreadsLimit();
        this.limitThreadsCheckbox.setSelected(limitThreads > 0);
        this.limitThreadsSpinner.setValue(Math.abs(limitThreads));
        int instrScheme = pSettings.getInstrScheme();
        if (instrScheme == 1) {
            this.instrumentationSchemeCombo.setSelectedIndex(0);
        } else if (instrScheme == 2) {
            this.instrumentationSchemeCombo.setSelectedIndex(1);
        } else {
            this.instrumentationSchemeCombo.setSelectedIndex(2);
        }
        this.instrumentMethodInvokeCheckbox.setSelected(pSettings.getInstrumentMethodInvoke());
        this.instrumentGettersSettersCheckbox.setSelected(pSettings.getInstrumentGetterSetterMethods());
        this.instrumentEmptyMethodsCheckbox.setSelected(pSettings.getInstrumentEmptyMethods());
        this.runGCCheckbox.setSelected(pSettings.getRunGCOnGetResultsInMemoryProfiling());
        this.sampledThreadsChoice.setSelected(pSettings.getThreadsSamplingEnabled());
    }

    @Override
    public boolean equalsTo(ProfilerIDESettings settings) {
        ProfilingSettings pSettings = settings.getDefaultProfilingSettings();
        if (!Objects.equals(this.samplingFrequencySpinner.getValue(), pSettings.getSamplingFrequency())) {
            return false;
        }
        int samplingInterval = pSettings.getSamplingInterval();
        if (samplingInterval > 0 ? !this.sampledTimingRadio.isSelected() : !this.exactTimingRadio.isSelected()) {
            return false;
        }
        if (!Objects.equals(this.sampledTimingSpinner.getValue(), Math.abs(samplingInterval))) {
            return false;
        }
        if (this.excludeTimeCheckbox.isSelected() != pSettings.getExcludeWaitTime()) {
            return false;
        }
        if (this.profileSpawnedThreadsCheckbox.isSelected() != pSettings.getInstrumentSpawnedThreads()) {
            return false;
        }
        int limitThreads = pSettings.getNProfiledThreadsLimit();
        if (limitThreads > 0 && !this.limitThreadsCheckbox.isSelected()) {
            return false;
        }
        if (!Objects.equals(this.limitThreadsSpinner.getValue(), Math.abs(limitThreads))) {
            return false;
        }
        int instrScheme = this.instrumentationSchemeCombo.getSelectedIndex();
        if (instrScheme == 0 && pSettings.getInstrScheme() != 1) {
            return false;
        }
        if (instrScheme == 1 && pSettings.getInstrScheme() != 2) {
            return false;
        }
        if (instrScheme == 2 && pSettings.getInstrScheme() != 3) {
            return false;
        }
        if (this.instrumentMethodInvokeCheckbox.isSelected() != pSettings.getInstrumentMethodInvoke()) {
            return false;
        }
        if (this.instrumentGettersSettersCheckbox.isSelected() != pSettings.getInstrumentGetterSetterMethods()) {
            return false;
        }
        if (this.instrumentEmptyMethodsCheckbox.isSelected() != pSettings.getInstrumentEmptyMethods()) {
            return false;
        }
        if (this.runGCCheckbox.isSelected() != pSettings.getRunGCOnGetResultsInMemoryProfiling()) {
            return false;
        }
        return this.sampledThreadsChoice.isSelected() == pSettings.getThreadsSamplingEnabled();
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        int y = 0;
        int htab = 8;
        int hgap = 10;
        int vgap = 5;
        ProfilerOptionsPanel.Separator cpuSettingsSeparator = new ProfilerOptionsPanel.Separator(Bundle.EngineOptionsPanel_MethodsProfiling());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(0, 0, vgap * 2, 0);
        this.add((Component)cpuSettingsSeparator, c);
        JLabel methodsSamplingLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)methodsSamplingLabel, (String)Bundle.EngineOptionsPanel_MethodsGeneral());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, htab, vgap, 0);
        this.add((Component)methodsSamplingLabel, c);
        JLabel samplingFrequencyLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)samplingFrequencyLabel, (String)Bundle.StpSamplingFrequencyLabel());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, htab * 2, vgap, 0);
        this.add((Component)samplingFrequencyLabel, c);
        this.samplingFrequencySpinner = new JExtendedSpinner((SpinnerModel)new SpinnerNumberModel(10, 1, 65535, 1));
        samplingFrequencyLabel.setLabelFor(this.samplingFrequencySpinner);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, hgap, vgap, 0);
        this.add((Component)this.samplingFrequencySpinner, c);
        JLabel samplingFrequencyUnitsLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)samplingFrequencyUnitsLabel, (String)Bundle.StpSamplingFrequencyMs());
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = y++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, hgap / 2, vgap, 0);
        this.add((Component)samplingFrequencyUnitsLabel, c);
        JLabel methodsInstrumentingLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)methodsInstrumentingLabel, (String)Bundle.EngineOptionsPanel_MethodsFocused());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(vgap * 2, htab, vgap, 3);
        this.add((Component)methodsInstrumentingLabel, c);
        JLabel methodsTrackingLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)methodsTrackingLabel, (String)Bundle.CPUSettingsAdvancedPanel_MethodsTrackingLabelText());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, htab * 2, vgap, 0);
        this.add((Component)methodsTrackingLabel, c);
        ButtonGroup methodsTrackingRadiosGroup = new ButtonGroup();
        this.exactTimingRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.exactTimingRadio, (String)Bundle.CPUSettingsAdvancedPanel_InstrRadioText());
        methodsTrackingRadiosGroup.add(this.exactTimingRadio);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, htab * 2 + hgap, 0, 0);
        this.add((Component)this.exactTimingRadio, c);
        this.sampledTimingRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.sampledTimingRadio, (String)Bundle.CPUSettingsAdvancedPanel_SamplingRadioText());
        methodsTrackingRadiosGroup.add(this.sampledTimingRadio);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, htab * 2 + hgap, vgap, 0);
        this.add((Component)this.sampledTimingRadio, c);
        this.sampledTimingSpinner = new JExtendedSpinner((SpinnerModel)new SpinnerNumberModel(10, 1, 65535, 1));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, hgap, vgap, 0);
        this.add((Component)this.sampledTimingSpinner, c);
        JLabel sampledTimingUnitsLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)sampledTimingUnitsLabel, (String)Bundle.StpSamplingFrequencyMs());
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = y++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, hgap / 2, vgap, 0);
        this.add((Component)sampledTimingUnitsLabel, c);
        this.excludeTimeCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.excludeTimeCheckbox, (String)Bundle.CPUSettingsAdvancedPanel_ExcludeTimeCheckboxText());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, htab * 2, vgap, 0);
        this.add((Component)this.excludeTimeCheckbox, c);
        this.profileSpawnedThreadsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.profileSpawnedThreadsCheckbox, (String)Bundle.CPUSettingsAdvancedPanel_ProfileThreadsCheckboxText());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, htab * 2, vgap, 0);
        this.add((Component)this.profileSpawnedThreadsCheckbox, c);
        this.limitThreadsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.limitThreadsCheckbox, (String)Bundle.CPUSettingsAdvancedPanel_LimitThreadsCheckboxText());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, htab * 2, vgap, 0);
        this.add((Component)this.limitThreadsCheckbox, c);
        this.limitThreadsSpinner = new JExtendedSpinner((SpinnerModel)new SpinnerNumberModel(50, 1, 65535, 1));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y++;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, hgap, vgap, 0);
        this.add((Component)this.limitThreadsSpinner, c);
        JLabel instrumentationSchemeLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)instrumentationSchemeLabel, (String)Bundle.CPUSettingsAdvancedPanel_InstrSchemeLabelText());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, htab * 2, vgap, 0);
        this.add((Component)instrumentationSchemeLabel, c);
        this.instrumentationSchemeCombo = new JComboBox<String>(new String[]{Bundle.CPUSettingsAdvancedPanel_SchemeComboBoxItemLazy(), Bundle.CPUSettingsAdvancedPanel_SchemeComboBoxItemEager(), Bundle.CPUSettingsAdvancedPanel_SchemeComboBoxItemTotal()});
        instrumentationSchemeLabel.setLabelFor(this.instrumentationSchemeCombo);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y++;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, hgap, vgap, 0);
        this.add((Component)this.instrumentationSchemeCombo, c);
        JLabel instrumentLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)instrumentLabel, (String)Bundle.CPUSettingsAdvancedPanel_InstrumentLabelText());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, htab * 2, vgap, 0);
        this.add((Component)instrumentLabel, c);
        this.instrumentMethodInvokeCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.instrumentMethodInvokeCheckbox, (String)Bundle.CPUSettingsAdvancedPanel_MethodInvokeCheckboxText());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, htab * 2 + hgap, 0, 0);
        this.add((Component)this.instrumentMethodInvokeCheckbox, c);
        this.instrumentGettersSettersCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.instrumentGettersSettersCheckbox, (String)Bundle.CPUSettingsAdvancedPanel_GetterSetterCheckboxText());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, htab * 2 + hgap, 0, 0);
        this.add((Component)this.instrumentGettersSettersCheckbox, c);
        this.instrumentEmptyMethodsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.instrumentEmptyMethodsCheckbox, (String)Bundle.CPUSettingsAdvancedPanel_EmptyMethodsCheckboxText());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, htab * 2 + hgap, vgap, 0);
        this.add((Component)this.instrumentEmptyMethodsCheckbox, c);
        ProfilerOptionsPanel.Separator memorySettingsSeparator = new ProfilerOptionsPanel.Separator(Bundle.EngineOptionsPanel_ObjectsProfiling());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(vgap * 4, 0, vgap * 2, 0);
        this.add((Component)memorySettingsSeparator, c);
        this.runGCCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.runGCCheckbox, (String)Bundle.MemorySettingsAdvancedPanel_RunGcCheckboxText());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, htab, vgap, 0);
        this.add((Component)this.runGCCheckbox, c);
        ProfilerOptionsPanel.Separator dataTransferSeparator = new ProfilerOptionsPanel.Separator(Bundle.EngineOptionsPanel_ThreadsProfiling());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(vgap * 4, 0, vgap * 2, 0);
        this.add((Component)dataTransferSeparator, c);
        this.sampledThreadsChoice = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.sampledThreadsChoice, (String)Bundle.EngineOptionsPanel_SampleThreads());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(0, htab, vgap, 0);
        this.add((Component)this.sampledThreadsChoice, c);
        JPanel filler = UIUtils.createFillerPanel();
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 18;
        c.gridwidth = 0;
        c.fill = 1;
        this.add((Component)filler, c);
    }
}

