/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.api;

import java.util.Collection;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.modules.profiler.api.Bundle;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.spi.java.GoToSourceProvider;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class GoToSource {
    private static final RequestProcessor srcOpenerRP = new RequestProcessor("Profiler Source Opener");

    public static boolean isAvailable() {
        return Lookup.getDefault().lookup(GoToSourceProvider.class) != null;
    }

    public static void openFile(final FileObject srcFile, final int offset) {
        srcOpenerRP.post(new Runnable(){

            @Override
            public void run() {
                GoToSource.openFileImpl(srcFile, offset);
            }
        });
    }

    public static void openSource(Lookup.Provider project, String className, String methodName, String methodSig) {
        GoToSource.openSource(project, className, methodName, methodSig, -1);
    }

    public static void openSource(Lookup.Provider project, String className, String methodName, int line) {
        GoToSource.openSource(project, className, methodName, null, line);
    }

    private static void openSource(final Lookup.Provider project, final String className, final String methodName, final String signature, final int line) {
        srcOpenerRP.post(new Runnable(){

            @Override
            public void run() {
                GoToSource.openSourceImpl(project, className, methodName, signature, line);
            }
        });
    }

    private static void openSourceImpl(Lookup.Provider project, String className, String methodName, String signature, int line) {
        int idx;
        int n = idx = methodName == null ? -1 : methodName.indexOf("[native]");
        if (idx > -1) {
            methodName = methodName.substring(0, idx);
        }
        ProfilerLogger.debug((String)("Open Source: Project: " + project));
        ProfilerLogger.debug((String)("Open Source: Class name: " + className));
        ProfilerLogger.debug((String)("Open Source: Method name: " + methodName));
        ProfilerLogger.debug((String)("Open Source: Method sig: " + signature));
        Collection implementations = Lookup.getDefault().lookupAll(GoToSourceProvider.class);
        String st = Bundle.OpeningSourceMsg(className);
        String finalStatusText = st + " ...";
        StatusDisplayer.getDefault().setStatusText(finalStatusText);
        for (GoToSourceProvider impl : implementations) {
            try {
                if (!impl.openSource(project, className, methodName, signature, line)) continue;
                return;
            }
            catch (Exception e) {
                ProfilerLogger.log((Exception)e);
            }
        }
        ProfilerDialogs.displayError(Bundle.NoSourceFoundMessage(className));
    }

    private static void openFileImpl(FileObject srcFile, int offset) {
        ProfilerLogger.debug((String)("Open Source: FileObject: " + srcFile));
        ProfilerLogger.debug((String)("Open Source: Offset: " + offset));
        Collection implementations = Lookup.getDefault().lookupAll(GoToSourceProvider.class);
        String st = Bundle.OpeningFileMsg(srcFile.getName());
        String finalStatusText = st + " ...";
        StatusDisplayer.getDefault().setStatusText(finalStatusText);
        for (GoToSourceProvider impl : implementations) {
            try {
                if (!impl.openFile(srcFile, offset)) continue;
                return;
            }
            catch (Exception e) {
                ProfilerLogger.log((Exception)e);
            }
        }
        ProfilerDialogs.displayError(Bundle.OpenFileFailsMessage(srcFile.getName(), offset));
    }
}

